//[workflow-runtime](../../../../index.md)/[com.squareup.workflow1](../../index.md)/[WorkflowInterceptor](../index.md)/[RenderContextInterceptor](index.md)/[onRunningSideEffect](on-running-side-effect.md)

# onRunningSideEffect

[common]\
open fun [onRunningSideEffect](on-running-side-effect.md)(key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), sideEffect: suspend () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-unit/index.html), proceed: (key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), sideEffect: suspend () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-unit/index.html)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-unit/index.html))

Intercepts calls to BaseRenderContext.runningSideEffect, allowing the interceptor to wrap or replace the [sideEffect](on-running-side-effect.md) and its [key](on-running-side-effect.md). This could be used to prevent a side effect from running, or to augment it with further effects.

The [sideEffect](on-running-side-effect.md) function will perform the actual suspending side effect, and only return when the side effect is complete – this may be far in the future. This means the interceptor can be notified when the side effect *ends* by simply running code after [sideEffect](on-running-side-effect.md) returns or throws.

The interceptor may run [sideEffect](on-running-side-effect.md) in a different [CoroutineContext](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.coroutines/-coroutine-context/index.html), e.g to change its dispatcher or name, but should take care to use the original Job, or otherwise ensure that the structured concurrency contract is not broken.
