//[workflow-runtime](../../../index.md)/[com.squareup.workflow1](../index.md)/[WorkflowInterceptor](index.md)

# WorkflowInterceptor

[common]\
interface [WorkflowInterceptor](index.md)

Provides hooks into the workflow runtime that can be used to instrument or modify the behavior of workflows.

This interface's methods mirror the methods of StatefulWorkflow. It also has one additional method, [onSessionStarted](on-session-started.md), that is notified when a workflow is started. Each method returns the same thing as the corresponding method on StatefulWorkflow, and receives the same parameters as well as two extra parameters:

- 
   `proceed` – A function that *exactly* mirrors the corresponding function on     StatefulWorkflow, accepting the same parameters and returning the same thing. An interceptor     can call this function to run the actual workflow, but it may also decide to not call it at     all, or call it multiple times.
- 
   `session` – A [WorkflowSession](-workflow-session/index.md) object that can be queried for information about the     workflow being intercepted. Note that this object carries [parent](-workflow-session/parent.md)     information. So we can use the session object to determine if we are the root Workflow if     session.parent == null.

All methods have default no-op implementations.

##  On Profiling

Note that the [WorkflowInterceptor](index.md)'s methods will call the actual methods with the proceed function. This means that we have hooks before and after the actual method making it very straightforward to trace/measure the timing of any part of any workflow, or of the whole tree.

##  Workflow sessions

A single workflow may be rendered by different parents at the same time, or the same parent at different, disjoint times. Each continuous sequence of renderings of a particular workflow type, with the same key passed to BaseRenderContext.renderChild, is called a &quot;session&quot; of that workflow. The workflow's StatefulWorkflow.initialState method will be called at the start of the session, and its state will be maintained by the runtime until the session is finished. Each session is identified by the [WorkflowSession](-workflow-session/index.md) object passed into the corresponding method in a [WorkflowInterceptor](index.md).

In addition to the WorkflowIdentifier of the type of the workflow being rendered, this object also knows the [key](-workflow-session/render-key.md) used to render the workflow and the [WorkflowSession](-workflow-session/index.md) of the [parent](-workflow-session/parent.md) workflow that is rendering it.

Each session is also assigned a numerical ID that uniquely identifies the session over the life of the entire runtime. This value will remain constant as long as the workflow's parent is rendering it, and then it will never be used again. If this workflow stops being rendered, and then starts again, the value will be different.

## Types

| Name | Summary |
|---|---|
| [RenderContextInterceptor](-render-context-interceptor/index.md) | [common]<br>interface [RenderContextInterceptor](-render-context-interceptor/index.md)&lt;[P](-render-context-interceptor/index.md), [S](-render-context-interceptor/index.md), [O](-render-context-interceptor/index.md)&gt;<br>Provides hooks for intercepting calls to a BaseRenderContext, to be used from [onRender](on-render.md). |
| [WorkflowSession](-workflow-session/index.md) | [common]<br>interface [WorkflowSession](-workflow-session/index.md)<br>Information about the session of a workflow in the runtime that a [WorkflowInterceptor](index.md) method is intercepting. |

## Functions

| Name | Summary |
|---|---|
| [onInitialState](on-initial-state.md) | [common]<br>open fun &lt;[P](on-initial-state.md), [S](on-initial-state.md)&gt; [onInitialState](on-initial-state.md)(props: [P](on-initial-state.md), snapshot: Snapshot?, proceed: ([P](on-initial-state.md), Snapshot?) -&gt; [S](on-initial-state.md), session: [WorkflowInterceptor.WorkflowSession](-workflow-session/index.md)): [S](on-initial-state.md)<br>Intercepts calls to StatefulWorkflow.initialState. |
| [onPropsChanged](on-props-changed.md) | [common]<br>open fun &lt;[P](on-props-changed.md), [S](on-props-changed.md)&gt; [onPropsChanged](on-props-changed.md)(old: [P](on-props-changed.md), new: [P](on-props-changed.md), state: [S](on-props-changed.md), proceed: ([P](on-props-changed.md), [P](on-props-changed.md), [S](on-props-changed.md)) -&gt; [S](on-props-changed.md), session: [WorkflowInterceptor.WorkflowSession](-workflow-session/index.md)): [S](on-props-changed.md)<br>Intercepts calls to StatefulWorkflow.onPropsChanged. |
| [onRender](on-render.md) | [common]<br>open fun &lt;[P](on-render.md), [S](on-render.md), [O](on-render.md), [R](on-render.md)&gt; [onRender](on-render.md)(renderProps: [P](on-render.md), renderState: [S](on-render.md), context: BaseRenderContext&lt;[P](on-render.md), [S](on-render.md), [O](on-render.md)&gt;, proceed: ([P](on-render.md), [S](on-render.md), [WorkflowInterceptor.RenderContextInterceptor](-render-context-interceptor/index.md)&lt;[P](on-render.md), [S](on-render.md), [O](on-render.md)&gt;?) -&gt; [R](on-render.md), session: [WorkflowInterceptor.WorkflowSession](-workflow-session/index.md)): [R](on-render.md)<br>Intercepts calls to StatefulWorkflow.render. |
| [onRenderAndSnapshot](on-render-and-snapshot.md) | [common]<br>open fun &lt;[P](on-render-and-snapshot.md), [R](on-render-and-snapshot.md)&gt; [onRenderAndSnapshot](on-render-and-snapshot.md)(renderProps: [P](on-render-and-snapshot.md), proceed: ([P](on-render-and-snapshot.md)) -&gt; [RenderingAndSnapshot](../-rendering-and-snapshot/index.md)&lt;[R](on-render-and-snapshot.md)&gt;, session: [WorkflowInterceptor.WorkflowSession](-workflow-session/index.md)): [RenderingAndSnapshot](../-rendering-and-snapshot/index.md)&lt;[R](on-render-and-snapshot.md)&gt;<br>Intercept a full rendering pass which involves rendering then snapshotting the workflow tree. This is useful for tracing purposes. |
| [onSessionStarted](on-session-started.md) | [common]<br>open fun [onSessionStarted](on-session-started.md)(workflowScope: CoroutineScope, session: [WorkflowInterceptor.WorkflowSession](-workflow-session/index.md))<br>Called when the session is starting, before [onInitialState](on-initial-state.md). |
| [onSnapshotState](on-snapshot-state.md) | [common]<br>open fun &lt;[S](on-snapshot-state.md)&gt; [onSnapshotState](on-snapshot-state.md)(state: [S](on-snapshot-state.md), proceed: ([S](on-snapshot-state.md)) -&gt; Snapshot?, session: [WorkflowInterceptor.WorkflowSession](-workflow-session/index.md)): Snapshot?<br>Intercepts calls to StatefulWorkflow.snapshotState. |
| [onSnapshotStateWithChildren](on-snapshot-state-with-children.md) | [common]<br>open fun [onSnapshotStateWithChildren](on-snapshot-state-with-children.md)(proceed: () -&gt; [TreeSnapshot](../-tree-snapshot/index.md), session: [WorkflowInterceptor.WorkflowSession](-workflow-session/index.md)): [TreeSnapshot](../-tree-snapshot/index.md)<br>Intercept calls to StatefulWorkflow.snapshotState including the children calls. This is useful to intercept a rendering + snapshot traversal for tracing purposes. |

## Inheritors

| Name |
|---|
| [SimpleLoggingWorkflowInterceptor](../-simple-logging-workflow-interceptor/index.md) |
| [NoopWorkflowInterceptor](../-noop-workflow-interceptor/index.md) |
