//[workflow-runtime](../../index.md)/[com.squareup.workflow1](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [NoopWorkflowInterceptor](-noop-workflow-interceptor/index.md) | [common]<br>object [NoopWorkflowInterceptor](-noop-workflow-interceptor/index.md) : [WorkflowInterceptor](-workflow-interceptor/index.md)<br>A [WorkflowInterceptor](-workflow-interceptor/index.md) that does not intercept anything. |
| [RenderingAndSnapshot](-rendering-and-snapshot/index.md) | [common]<br>class [RenderingAndSnapshot](-rendering-and-snapshot/index.md)&lt;out [RenderingT](-rendering-and-snapshot/index.md)&gt;(val rendering: [RenderingT](-rendering-and-snapshot/index.md), val snapshot: [TreeSnapshot](-tree-snapshot/index.md))<br>Tuple of rendering and snapshot used by [renderWorkflowIn](render-workflow-in.md). |
| [RuntimeConfig](-runtime-config/index.md) | [common]<br>interface [RuntimeConfig](-runtime-config/index.md)<br>A specification of the Workflow Runtime. |
| [SimpleLoggingWorkflowInterceptor](-simple-logging-workflow-interceptor/index.md) | [common]<br>open class [SimpleLoggingWorkflowInterceptor](-simple-logging-workflow-interceptor/index.md) : [WorkflowInterceptor](-workflow-interceptor/index.md)<br>A [WorkflowInterceptor](-workflow-interceptor/index.md) that just prints all method calls using log. |
| [TreeSnapshot](-tree-snapshot/index.md) | [common]<br>class [TreeSnapshot](-tree-snapshot/index.md)<br>Aggregate of all the snapshots of a tree of workflows. |
| [WorkflowExperimentalRuntime](-workflow-experimental-runtime/index.md) | [common]<br>@[Target](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-target/index.html)(allowedTargets = [[AnnotationTarget.CLASS](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-c-l-a-s-s/index.html), [AnnotationTarget.PROPERTY](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-p-r-o-p-e-r-t-y/index.html), [AnnotationTarget.FUNCTION](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-f-u-n-c-t-i-o-n/index.html), [AnnotationTarget.TYPEALIAS](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-t-y-p-e-a-l-i-a-s/index.html)])<br>annotation class [WorkflowExperimentalRuntime](-workflow-experimental-runtime/index.md)<br>This is used to mark any experimental runtimes. |
| [WorkflowInterceptor](-workflow-interceptor/index.md) | [common]<br>interface [WorkflowInterceptor](-workflow-interceptor/index.md)<br>Provides hooks into the workflow runtime that can be used to instrument or modify the behavior of workflows. |

## Functions

| Name | Summary |
|---|---|
| [renderWorkflowIn](render-workflow-in.md) | [common]<br>fun &lt;[PropsT](render-workflow-in.md), [OutputT](render-workflow-in.md), [RenderingT](render-workflow-in.md)&gt; [renderWorkflowIn](render-workflow-in.md)(workflow: Workflow&lt;[PropsT](render-workflow-in.md), [OutputT](render-workflow-in.md), [RenderingT](render-workflow-in.md)&gt;, scope: CoroutineScope, props: StateFlow&lt;[PropsT](render-workflow-in.md)&gt;, initialSnapshot: [TreeSnapshot](-tree-snapshot/index.md)? = null, interceptors: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[WorkflowInterceptor](-workflow-interceptor/index.md)&gt; = emptyList(), runtimeConfig: [RuntimeConfig](-runtime-config/index.md) = RuntimeConfig.DEFAULT_CONFIG, onOutput: suspend ([OutputT](render-workflow-in.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)): StateFlow&lt;[RenderingAndSnapshot](-rendering-and-snapshot/index.md)&lt;[RenderingT](render-workflow-in.md)&gt;&gt;<br>Launches the [workflow](render-workflow-in.md) in a new coroutine in [scope](render-workflow-in.md) and returns a StateFlow of its [renderings](render-workflow-in.md) and snapshots. The workflow tree is seeded with [initialSnapshot](render-workflow-in.md) and the current value value of [props](render-workflow-in.md). Subsequent values emitted from [props](render-workflow-in.md) will be used to re-render the workflow. |
