//[workflow-runtime](../../../index.md)/[com.squareup.workflow1](../index.md)/[RuntimeConfigOptions](index.md)

# RuntimeConfigOptions

[common]\
enum [RuntimeConfigOptions](index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[RuntimeConfigOptions](index.md)&gt; 

A specification of the possible Workflow Runtime options.

## Entries

| | |
|---|---|
| [RENDER_ONLY_WHEN_STATE_CHANGES](-r-e-n-d-e-r_-o-n-l-y_-w-h-e-n_-s-t-a-t-e_-c-h-a-n-g-e-s/index.md) | [common]<br>@[WorkflowExperimentalRuntime](../-workflow-experimental-runtime/index.md)<br>[RENDER_ONLY_WHEN_STATE_CHANGES](-r-e-n-d-e-r_-o-n-l-y_-w-h-e-n_-s-t-a-t-e_-c-h-a-n-g-e-s/index.md)<br>If state has not changed from an action cascade (as determined via `equals()`), do not re-render. For example, when this is selected and `noAction()` is enqueued, the current `render()` pass will short circuit and no rendering will be posted through the `StateFlow` returned from `renderWorkflowIn()`. |
| [CONFLATE_STALE_RENDERINGS](-c-o-n-f-l-a-t-e_-s-t-a-l-e_-r-e-n-d-e-r-i-n-g-s/index.md) | [common]<br>@[WorkflowExperimentalRuntime](../-workflow-experimental-runtime/index.md)<br>[CONFLATE_STALE_RENDERINGS](-c-o-n-f-l-a-t-e_-s-t-a-l-e_-r-e-n-d-e-r-i-n-g-s/index.md)<br>If we have more actions to process, do so before passing the rendering to the UI layer. |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common]<br>object [Companion](-companion/index.md) |

## Properties

| Name | Summary |
|---|---|
| [entries](entries.md) | [common]<br>val [entries](entries.md): [EnumEntries](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.enums/-enum-entries/index.html)&lt;[RuntimeConfigOptions](index.md)&gt;<br>Returns a representation of an immutable list of all enum entries, in the order they're declared. |
| [name](-c-o-n-f-l-a-t-e_-s-t-a-l-e_-r-e-n-d-e-r-i-n-g-s/index.md#-372974862%2FProperties%2F-402915103) | [common]<br>val [name](-c-o-n-f-l-a-t-e_-s-t-a-l-e_-r-e-n-d-e-r-i-n-g-s/index.md#-372974862%2FProperties%2F-402915103): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [ordinal](-c-o-n-f-l-a-t-e_-s-t-a-l-e_-r-e-n-d-e-r-i-n-g-s/index.md#-739389684%2FProperties%2F-402915103) | [common]<br>val [ordinal](-c-o-n-f-l-a-t-e_-s-t-a-l-e_-r-e-n-d-e-r-i-n-g-s/index.md#-739389684%2FProperties%2F-402915103): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

## Functions

| Name | Summary |
|---|---|
| [valueOf](value-of.md) | [common]<br>fun [valueOf](value-of.md)(value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [RuntimeConfigOptions](index.md)<br>Returns the enum constant of this type with the specified name. The string must match exactly an identifier used to declare an enum constant in this type. (Extraneous whitespace characters are not permitted.) |
| [values](values.md) | [common]<br>fun [values](values.md)(): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[RuntimeConfigOptions](index.md)&gt;<br>Returns an array containing the constants of this enum type, in the order they're declared. |
