//[workflow-runtime](../../../index.md)/[com.squareup.workflow1](../index.md)/[SimpleLoggingWorkflowInterceptor](index.md)

# SimpleLoggingWorkflowInterceptor

[common]\
open class [SimpleLoggingWorkflowInterceptor](index.md) : [WorkflowInterceptor](../-workflow-interceptor/index.md)

A [WorkflowInterceptor](../-workflow-interceptor/index.md) that just prints all method calls using log.

## Constructors

| | |
|---|---|
| [SimpleLoggingWorkflowInterceptor](-simple-logging-workflow-interceptor.md) | [common]<br>constructor() |

## Functions

| Name | Summary |
|---|---|
| [onInitialState](on-initial-state.md) | [common]<br>open override fun &lt;[P](on-initial-state.md), [S](on-initial-state.md)&gt; [onInitialState](on-initial-state.md)(props: [P](on-initial-state.md), snapshot: Snapshot?, workflowScope: CoroutineScope, proceed: ([P](on-initial-state.md), Snapshot?, CoroutineScope) -&gt; [S](on-initial-state.md), session: [WorkflowInterceptor.WorkflowSession](../-workflow-interceptor/-workflow-session/index.md)): [S](on-initial-state.md)<br>Intercepts calls to StatefulWorkflow.initialState. |
| [onPropsChanged](on-props-changed.md) | [common]<br>open override fun &lt;[P](on-props-changed.md), [S](on-props-changed.md)&gt; [onPropsChanged](on-props-changed.md)(old: [P](on-props-changed.md), new: [P](on-props-changed.md), state: [S](on-props-changed.md), proceed: ([P](on-props-changed.md), [P](on-props-changed.md), [S](on-props-changed.md)) -&gt; [S](on-props-changed.md), session: [WorkflowInterceptor.WorkflowSession](../-workflow-interceptor/-workflow-session/index.md)): [S](on-props-changed.md)<br>Intercepts calls to StatefulWorkflow.onPropsChanged. |
| [onRender](on-render.md) | [common]<br>open override fun &lt;[P](on-render.md), [S](on-render.md), [O](on-render.md), [R](on-render.md)&gt; [onRender](on-render.md)(renderProps: [P](on-render.md), renderState: [S](on-render.md), context: BaseRenderContext&lt;[P](on-render.md), [S](on-render.md), [O](on-render.md)&gt;, proceed: ([P](on-render.md), [S](on-render.md), [WorkflowInterceptor.RenderContextInterceptor](../-workflow-interceptor/-render-context-interceptor/index.md)&lt;[P](on-render.md), [S](on-render.md), [O](on-render.md)&gt;?) -&gt; [R](on-render.md), session: [WorkflowInterceptor.WorkflowSession](../-workflow-interceptor/-workflow-session/index.md)): [R](on-render.md)<br>Intercepts calls to StatefulWorkflow.render. |
| [onRenderAndSnapshot](../-workflow-interceptor/on-render-and-snapshot.md) | [common]<br>open fun &lt;[P](../-workflow-interceptor/on-render-and-snapshot.md), [R](../-workflow-interceptor/on-render-and-snapshot.md)&gt; [onRenderAndSnapshot](../-workflow-interceptor/on-render-and-snapshot.md)(renderProps: [P](../-workflow-interceptor/on-render-and-snapshot.md), proceed: ([P](../-workflow-interceptor/on-render-and-snapshot.md)) -&gt; [RenderingAndSnapshot](../-rendering-and-snapshot/index.md)&lt;[R](../-workflow-interceptor/on-render-and-snapshot.md)&gt;, session: [WorkflowInterceptor.WorkflowSession](../-workflow-interceptor/-workflow-session/index.md)): [RenderingAndSnapshot](../-rendering-and-snapshot/index.md)&lt;[R](../-workflow-interceptor/on-render-and-snapshot.md)&gt;<br>Intercept a full rendering pass which involves rendering then snapshotting the workflow tree. This is useful for tracing purposes. |
| [onSessionStarted](on-session-started.md) | [common]<br>open override fun [onSessionStarted](on-session-started.md)(workflowScope: CoroutineScope, session: [WorkflowInterceptor.WorkflowSession](../-workflow-interceptor/-workflow-session/index.md))<br>Called when the session is starting, before [onInitialState](on-initial-state.md). |
| [onSnapshotState](on-snapshot-state.md) | [common]<br>open override fun &lt;[S](on-snapshot-state.md)&gt; [onSnapshotState](on-snapshot-state.md)(state: [S](on-snapshot-state.md), proceed: ([S](on-snapshot-state.md)) -&gt; Snapshot?, session: [WorkflowInterceptor.WorkflowSession](../-workflow-interceptor/-workflow-session/index.md)): Snapshot?<br>Intercepts calls to StatefulWorkflow.snapshotState. |
| [onSnapshotStateWithChildren](../-workflow-interceptor/on-snapshot-state-with-children.md) | [common]<br>open fun [onSnapshotStateWithChildren](../-workflow-interceptor/on-snapshot-state-with-children.md)(proceed: () -&gt; [TreeSnapshot](../-tree-snapshot/index.md), session: [WorkflowInterceptor.WorkflowSession](../-workflow-interceptor/-workflow-session/index.md)): [TreeSnapshot](../-tree-snapshot/index.md)<br>Intercept calls to StatefulWorkflow.snapshotState including the children calls. This is useful to intercept a rendering + snapshot traversal for tracing purposes. |
