//[workflow-runtime](../../../../index.md)/[com.squareup.workflow1](../../index.md)/[WorkflowInterceptor](../index.md)/[RenderContextInterceptor](index.md)

# RenderContextInterceptor

[common]\
interface [RenderContextInterceptor](index.md)&lt;[P](index.md), [S](index.md), [O](index.md)&gt;

Provides hooks for intercepting calls to a BaseRenderContext, to be used from [onRender](../on-render.md).

For use by [onRender](../on-render.md) methods that want to hook into action and side effect events. See documentation on methods for more information about the individual hooks:

- 
   [RenderContextInterceptor.onActionSent](on-action-sent.md)
- 
   [RenderContextInterceptor.onRunningSideEffect](on-running-side-effect.md)

E.g.:

```kotlin
override fun <P, S, O, R> onRender(
  renderProps: P,
  renderState: S,
  proceed: (P, S, RenderContextInterceptor<P, S, O>) -> R,
  session: WorkflowSession
): R = proceed(renderProps, renderState, object : RenderContextInterceptor<P, S, O> {
  override fun onActionSent(
    action: WorkflowAction<P, S, O>,
    proceed: (WorkflowAction<P, S, O>) -> Unit
  ) {
    log("Action sent: $action")
    proceed(action)
  }

  override fun onRunningSideEffect(
    key: String,
    sideEffect: suspend () -> Unit,
    proceed: (key: String, sideEffect: suspend () -> Unit) -> Unit
  ) {
    proceed(key) {
      log("Side effect started: $key")
      sideEffect()
      log("Side effect ended: $key")
    }
  }
})
```

## Functions

| Name | Summary |
|---|---|
| [onActionSent](on-action-sent.md) | [common]<br>open fun [onActionSent](on-action-sent.md)(action: WorkflowAction&lt;[P](index.md), [S](index.md), [O](index.md)&gt;, proceed: (WorkflowAction&lt;[P](index.md), [S](index.md), [O](index.md)&gt;) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>Intercepts calls to send on the BaseRenderContext.actionSink. |
| [onRenderChild](on-render-child.md) | [common]<br>open fun &lt;[CP](on-render-child.md), [CO](on-render-child.md), [CR](on-render-child.md)&gt; [onRenderChild](on-render-child.md)(child: Workflow&lt;[CP](on-render-child.md), [CO](on-render-child.md), [CR](on-render-child.md)&gt;, childProps: [CP](on-render-child.md), key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), handler: ([CO](on-render-child.md)) -&gt; WorkflowAction&lt;[P](index.md), [S](index.md), [O](index.md)&gt;, proceed: (child: Workflow&lt;[CP](on-render-child.md), [CO](on-render-child.md), [CR](on-render-child.md)&gt;, childProps: [CP](on-render-child.md), key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), handler: ([CO](on-render-child.md)) -&gt; WorkflowAction&lt;[P](index.md), [S](index.md), [O](index.md)&gt;) -&gt; [CR](on-render-child.md)): [CR](on-render-child.md)<br>Intercepts calls to BaseRenderContext.renderChild, allowing the interceptor to wrap or replace the [child](on-render-child.md) Workflow, its [childProps](on-render-child.md), [key](on-render-child.md), and the [handler](on-render-child.md) function to be applied to the child's output. |
| [onRunningSideEffect](on-running-side-effect.md) | [common]<br>open fun [onRunningSideEffect](on-running-side-effect.md)(key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), sideEffect: suspend () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html), proceed: (key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), sideEffect: suspend () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>Intercepts calls to BaseRenderContext.runningSideEffect, allowing the interceptor to wrap or replace the [sideEffect](on-running-side-effect.md) and its [key](on-running-side-effect.md). This could be used to prevent a side effect from running, or to augment it with further effects. |
