//[workflow-runtime](../../index.md)/[com.squareup.workflow1](index.md)/[renderWorkflowIn](render-workflow-in.md)

# renderWorkflowIn

[common]\
fun &lt;[PropsT](render-workflow-in.md), [OutputT](render-workflow-in.md), [RenderingT](render-workflow-in.md)&gt; [renderWorkflowIn](render-workflow-in.md)(workflow: Workflow&lt;[PropsT](render-workflow-in.md), [OutputT](render-workflow-in.md), [RenderingT](render-workflow-in.md)&gt;, scope: CoroutineScope, props: StateFlow&lt;[PropsT](render-workflow-in.md)&gt;, initialSnapshot: [TreeSnapshot](-tree-snapshot/index.md)? = null, interceptors: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[WorkflowInterceptor](-workflow-interceptor/index.md)&gt; = emptyList(), runtimeConfig: [RuntimeConfig](-runtime-config/index.md) = RuntimeConfig.DEFAULT_CONFIG, onOutput: suspend ([OutputT](render-workflow-in.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)): StateFlow&lt;[RenderingAndSnapshot](-rendering-and-snapshot/index.md)&lt;[RenderingT](render-workflow-in.md)&gt;&gt;

Launches the [workflow](render-workflow-in.md) in a new coroutine in [scope](render-workflow-in.md) and returns a StateFlow of its [renderings](render-workflow-in.md) and snapshots. The workflow tree is seeded with [initialSnapshot](render-workflow-in.md) and the current value value of [props](render-workflow-in.md). Subsequent values emitted from [props](render-workflow-in.md) will be used to re-render the workflow.

This is the primary low-level entry point into the workflow runtime. If you are writing an app, you should probably be using a higher-level entry point that will also let you define UI bindings for your renderings.

##  Initialization

When this function is called, the workflow runtime is started immediately, before the function even returns. The current value of the props is used to perform the initial render pass. The result of this render pass is used to initialize the StateFlow of renderings and snapshots that is returned.

Once the initial render pass is complete, the workflow runtime will continue executing in a new coroutine launched in [scope](render-workflow-in.md).

##  Scoping

The workflow runtime makes use of [structured concurrency](https://medium.com/@elizarov/structured-concurrency-722d765aa952).

The runtime is started in [scope](render-workflow-in.md), which defines the context for the entire workflow tree – most importantly, the Job that governs the runtime's lifetime and exception reporting path, and the CoroutineDispatcher that decides on what thread(s) to run workflow code. Note that if the scope's dispatcher executes on threads different than the caller, then the initial render pass will occur on the current thread but all subsequent render passes, and actions, will be executed on that dispatcher. This shouldn't affect well-written workflows, since the render method should not perform side effects anyway.

All workers that are run by this runtime will be collected in coroutines that are children of [scope](render-workflow-in.md). When the root workflow emits an output, [onOutput](render-workflow-in.md) will be invoked in a child of [scope](render-workflow-in.md).

To stop the workflow runtime, simply cancel [scope](render-workflow-in.md). Any running workers will be cancelled, and if [onOutput](render-workflow-in.md) is currently running it will be cancelled as well.

##  Error handling

If the initial render pass throws an exception, that exception will be thrown from this function. Any exceptions thrown from the runtime (and any workflows or workers) after that will bubble up and be handled by [scope](render-workflow-in.md) (usually by cancelling it).

Since the [onOutput](render-workflow-in.md) function is executed in [scope](render-workflow-in.md), any exceptions it throws will also bubble up to [scope](render-workflow-in.md). Any exceptions thrown by subscribers of the returned StateFlow will *not* cancel [scope](render-workflow-in.md) or cancel the runtime, but will be handled in the CoroutineScope of the subscriber.

#### Return

A StateFlow of [RenderingAndSnapshot](-rendering-and-snapshot/index.md)s that will emit any time the root workflow creates a new rendering.

#### Parameters

common

| | |
|---|---|
| workflow | The root workflow to render. |
| scope | The CoroutineScope in which to launch the workflow runtime. Any exceptions thrown in any workflows, after the initial render pass, will be handled by this scope, and cancelling this scope will cancel the workflow runtime and any running workers. Note that any dispatcher in this scope will *not* be used to execute the very first render pass. |
| props | Specifies the initial [PropsT](render-workflow-in.md) to use to render the root workflow, and will cause a re-render when new props are emitted. If this flow completes *after* emitting at least one value, the runtime will *not* fail or stop, it will continue running with the last-emitted input. To only pass a single props value, simply create a MutableStateFlow with the value. |
| initialSnapshot | If not null or empty, used to restore the workflow. Should be obtained from a previous runtime's [RenderingAndSnapshot](-rendering-and-snapshot/index.md). |
| interceptors | An optional list of [WorkflowInterceptor](-workflow-interceptor/index.md)s that will wrap every workflow rendered by the runtime. Interceptors will be invoked in 0-to-`length` order: the interceptor at index 0 will process the workflow first, then the interceptor at index 1, etc. |
| onOutput | A function that will be called whenever the root workflow emits an [OutputT](render-workflow-in.md). This is a suspend function, and is invoked synchronously within the runtime: if it suspends, the workflow runtime will effectively be paused until it returns. This means that it will propagate backpressure if used to forward outputs to a Flow or Channel, for example. |
| runtimeConfig | Configuration parameters for the Workflow Runtime. |
