//[workflow-rx2](../../index.md)/[com.squareup.workflow1.rx2](index.md)/[asWorker](as-worker.md)

# asWorker

[jvm]\
inline fun &lt;[T](as-worker.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; Observable&lt;out [T](as-worker.md)?&gt;.[asWorker](as-worker.md)(): Worker&lt;[T](as-worker.md)&gt;

Creates a Worker from this Observable.

The Observable will be subscribed to when the Worker is started, and disposed when it is cancelled.

Note that a Worker actually operates on a kotlinx.coroutines.flow. This means that your Observable will first be adapted to a flow. To do this a communication structure is used that will mean that the flow will process the items produced by the Observable asynchronously.

Note that this Observable is transformed to a backpressure aware Flowable using the BUFFER strategy before being transformed to a flow, which means that buffering will happen in the Flowable before being passed over to the flow if it is experiencing backpressure.

RxJava doesn't allow nulls, but it can't express that in its types. The receiver type parameter is nullable so that the resulting Worker is non-nullable instead of having platform nullability.

[jvm]\
inline fun &lt;[T](as-worker.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; Publisher&lt;out [T](as-worker.md)?&gt;.[asWorker](as-worker.md)(): Worker&lt;[T](as-worker.md)&gt;

Creates a Worker from this Publisher (Flowable is a Publisher).

The Publisher will be subscribed to when the Worker is started, and cancelled when it is cancelled.

Note that a Worker actually operates on a kotlinx.coroutines.flow. This means that your Publisher will first be mapped to a flow. To do this a communication structure is used that will mean that the flow will process the items produced by the Publisher asynchronously.

RxJava doesn't allow nulls, but it can't express that in its types. The receiver type parameter is nullable so that the resulting Worker is non-nullable instead of having platform nullability.

[jvm]\
inline fun &lt;[T](as-worker.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; Maybe&lt;out [T](as-worker.md)?&gt;.[asWorker](as-worker.md)(): Worker&lt;[T](as-worker.md)&gt;

Creates a Worker from this Maybe.

The Maybe will be subscribed to when the Worker is started, and disposed when it is cancelled.

RxJava doesn't allow nulls, but it can't express that in its types. The receiver type parameter is nullable so that the resulting Worker is non-nullable instead of having platform nullability.

[jvm]\
inline fun &lt;[T](as-worker.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; Single&lt;out [T](as-worker.md)?&gt;.[asWorker](as-worker.md)(): Worker&lt;[T](as-worker.md)&gt;

Creates a Worker from this Single.

The Single will be subscribed to when the Worker is started, and disposed when it is cancelled.

RxJava doesn't allow nulls, but it can't express that in its types. The receiver type parameter is nullable so that the resulting Worker is non-nullable instead of having platform nullability.

[jvm]\
fun Completable.[asWorker](as-worker.md)(): Worker&lt;[Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)&gt;

Creates a Worker from this Completable.

The Completable will be subscribed to when the Worker is started, and disposed when it is cancelled.

The key is required for this operator because there is no type information available to distinguish workers.

TODO: https://github.com/square/workflow-kotlin/issues/526 once this is removed.
