//[workflow-tracing](../../index.md)/[com.squareup.workflow1.diagnostic.tracing](index.md)/[TracingWorkflowInterceptor](-tracing-workflow-interceptor.md)

# TracingWorkflowInterceptor

[jvm]\
fun [TracingWorkflowInterceptor](-tracing-workflow-interceptor.md)(file: [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;&quot;): [TracingWorkflowInterceptor](-tracing-workflow-interceptor/index.md)

A WorkflowInterceptor that generates a trace file that can be viewed in Chrome by visiting `chrome://tracing`.

#### Parameters

jvm

| | |
|---|---|
| file | The [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html) to write the trace to. |
| name | If non-empty, will be used to set the &quot;process name&quot; in the trace file. If empty, the workflow type is used for the process name. |

[jvm]\
fun [TracingWorkflowInterceptor](-tracing-workflow-interceptor.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;&quot;, memoryStats: [MemoryStats](-memory-stats/index.md) = RuntimeMemoryStats, encoderProvider: (workflowScope: CoroutineScope) -&gt; TraceEncoder): [TracingWorkflowInterceptor](-tracing-workflow-interceptor/index.md)

A WorkflowInterceptor that generates a trace file that can be viewed in Chrome by visiting `chrome://tracing`.

#### Parameters

jvm

| | |
|---|---|
| name | If non-empty, will be used to set the &quot;process name&quot; in the trace file. If empty, the workflow type is used for the process name. |
| encoderProvider | A function that returns a TraceEncoder that will be used to write trace events. The function gets the CoroutineScope that the workflow runtime is running in. |
