//[workflow-tracing](../../../index.md)/[com.squareup.workflow1.diagnostic.tracing](../index.md)/[TracingWorkflowInterceptor](index.md)

# TracingWorkflowInterceptor

[jvm]\
class [TracingWorkflowInterceptor](index.md) : WorkflowInterceptor

A WorkflowInterceptor that generates a trace file that can be viewed in Chrome by visiting `chrome://tracing`.

## Constructors

| | |
|---|---|
| [TracingWorkflowInterceptor](-tracing-workflow-interceptor.md) | [jvm]<br>fun [TracingWorkflowInterceptor](-tracing-workflow-interceptor.md)(memoryStats: [MemoryStats](../-memory-stats/index.md) = RuntimeMemoryStats, loggerProvider: (workflowScope: CoroutineScope, workflowType: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -&gt; TraceLogger)<br>A WorkflowInterceptor that generates a trace file that can be viewed in Chrome by visiting `chrome://tracing`. |

## Functions

| Name | Summary |
|---|---|
| [onInitialState](on-initial-state.md) | [jvm]<br>open override fun &lt;[P](on-initial-state.md), [S](on-initial-state.md)&gt; [onInitialState](on-initial-state.md)(props: [P](on-initial-state.md), snapshot: Snapshot?, proceed: ([P](on-initial-state.md), Snapshot?) -&gt; [S](on-initial-state.md), session: WorkflowInterceptor.WorkflowSession): [S](on-initial-state.md) |
| [onPropsChanged](on-props-changed.md) | [jvm]<br>open override fun &lt;[P](on-props-changed.md), [S](on-props-changed.md)&gt; [onPropsChanged](on-props-changed.md)(old: [P](on-props-changed.md), new: [P](on-props-changed.md), state: [S](on-props-changed.md), proceed: ([P](on-props-changed.md), [P](on-props-changed.md), [S](on-props-changed.md)) -&gt; [S](on-props-changed.md), session: WorkflowInterceptor.WorkflowSession): [S](on-props-changed.md) |
| [onRender](on-render.md) | [jvm]<br>open override fun &lt;[P](on-render.md), [S](on-render.md), [O](on-render.md), [R](on-render.md)&gt; [onRender](on-render.md)(renderProps: [P](on-render.md), renderState: [S](on-render.md), context: BaseRenderContext&lt;[P](on-render.md), [S](on-render.md), [O](on-render.md)&gt;, proceed: ([P](on-render.md), [S](on-render.md), WorkflowInterceptor.RenderContextInterceptor&lt;[P](on-render.md), [S](on-render.md), [O](on-render.md)&gt;?) -&gt; [R](on-render.md), session: WorkflowInterceptor.WorkflowSession): [R](on-render.md) |
| [onRenderAndSnapshot](index.md#-801305388%2FFunctions%2F-1474598548) | [jvm]<br>open fun &lt;[P](index.md#-801305388%2FFunctions%2F-1474598548), [R](index.md#-801305388%2FFunctions%2F-1474598548)&gt; [onRenderAndSnapshot](index.md#-801305388%2FFunctions%2F-1474598548)(renderProps: [P](index.md#-801305388%2FFunctions%2F-1474598548), proceed: ([P](index.md#-801305388%2FFunctions%2F-1474598548)) -&gt; RenderingAndSnapshot&lt;[R](index.md#-801305388%2FFunctions%2F-1474598548)&gt;, session: WorkflowInterceptor.WorkflowSession): RenderingAndSnapshot&lt;[R](index.md#-801305388%2FFunctions%2F-1474598548)&gt; |
| [onSessionStarted](on-session-started.md) | [jvm]<br>open override fun [onSessionStarted](on-session-started.md)(workflowScope: CoroutineScope, session: WorkflowInterceptor.WorkflowSession) |
| [onSnapshotState](on-snapshot-state.md) | [jvm]<br>open override fun &lt;[S](on-snapshot-state.md)&gt; [onSnapshotState](on-snapshot-state.md)(state: [S](on-snapshot-state.md), proceed: ([S](on-snapshot-state.md)) -&gt; Snapshot?, session: WorkflowInterceptor.WorkflowSession): Snapshot? |
| [onSnapshotStateWithChildren](index.md#1196154354%2FFunctions%2F-1474598548) | [jvm]<br>open fun [onSnapshotStateWithChildren](index.md#1196154354%2FFunctions%2F-1474598548)(proceed: () -&gt; TreeSnapshot, session: WorkflowInterceptor.WorkflowSession): TreeSnapshot |
