/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.workflow1.diagnostic.tracing;

import com.squareup.tracing.TraceEvent;
import com.squareup.tracing.TraceLogger;
import com.squareup.workflow1.ActionApplied;
import com.squareup.workflow1.BaseRenderContext;
import com.squareup.workflow1.RenderingAndSnapshot;
import com.squareup.workflow1.Snapshot;
import com.squareup.workflow1.TreeSnapshot;
import com.squareup.workflow1.Workflow;
import com.squareup.workflow1.WorkflowAction;
import com.squareup.workflow1.WorkflowInterceptor;
import com.squareup.workflow1.WorkflowOutput;
import com.squareup.workflow1.Workflows;
import com.squareup.workflow1.diagnostic.tracing.GcDetector;
import com.squareup.workflow1.diagnostic.tracing.MemoryStats;
import com.squareup.workflow1.diagnostic.tracing.RuntimeMemoryStats;
import com.squareup.workflow1.diagnostic.tracing.TracingWorkflowInterceptorKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002YZBI\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\rBt\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012+\u0010\u000e\u001a'\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000fj\u0002`\u0014\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010 \u001a\u00020\u0011H\u0002J\u001a\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0012\u0010#\u001a\u00020\u00112\b\u0010$\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010%\u001a\u00020\u0011H\u0002J$\u0010&\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u001fH\u0002J]\u0010(\u001a\u0002H)\"\u0004\b\u0000\u0010*\"\u0004\b\u0001\u0010)2\u0006\u0010$\u001a\u0002H*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\t\u001a\u00020\u00062 \u0010-\u001a\u001c\u0012\u0004\u0012\u0002H*\u0012\u0006\u0012\u0004\u0018\u00010,\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H)0.2\u0006\u0010/\u001a\u000200H\u0016\u00a2\u0006\u0002\u00101JY\u00102\u001a\u0002H)\"\u0004\b\u0000\u0010*\"\u0004\b\u0001\u0010)2\u0006\u00103\u001a\u0002H*2\u0006\u00104\u001a\u0002H*2\u0006\u0010'\u001a\u0002H)2\u001e\u0010-\u001a\u001a\u0012\u0004\u0012\u0002H*\u0012\u0004\u0012\u0002H*\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u0002H)0.2\u0006\u0010/\u001a\u000200H\u0016\u00a2\u0006\u0002\u00105J?\u00102\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010\u001a2\b\u00106\u001a\u0004\u0018\u00010\u001f2\b\u00107\u001a\u0004\u0018\u00010\u001f2\b\u00108\u001a\u0004\u0018\u00010\u001f2\b\u00109\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010:J\u008b\u0001\u0010;\u001a\u0002H<\"\u0004\b\u0000\u0010*\"\u0004\b\u0001\u0010)\"\u0004\b\u0002\u0010=\"\u0004\b\u0003\u0010<2\u0006\u0010>\u001a\u0002H*2\u0006\u0010?\u001a\u0002H)2\u0018\u0010@\u001a\u0014\u0012\u0004\u0012\u0002H*\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u0002H=0A22\u0010-\u001a.\u0012\u0004\u0012\u0002H*\u0012\u0004\u0012\u0002H)\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u0002H*\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u0002H=\u0018\u00010B\u0012\u0004\u0012\u0002H<0.2\u0006\u0010/\u001a\u000200H\u0016\u00a2\u0006\u0002\u0010CJ\u0018\u0010D\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\nH\u0002J\b\u0010F\u001a\u00020\u0011H\u0002J\u0018\u0010G\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010/\u001a\u000200H\u0016J$\u0010H\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001a2\u0012\u0010I\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030JH\u0002J;\u0010K\u001a\u0004\u0018\u00010,\"\u0004\b\u0000\u0010)2\u0006\u0010'\u001a\u0002H)2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u0002H)\u0012\u0006\u0012\u0004\u0018\u00010,0\u000f2\u0006\u0010/\u001a\u000200H\u0016\u00a2\u0006\u0002\u0010LJJ\u0010M\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001a2\u0012\u0010I\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030J2\b\u00108\u001a\u0004\u0018\u00010\u001f2\b\u00109\u001a\u0004\u0018\u00010\u001f2\u0010\u0010N\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0018\u00010OH\u0002JK\u0010P\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001a2\b\u0010Q\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010R\u001a\u00020\n2\b\u0010S\u001a\u0004\u0018\u00010\u001f2\b\u0010T\u001a\u0004\u0018\u00010\u001f2\u0006\u0010U\u001a\u00020VH\u0002\u00a2\u0006\u0002\u0010WJ\u0010\u0010X\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001aH\u0002R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R3\u0010\u000e\u001a'\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000fj\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R>\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\n0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/squareup/workflow1/diagnostic/tracing/TracingWorkflowInterceptor;", "Lcom/squareup/workflow1/WorkflowInterceptor;", "memoryStats", "Lcom/squareup/workflow1/diagnostic/tracing/MemoryStats;", "loggerProvider", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/ParameterName;", "name", "workflowScope", "", "workflowType", "Lcom/squareup/tracing/TraceLogger;", "(Lcom/squareup/workflow1/diagnostic/tracing/MemoryStats;Lkotlin/jvm/functions/Function2;)V", "gcDetectorConstructor", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "onGcDetected", "Lcom/squareup/workflow1/diagnostic/tracing/GcDetector;", "Lcom/squareup/workflow1/diagnostic/tracing/GcDetectorConstructor;", "(Lcom/squareup/workflow1/diagnostic/tracing/MemoryStats;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "gcDetector", "logger", "workflowNamesById", "", "", "createMemoryEvent", "Lcom/squareup/tracing/TraceEvent$Counter;", "onAfterRenderPass", "rendering", "", "onAfterSnapshotPass", "onAfterWorkflowRendered", "workflowId", "onBeforeRenderPass", "props", "onBeforeSnapshotPass", "onBeforeWorkflowRendered", "state", "onInitialState", "S", "P", "snapshot", "Lcom/squareup/workflow1/Snapshot;", "proceed", "Lkotlin/Function3;", "session", "Lcom/squareup/workflow1/WorkflowInterceptor$WorkflowSession;", "(Ljava/lang/Object;Lcom/squareup/workflow1/Snapshot;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function3;Lcom/squareup/workflow1/WorkflowInterceptor$WorkflowSession;)Ljava/lang/Object;", "onPropsChanged", "old", "new", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function3;Lcom/squareup/workflow1/WorkflowInterceptor$WorkflowSession;)Ljava/lang/Object;", "oldProps", "newProps", "oldState", "newState", "(Ljava/lang/Long;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "onRender", "R", "O", "renderProps", "renderState", "context", "Lcom/squareup/workflow1/BaseRenderContext;", "Lcom/squareup/workflow1/WorkflowInterceptor$RenderContextInterceptor;", "(Ljava/lang/Object;Ljava/lang/Object;Lcom/squareup/workflow1/BaseRenderContext;Lkotlin/jvm/functions/Function3;Lcom/squareup/workflow1/WorkflowInterceptor$WorkflowSession;)Ljava/lang/Object;", "onRuntimeStarted", "rootWorkflowType", "onRuntimeStopped", "onSessionStarted", "onSinkReceived", "action", "Lcom/squareup/workflow1/WorkflowAction;", "onSnapshotState", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lcom/squareup/workflow1/WorkflowInterceptor$WorkflowSession;)Lcom/squareup/workflow1/Snapshot;", "onWorkflowAction", "output", "Lcom/squareup/workflow1/ActionApplied;", "onWorkflowStarted", "parentId", "key", "initialProps", "initialState", "restoredFromSnapshot", "", "(JLjava/lang/Long;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Z)V", "onWorkflowStopped", "TracingAction", "TracingContextInterceptor", "wf1-workflow-tracing"})
@SourceDebugExtension(value={"SMAP\nTracingWorkflowInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TracingWorkflowInterceptor.kt\ncom/squareup/workflow1/diagnostic/tracing/TracingWorkflowInterceptor\n+ 2 TracingWorkflowInterceptor.kt\ncom/squareup/workflow1/diagnostic/tracing/TracingWorkflowInterceptorKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,529:1\n528#2:530\n528#2:531\n528#2:532\n1#3:533\n*S KotlinDebug\n*F\n+ 1 TracingWorkflowInterceptor.kt\ncom/squareup/workflow1/diagnostic/tracing/TracingWorkflowInterceptor\n*L\n300#1:530\n309#1:531\n352#1:532\n*E\n"})
public final class TracingWorkflowInterceptor
implements WorkflowInterceptor {
    @NotNull
    private final MemoryStats memoryStats;
    @NotNull
    private final Function1<Function0<Unit>, GcDetector> gcDetectorConstructor;
    @NotNull
    private final Function2<CoroutineScope, String, TraceLogger> loggerProvider;
    @Nullable
    private TraceLogger logger;
    @Nullable
    private GcDetector gcDetector;
    @NotNull
    private final Map<Long, String> workflowNamesById;

    public TracingWorkflowInterceptor(@NotNull MemoryStats memoryStats, @NotNull Function1<? super Function0<Unit>, ? extends GcDetector> gcDetectorConstructor, @NotNull Function2<? super CoroutineScope, ? super String, ? extends TraceLogger> loggerProvider) {
        Intrinsics.checkNotNullParameter((Object)memoryStats, (String)"memoryStats");
        Intrinsics.checkNotNullParameter(gcDetectorConstructor, (String)"gcDetectorConstructor");
        Intrinsics.checkNotNullParameter(loggerProvider, (String)"loggerProvider");
        this.memoryStats = memoryStats;
        this.gcDetectorConstructor = gcDetectorConstructor;
        this.loggerProvider = loggerProvider;
        this.workflowNamesById = new LinkedHashMap();
    }

    public TracingWorkflowInterceptor(@NotNull MemoryStats memoryStats, @NotNull Function2<? super CoroutineScope, ? super String, ? extends TraceLogger> loggerProvider) {
        Intrinsics.checkNotNullParameter((Object)memoryStats, (String)"memoryStats");
        Intrinsics.checkNotNullParameter(loggerProvider, (String)"loggerProvider");
        this(memoryStats, (Function1<? super Function0<Unit>, ? extends GcDetector>)((Function1)1.INSTANCE), loggerProvider);
    }

    public /* synthetic */ TracingWorkflowInterceptor(MemoryStats memoryStats, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            memoryStats = RuntimeMemoryStats.INSTANCE;
        }
        this(memoryStats, (Function2<? super CoroutineScope, ? super String, ? extends TraceLogger>)function2);
    }

    public void onSessionStarted(@NotNull CoroutineScope workflowScope, @NotNull WorkflowInterceptor.WorkflowSession session) {
        Intrinsics.checkNotNullParameter((Object)workflowScope, (String)"workflowScope");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        CoroutineContext.Element element = workflowScope.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
        Intrinsics.checkNotNull((Object)element);
        Job workflowJob = (Job)element;
        workflowJob.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(this, session){
            final /* synthetic */ TracingWorkflowInterceptor this$0;
            final /* synthetic */ WorkflowInterceptor.WorkflowSession $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                TracingWorkflowInterceptor.access$onWorkflowStopped(this.this$0, this.$session.getSessionId());
            }
        });
        if (session.getParent() == null) {
            this.onRuntimeStarted(workflowScope, TracingWorkflowInterceptorKt.access$toLoggingName(session.getIdentifier()));
            workflowJob.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(this){
                final /* synthetic */ TracingWorkflowInterceptor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@Nullable Throwable it) {
                    TracingWorkflowInterceptor.access$onRuntimeStopped(this.this$0);
                }
            });
        }
    }

    public <P, S> S onInitialState(P props, @Nullable Snapshot snapshot, @NotNull CoroutineScope workflowScope, @NotNull Function3<? super P, ? super Snapshot, ? super CoroutineScope, ? extends S> proceed, @NotNull WorkflowInterceptor.WorkflowSession session) {
        Intrinsics.checkNotNullParameter((Object)workflowScope, (String)"workflowScope");
        Intrinsics.checkNotNullParameter(proceed, (String)"proceed");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object initialState = proceed.invoke(props, (Object)snapshot, (Object)workflowScope);
        WorkflowInterceptor.WorkflowSession workflowSession = session.getParent();
        this.onWorkflowStarted(session.getSessionId(), workflowSession != null ? Long.valueOf(workflowSession.getSessionId()) : null, TracingWorkflowInterceptorKt.access$toLoggingName(session.getIdentifier()), session.getRenderKey(), props, initialState, snapshot != null);
        return (S)initialState;
    }

    public <P, S> S onPropsChanged(P old, P p, S state, @NotNull Function3<? super P, ? super P, ? super S, ? extends S> proceed, @NotNull WorkflowInterceptor.WorkflowSession session) {
        Intrinsics.checkNotNullParameter(proceed, (String)"proceed");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object newState = proceed.invoke(old, p, state);
        if (session.getParent() == null) {
            this.onPropsChanged(null, old, p, state, newState);
        }
        this.onPropsChanged(session.getSessionId(), old, p, state, newState);
        return (S)newState;
    }

    public <P, S, O, R> R onRender(P renderProps, S renderState, @NotNull BaseRenderContext<? extends P, S, ? super O> context, @NotNull Function3<? super P, ? super S, ? super WorkflowInterceptor.RenderContextInterceptor<P, S, O>, ? extends R> proceed, @NotNull WorkflowInterceptor.WorkflowSession session) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter(proceed, (String)"proceed");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (session.getParent() == null) {
            this.onBeforeRenderPass(renderProps);
        }
        this.onBeforeWorkflowRendered(session.getSessionId(), renderProps, renderState);
        Object rendering = proceed.invoke(renderProps, renderState, new TracingContextInterceptor(session));
        this.onAfterWorkflowRendered(session.getSessionId(), rendering);
        if (session.getParent() == null) {
            this.onAfterRenderPass(rendering);
        }
        return (R)rendering;
    }

    @Nullable
    public <S> Snapshot onSnapshotState(S state, @NotNull Function1<? super S, Snapshot> proceed, @NotNull WorkflowInterceptor.WorkflowSession session) {
        Intrinsics.checkNotNullParameter(proceed, (String)"proceed");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (session.getParent() == null) {
            this.onBeforeSnapshotPass();
        }
        Snapshot snapshot = (Snapshot)proceed.invoke(state);
        if (session.getParent() == null) {
            this.onAfterSnapshotPass();
        }
        return snapshot;
    }

    private final void onRuntimeStarted(CoroutineScope workflowScope, String rootWorkflowType) {
        this.logger = (TraceLogger)this.loggerProvider.invoke((Object)workflowScope, (Object)rootWorkflowType);
        this.gcDetector = (GcDetector)this.gcDetectorConstructor.invoke((Object)new Function0<Unit>(this){
            final /* synthetic */ TracingWorkflowInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    TraceLogger traceLogger = TracingWorkflowInterceptor.access$getLogger$p(this.this$0);
                    if (traceLogger == null) break block0;
                    Object[] objectArray = new TraceEvent[2];
                    TraceEvent.Instant.InstantScope instantScope = TraceEvent.Instant.InstantScope.GLOBAL;
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"freeMemory", (Object)TracingWorkflowInterceptor.access$getMemoryStats$p(this.this$0).freeMemory()), TuplesKt.to((Object)"totalMemory", (Object)TracingWorkflowInterceptor.access$getMemoryStats$p(this.this$0).totalMemory())};
                    Map map = MapsKt.mapOf((Pair[])pairArray);
                    objectArray[0] = new TraceEvent.Instant("GC detected", map, instantScope, "system");
                    objectArray[1] = TracingWorkflowInterceptor.access$createMemoryEvent(this.this$0);
                    traceLogger.log(CollectionsKt.listOf((Object[])objectArray));
                }
            }
        });
    }

    private final void onRuntimeStopped() {
        block0: {
            GcDetector gcDetector = this.gcDetector;
            if (gcDetector == null) break block0;
            gcDetector.stop();
        }
    }

    private final void onBeforeRenderPass(Object props) {
        block0: {
            TraceLogger traceLogger = this.logger;
            if (traceLogger == null) break block0;
            Object[] objectArray = new TraceEvent[2];
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"props", (Object)String.valueOf(props)));
            objectArray[0] = new TraceEvent.DurationBegin("Render Pass", map, "rendering");
            objectArray[1] = this.createMemoryEvent();
            traceLogger.log(CollectionsKt.listOf((Object[])objectArray));
        }
    }

    private final void onAfterRenderPass(Object rendering) {
        block0: {
            TraceLogger traceLogger = this.logger;
            if (traceLogger == null) break block0;
            Object[] objectArray = new TraceEvent[2];
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"rendering", (Object)String.valueOf(rendering)));
            objectArray[0] = new TraceEvent.DurationEnd("Render Pass", map, "rendering");
            objectArray[1] = this.createMemoryEvent();
            traceLogger.log(CollectionsKt.listOf((Object[])objectArray));
        }
    }

    private final void onWorkflowStarted(long workflowId, Long parentId, String workflowType, String key, Object initialProps, Object initialState, boolean restoredFromSnapshot) {
        block0: {
            String keyPart = ((CharSequence)key).length() == 0 ? "" : ':' + key;
            StringBuilder stringBuilder = new StringBuilder().append(workflowType).append(keyPart).append(" (");
            long $this$toHex$iv = workflowId;
            boolean $i$f$toHex = false;
            String string = Long.toString($this$toHex$iv, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            String name = stringBuilder.append(string).append(')').toString();
            Object[] objectArray = Long.valueOf(workflowId);
            this.workflowNamesById.put((Long)objectArray, name);
            TraceLogger traceLogger = this.logger;
            if (traceLogger == null) break block0;
            objectArray = new TraceEvent[2];
            Pair[] pairArray = new Pair[5];
            long $this$toHex$iv2 = workflowId;
            boolean $i$f$toHex2 = false;
            String string2 = Long.toString($this$toHex$iv2, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
            pairArray[0] = TuplesKt.to((Object)"workflowId", (Object)string2);
            pairArray[1] = TuplesKt.to((Object)"initialProps", (Object)String.valueOf(initialProps));
            pairArray[2] = TuplesKt.to((Object)"initialState", (Object)String.valueOf(initialState));
            pairArray[3] = TuplesKt.to((Object)"restoredFromSnapshot", (Object)restoredFromSnapshot);
            pairArray[4] = TuplesKt.to((Object)"parent", (Object)this.workflowNamesById.get(parentId));
            Map map = MapsKt.mapOf((Pair[])pairArray);
            objectArray[0] = new TraceEvent.AsyncDurationBegin((Object)"workflow", name, map, "workflow");
            objectArray[1] = new TraceEvent.ObjectCreated(workflowId, name);
            traceLogger.log(CollectionsKt.listOf((Object[])objectArray));
        }
    }

    private final void onWorkflowStopped(long workflowId) {
        Object[] objectArray;
        String name = (String)MapsKt.getValue(this.workflowNamesById, (Object)workflowId);
        TraceLogger traceLogger = this.logger;
        if (traceLogger != null) {
            objectArray = new TraceEvent[]{new TraceEvent.AsyncDurationEnd((Object)"workflow", name, null, "workflow", 4, null), new TraceEvent.ObjectDestroyed(workflowId, name)};
            traceLogger.log(CollectionsKt.listOf((Object[])objectArray));
        }
        objectArray = workflowId;
        this.workflowNamesById.remove(objectArray);
    }

    private final void onBeforeWorkflowRendered(long workflowId, Object props, Object state) {
        block0: {
            String name = (String)MapsKt.getValue(this.workflowNamesById, (Object)workflowId);
            TraceLogger traceLogger = this.logger;
            if (traceLogger == null) break block0;
            Pair[] pairArray = new Pair[3];
            long $this$toHex$iv = workflowId;
            boolean $i$f$toHex = false;
            String string = Long.toString($this$toHex$iv, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            pairArray[0] = TuplesKt.to((Object)"workflowId", (Object)string);
            pairArray[1] = TuplesKt.to((Object)"props", (Object)String.valueOf(props));
            pairArray[2] = TuplesKt.to((Object)"state", (Object)String.valueOf(state));
            traceLogger.log((TraceEvent)new TraceEvent.DurationBegin(name, MapsKt.mapOf((Pair[])pairArray), "rendering"));
        }
    }

    private final void onAfterWorkflowRendered(long workflowId, Object rendering) {
        block0: {
            String name = (String)MapsKt.getValue(this.workflowNamesById, (Object)workflowId);
            TraceLogger traceLogger = this.logger;
            if (traceLogger == null) break block0;
            traceLogger.log((TraceEvent)new TraceEvent.DurationEnd(name, MapsKt.mapOf((Pair)TuplesKt.to((Object)"rendering", (Object)String.valueOf(rendering))), "rendering"));
        }
    }

    private final void onBeforeSnapshotPass() {
        block0: {
            TraceLogger traceLogger = this.logger;
            if (traceLogger == null) break block0;
            traceLogger.log((TraceEvent)new TraceEvent.DurationBegin("Snapshot", null, null, 6, null));
        }
    }

    private final void onAfterSnapshotPass() {
        block0: {
            TraceLogger traceLogger = this.logger;
            if (traceLogger == null) break block0;
            traceLogger.log((TraceEvent)new TraceEvent.DurationEnd("Snapshot", null, null, 6, null));
        }
    }

    private final void onSinkReceived(long workflowId, WorkflowAction<?, ?, ?> action) {
        block0: {
            String name = (String)MapsKt.getValue(this.workflowNamesById, (Object)workflowId);
            TraceLogger traceLogger = this.logger;
            if (traceLogger == null) break block0;
            String string = "Sink received: " + name;
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"action", (Object)action.toString()));
            traceLogger.log((TraceEvent)new TraceEvent.Instant(string, map, null, "update", 4, null));
        }
    }

    private final void onPropsChanged(Long workflowId, Object oldProps, Object newProps, Object oldState, Object newState) {
        block1: {
            String string = this.workflowNamesById.get(workflowId);
            if (string == null) {
                string = "{root}";
            }
            String name = string;
            TraceLogger traceLogger = this.logger;
            if (traceLogger == null) break block1;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"oldProps", (Object)String.valueOf(oldProps)), TuplesKt.to((Object)"newProps", (Object)(Intrinsics.areEqual((Object)oldProps, (Object)newProps) ? "{no change}" : String.valueOf(newProps))), TuplesKt.to((Object)"oldState", (Object)String.valueOf(oldState)), TuplesKt.to((Object)"newState", (Object)(Intrinsics.areEqual((Object)oldState, (Object)newState) ? "{no change}" : String.valueOf(newState)))};
            traceLogger.log((TraceEvent)new TraceEvent.Instant("Props changed: " + name, MapsKt.mapOf((Pair[])pairArray), null, null, 12, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onWorkflowAction(long workflowId, WorkflowAction<?, ?, ?> action, Object oldState, Object newState, ActionApplied<? extends Object> output) {
        block2: {
            Object object;
            String string;
            Pair[] pairArray;
            TraceEvent.Instant.InstantScope instantScope;
            String string2;
            Object[] objectArray;
            TraceLogger traceLogger;
            String name;
            block4: {
                block3: {
                    void it;
                    name = (String)MapsKt.getValue(this.workflowNamesById, (Object)workflowId);
                    traceLogger = this.logger;
                    if (traceLogger == null) break block2;
                    Object[] objectArray2 = objectArray = new TraceEvent[2];
                    int n = 0;
                    string2 = "WorkflowAction: " + name;
                    instantScope = TraceEvent.Instant.InstantScope.PROCESS;
                    pairArray = new Pair[4];
                    pairArray[0] = TuplesKt.to((Object)"action", (Object)action.toString());
                    pairArray[1] = TuplesKt.to((Object)"oldState", (Object)String.valueOf(oldState));
                    pairArray[2] = TuplesKt.to((Object)"newState", (Object)(Intrinsics.areEqual((Object)oldState, (Object)newState) ? "{no change}" : String.valueOf(newState)));
                    Pair[] pairArray2 = pairArray;
                    int n2 = 3;
                    string = "output";
                    object = output;
                    if (object == null) break block3;
                    ActionApplied<? extends Object> actionApplied = object;
                    String string3 = string;
                    int n3 = n2;
                    Pair[] pairArray3 = pairArray2;
                    int n4 = n;
                    Object[] objectArray3 = objectArray2;
                    TraceLogger traceLogger2 = traceLogger;
                    boolean bl = false;
                    WorkflowOutput workflowOutput = it.getOutput();
                    String string4 = String.valueOf(workflowOutput != null ? workflowOutput.getValue() : null);
                    traceLogger = traceLogger2;
                    objectArray2 = objectArray3;
                    n = n4;
                    pairArray2 = pairArray3;
                    n2 = n3;
                    string = string3;
                    String string5 = string4;
                    object = string5;
                    if (string5 != null) break block4;
                }
                object = "{no output}";
            }
            pairArray2[n2] = TuplesKt.to((Object)string, object);
            Map map = MapsKt.mapOf((Pair[])pairArray);
            objectArray2[n] = new TraceEvent.Instant(string2, map, instantScope, "update");
            objectArray[1] = new TraceEvent.ObjectSnapshot(workflowId, name, (Object)String.valueOf(newState));
            traceLogger.log(CollectionsKt.listOf((Object[])objectArray));
        }
    }

    private final TraceEvent.Counter createMemoryEvent() {
        long freeMemory = this.memoryStats.freeMemory();
        long usedMemory = this.memoryStats.totalMemory() - freeMemory;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"usedMemory", (Object)usedMemory), TuplesKt.to((Object)"freeMemory", (Object)freeMemory)};
        return new TraceEvent.Counter("used/free memory", MapsKt.mapOf((Pair[])pairArray), null, 4, null);
    }

    @NotNull
    public <P, R> RenderingAndSnapshot<R> onRenderAndSnapshot(P renderProps, @NotNull Function1<? super P, ? extends RenderingAndSnapshot<? extends R>> proceed, @NotNull WorkflowInterceptor.WorkflowSession session) {
        return WorkflowInterceptor.DefaultImpls.onRenderAndSnapshot((WorkflowInterceptor)this, renderProps, proceed, (WorkflowInterceptor.WorkflowSession)session);
    }

    @NotNull
    public TreeSnapshot onSnapshotStateWithChildren(@NotNull Function0<TreeSnapshot> proceed, @NotNull WorkflowInterceptor.WorkflowSession session) {
        return WorkflowInterceptor.DefaultImpls.onSnapshotStateWithChildren((WorkflowInterceptor)this, proceed, (WorkflowInterceptor.WorkflowSession)session);
    }

    public static final /* synthetic */ void access$onWorkflowStopped(TracingWorkflowInterceptor $this, long workflowId) {
        $this.onWorkflowStopped(workflowId);
    }

    public static final /* synthetic */ void access$onRuntimeStopped(TracingWorkflowInterceptor $this) {
        $this.onRuntimeStopped();
    }

    public static final /* synthetic */ TraceLogger access$getLogger$p(TracingWorkflowInterceptor $this) {
        return $this.logger;
    }

    public static final /* synthetic */ MemoryStats access$getMemoryStats$p(TracingWorkflowInterceptor $this) {
        return $this.memoryStats;
    }

    public static final /* synthetic */ TraceEvent.Counter access$createMemoryEvent(TracingWorkflowInterceptor $this) {
        return $this.createMemoryEvent();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B'\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\t\u001a\u00020\n*\u00180\u000bR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/squareup/workflow1/diagnostic/tracing/TracingWorkflowInterceptor$TracingAction;", "P", "S", "O", "Lcom/squareup/workflow1/WorkflowAction;", "delegate", "session", "Lcom/squareup/workflow1/WorkflowInterceptor$WorkflowSession;", "(Lcom/squareup/workflow1/diagnostic/tracing/TracingWorkflowInterceptor;Lcom/squareup/workflow1/WorkflowAction;Lcom/squareup/workflow1/WorkflowInterceptor$WorkflowSession;)V", "apply", "", "Lcom/squareup/workflow1/WorkflowAction$Updater;", "wf1-workflow-tracing"})
    @SourceDebugExtension(value={"SMAP\nTracingWorkflowInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TracingWorkflowInterceptor.kt\ncom/squareup/workflow1/diagnostic/tracing/TracingWorkflowInterceptor$TracingAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,529:1\n1#2:530\n*E\n"})
    private final class TracingAction<P, S, O>
    extends WorkflowAction<P, S, O> {
        @NotNull
        private final WorkflowAction<P, S, O> delegate;
        @NotNull
        private final WorkflowInterceptor.WorkflowSession session;

        public TracingAction(@NotNull WorkflowAction<? super P, S, ? extends O> delegate, WorkflowInterceptor.WorkflowSession session) {
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.delegate = delegate;
            this.session = session;
        }

        public void apply(@NotNull WorkflowAction.Updater $this$apply) {
            Intrinsics.checkNotNullParameter((Object)$this$apply, (String)"<this>");
            Object oldState = $this$apply.getState();
            Pair pair = Workflows.applyTo(this.delegate, (Object)$this$apply.getProps(), (Object)$this$apply.getState());
            Object newState = pair.component1();
            ActionApplied output = (ActionApplied)pair.component2();
            $this$apply.setState(newState);
            WorkflowOutput workflowOutput = output.getOutput();
            if (workflowOutput != null) {
                WorkflowOutput it = workflowOutput;
                boolean bl = false;
                $this$apply.setOutput(it.getValue());
            }
            TracingWorkflowInterceptor.this.onWorkflowAction(this.session.getSessionId(), this.delegate, oldState, newState, (ActionApplied<? extends Object>)output);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007JH\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b2$\u0010\f\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b\u0012\u0004\u0012\u00020\t0\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/squareup/workflow1/diagnostic/tracing/TracingWorkflowInterceptor$TracingContextInterceptor;", "P", "S", "O", "Lcom/squareup/workflow1/WorkflowInterceptor$RenderContextInterceptor;", "session", "Lcom/squareup/workflow1/WorkflowInterceptor$WorkflowSession;", "(Lcom/squareup/workflow1/diagnostic/tracing/TracingWorkflowInterceptor;Lcom/squareup/workflow1/WorkflowInterceptor$WorkflowSession;)V", "onActionSent", "", "action", "Lcom/squareup/workflow1/WorkflowAction;", "proceed", "Lkotlin/Function1;", "wf1-workflow-tracing"})
    private final class TracingContextInterceptor<P, S, O>
    implements WorkflowInterceptor.RenderContextInterceptor<P, S, O> {
        @NotNull
        private final WorkflowInterceptor.WorkflowSession session;

        public TracingContextInterceptor(WorkflowInterceptor.WorkflowSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
        }

        public void onActionSent(@NotNull WorkflowAction<? super P, S, ? extends O> action, @NotNull Function1<? super WorkflowAction<? super P, S, ? extends O>, Unit> proceed) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            Intrinsics.checkNotNullParameter(proceed, (String)"proceed");
            TracingWorkflowInterceptor.this.onSinkReceived(this.session.getSessionId(), action);
            TracingAction<? super P, S, ? extends O> wrapperAction = new TracingAction<P, S, O>(action, this.session);
            proceed.invoke(wrapperAction);
        }

        public <CP, CO, CR> CR onRenderChild(@NotNull Workflow<? super CP, ? extends CO, ? extends CR> child, CP childProps, @NotNull String key, @NotNull Function1<? super CO, ? extends WorkflowAction<? super P, S, ? extends O>> handler, @NotNull Function4<? super Workflow<? super CP, ? extends CO, ? extends CR>, ? super CP, ? super String, ? super Function1<? super CO, ? extends WorkflowAction<? super P, S, ? extends O>>, ? extends CR> proceed) {
            return (CR)WorkflowInterceptor.RenderContextInterceptor.DefaultImpls.onRenderChild((WorkflowInterceptor.RenderContextInterceptor)this, child, childProps, (String)key, handler, proceed);
        }

        public void onRunningSideEffect(@NotNull String key, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> sideEffect, @NotNull Function2<? super String, ? super Function1<? super Continuation<? super Unit>, ? extends Object>, Unit> proceed) {
            WorkflowInterceptor.RenderContextInterceptor.DefaultImpls.onRunningSideEffect((WorkflowInterceptor.RenderContextInterceptor)this, (String)key, sideEffect, proceed);
        }
    }
}

