/*
 * Decompiled with CFR 0.152.
 */
package com.nervepoint.forker.examples;

import com.sshtools.forker.client.DefaultNonBlockingProcessListener;
import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.client.ForkerProcessListener;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcess;
import com.sshtools.forker.common.IO;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.SystemUtils;

public class NonBlockingBiDir {
    public static void main(String[] args) throws Exception {
        ForkerBuilder builder = new ForkerBuilder(new String[0]).io(IO.NON_BLOCKING).redirectErrorStream(true);
        if (!SystemUtils.IS_OS_UNIX) {
            throw new UnsupportedOperationException();
        }
        builder.command(new String[]{"wc", "-l"});
        NonBlockingProcess process = (NonBlockingProcess)builder.start((ForkerProcessListener)new DefaultNonBlockingProcessListener(){

            public void onStdout(NonBlockingProcess process, ByteBuffer buffer, boolean closed) {
                if (!closed) {
                    byte[] bytes = new byte[buffer.remaining()];
                    buffer.get(bytes);
                    System.out.println(new String(bytes));
                }
            }

            public boolean onStdinReady(NonBlockingProcess process, ByteBuffer buffer) {
                buffer.put("This is line 3\n".getBytes());
                buffer.flip();
                try {
                    process.closeStdin(false);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to close.");
                }
                return false;
            }
        });
        new PrintWriter(process.getOutputStream(), true).println("This is line 1");
        process.writeStdin(ByteBuffer.wrap("This is line 2\n".getBytes()));
        process.wantWrite();
        System.out.println("Done: " + process.waitFor());
    }
}

