/*
 * Decompiled with CFR 0.152.
 */
package com.nervepoint.forker.examples;

import com.sshtools.forker.client.DefaultNonBlockingProcessListener;
import com.sshtools.forker.client.ForkerProcessListener;
import com.sshtools.forker.client.ShellBuilder;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcess;
import com.sshtools.forker.common.IO;
import com.sshtools.forker.common.OS;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;

public class NonBlockingShell {
    public static void main(String[] args) throws Exception {
        OS.unbufferedStdin();
        ShellBuilder shell = new ShellBuilder(new String[0]);
        shell.io(IO.NON_BLOCKING);
        shell.redirectErrorStream(true);
        shell.environment().put("MYENV", "An environment variable");
        NonBlockingProcess p = (NonBlockingProcess)shell.start((ForkerProcessListener)new DefaultNonBlockingProcessListener(){

            public void onStdout(NonBlockingProcess process, ByteBuffer buffer, boolean closed) {
                if (!closed) {
                    byte[] bytes = new byte[buffer.remaining()];
                    buffer.get(bytes);
                    System.out.println(new String(bytes));
                }
            }
        });
        IOUtils.copy((InputStream)System.in, (OutputStream)p.getOutputStream());
        p.getOutputStream().close();
        int ret = p.waitFor();
        System.err.println("Exited with code: " + ret);
        System.exit(ret);
    }
}

