/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.nio;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;

public class AbstractFileBasicAttributes
implements BasicFileAttributes {
    private final AbstractFile e;

    AbstractFileBasicAttributes(AbstractFile e) {
        this.e = e;
    }

    @Override
    public FileTime creationTime() {
        try {
            return FileTime.from(this.e.getAttributes().getCreationTime().longValue(), TimeUnit.SECONDS);
        }
        catch (PermissionDeniedException | IOException e) {
            return null;
        }
    }

    @Override
    public Object fileKey() {
        return null;
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.e.isDirectory();
        }
        catch (PermissionDeniedException | IOException e) {
            return false;
        }
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public boolean isRegularFile() {
        try {
            return this.e.isFile();
        }
        catch (PermissionDeniedException | IOException e) {
            return false;
        }
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public FileTime lastAccessTime() {
        try {
            return FileTime.from(this.e.getAttributes().getAccessedTime().longValue(), TimeUnit.SECONDS);
        }
        catch (PermissionDeniedException | IOException e) {
            return null;
        }
    }

    @Override
    public FileTime lastModifiedTime() {
        try {
            return FileTime.from(this.e.getAttributes().getModifiedTime().longValue(), TimeUnit.SECONDS);
        }
        catch (PermissionDeniedException | IOException e) {
            return null;
        }
    }

    @Override
    public long size() {
        try {
            return this.e.getAttributes().getSize().longValue();
        }
        catch (PermissionDeniedException | IOException e) {
            return 0L;
        }
    }
}

