/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.nio;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.nio.AbstractFileNIOProvider;
import com.sshtools.common.files.nio.AbstractFilePath;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.SshConnection;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AbstractFileNIOFileSystem
extends FileSystem {
    URI uri;
    SshConnection con;
    AbstractFileNIOProvider provider;
    static Set<String> supportedViews = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic")));

    public AbstractFileNIOFileSystem(SshConnection con, URI uri, AbstractFileNIOProvider provider) {
        this.con = con;
        this.uri = uri;
        this.provider = provider;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return new ArrayList<Path>(Arrays.asList(this.getRootPath()));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return new ArrayList<FileStore>(Arrays.asList(new FileStore(){

            @Override
            public String type() {
                return "abfs";
            }

            @Override
            public boolean supportsFileAttributeView(String name) {
                return "basic".equals(name);
            }

            @Override
            public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
                return type.getName().equals("basic");
            }

            @Override
            public String name() {
                return "abfs";
            }

            @Override
            public boolean isReadOnly() {
                return false;
            }

            @Override
            public long getUsableSpace() throws IOException {
                return 0L;
            }

            @Override
            public long getUnallocatedSpace() throws IOException {
                return 0L;
            }

            @Override
            public long getTotalSpace() throws IOException {
                return 0L;
            }

            @Override
            public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
                return null;
            }

            @Override
            public Object getAttribute(String attribute) throws IOException {
                return null;
            }
        }));
    }

    public Iterator<Path> iterator(final Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        try {
            AbstractFile obj = AbstractFileNIOProvider.toAbstractFilePath(path).getAbstractFile();
            final List<AbstractFile> children = obj.getChildren();
            return new Iterator<Path>(){
                int index;

                @Override
                public boolean hasNext() {
                    return this.index < children.size();
                }

                @Override
                public Path next() {
                    return path.resolve(((AbstractFile)children.get(this.index++)).getName());
                }
            };
        }
        catch (PermissionDeniedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return supportedViews;
    }

    @Override
    public Path getPath(String first, String ... more) {
        boolean absolute = first.startsWith("/");
        if (absolute) {
            first = first.substring(1);
        }
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(first);
        if (more.length > 0) {
            elements.addAll(Arrays.asList(more));
        }
        return new AbstractFilePath(this, elements, absolute);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return null;
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void assertOpen() {
    }

    public AbstractFilePath getRootPath() {
        return new AbstractFilePath(this, new ArrayList<String>(), true);
    }

    public SshConnection getConnection() {
        return this.con;
    }
}

