/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh;

import com.sshtools.common.ssh.RequestFuture;
import com.sshtools.common.ssh.RequestFutureListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRequestFuture
implements RequestFuture {
    boolean done = false;
    boolean success = false;
    List<RequestFutureListener> listeners = new ArrayList<RequestFutureListener>();

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    public synchronized void done(boolean success) {
        this.done = true;
        this.success = success;
        for (RequestFutureListener future : this.listeners) {
            future.complete(this);
        }
        this.notifyAll();
    }

    @Override
    public synchronized RequestFuture waitForever() {
        try {
            while (!this.done) {
                this.wait(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public synchronized RequestFuture waitFor(long timeout) {
        if (this.done) {
            return this;
        }
        try {
            this.wait(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public synchronized void addFutureListener(RequestFutureListener listener) {
        if (this.isDone()) {
            listener.complete(this);
        } else {
            this.listeners.add(listener);
        }
    }
}

