package com.startapp.sdk.adsbase;

import static com.startapp.sdk.adsbase.AdsCommonUtils.findPlacementIdForContext;
import static com.startapp.sdk.adsbase.AdsCommonUtils.postToMainThread;
import static com.startapp.sdk.adsbase.AdsCommonUtils.sendTrackingClick;
import static com.startapp.sdk.adsbase.ImpressionsReporter.makeImpressions;
import static com.startapp.sdk.adsbase.adlisteners.AdDisplayListenerWrapper.adClicked;
import static com.startapp.sdk.adsbase.adlisteners.AdDisplayListenerWrapper.adDisplayed;
import static com.startapp.sdk.adsbase.adlisteners.AdDisplayListenerWrapper.adHidden;
import static com.startapp.sdk.adsbase.adlisteners.AdDisplayListenerWrapper.adNotDisplayed;
import static com.startapp.sdk.adsbase.adlisteners.NotDisplayedReason.AD_NOT_READY_VIDEO_FALLBACK;
import static com.startapp.sdk.adsbase.adlisteners.VideoListenerWrapper.onVideoCompleted;
import static com.startapp.startappsdk.BuildConfig.DEBUG;
import static com.startapp.startappsdk.BuildConfig.RCD_ENABLED;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.startapp.sdk.ads.external.AdListener;
import com.startapp.sdk.ads.external.AdsFactory;
import com.startapp.sdk.ads.external.ExternalAdTracking;
import com.startapp.sdk.ads.external.ExternalUtils;
import com.startapp.sdk.ads.external.Fullscreen;
import com.startapp.sdk.ads.external.InfoService;
import com.startapp.sdk.ads.external.config.AdUnitConfig;
import com.startapp.sdk.ads.external.config.ExternalAdConfig;
import com.startapp.sdk.ads.external.config.ExternalConfig;
import com.startapp.sdk.ads.external.config.PlacementConfig;
import com.startapp.sdk.ads.splash.SplashConfig;
import com.startapp.sdk.ads.splash.SplashHideListener;
import com.startapp.sdk.adsbase.adlisteners.AdDisplayListener;
import com.startapp.sdk.adsbase.adlisteners.AdEventListener;
import com.startapp.sdk.adsbase.adlisteners.AdEventListenerWrapper;
import com.startapp.sdk.adsbase.adlisteners.NotDisplayedReason;
import com.startapp.sdk.adsbase.adlisteners.VideoListener;
import com.startapp.sdk.adsbase.adrules.AdDisplayEvent;
import com.startapp.sdk.adsbase.adrules.AdDisplayEventManager;
import com.startapp.sdk.adsbase.adrules.AdRulesResult;
import com.startapp.sdk.adsbase.cache.AdCacheManager;
import com.startapp.sdk.adsbase.cache.CacheKey;
import com.startapp.sdk.adsbase.infoevents.InfoEvent;
import com.startapp.sdk.adsbase.model.AdPreferences;
import com.startapp.sdk.adsbase.remoteconfig.MetaData;
import com.startapp.sdk.adsbase.utils.ApplicationContext;
import com.startapp.sdk.adsbase.utils.LazyRef;
import com.startapp.sdk.adsbase.utils.Util;
import com.startapp.sdk.common.LocalBroadcastManager;
import com.startapp.sdk.common.utils.AU;
import com.startapp.sdk.common.utils.ToastManager;
import com.startapp.sdk.components.ComponentLocator;
import com.startapp.sdk.rcd.RcdScope;

import java.io.Serializable;
import java.util.Collections;
import java.util.UUID;

import kotlin.Unit;

/**
 * Represents an <b>Interstitial Ad</b> - a full screen ad which may be displayed during a natural
 * transition points such as a screen change, after the game over screen, before loading the next
 * game level, etc.
 *
 */
public class StartAppAd extends Ad implements DeveloperInterface {
    /**
     * Represents different kinds of ad content
     *
     */
    @Keep
    public enum AdMode {
        /**
         * Represents any kind of ad content, including the deprecated constants.
         *
         */
        @Keep
        AUTOMATIC,

        /**
         * Represents any kind of ad content, such as video, static image or interactive HTML ad.
         *
         */
        @Keep
        FULLPAGE,

        /**
         * Represents only the <b>Rewarded Video Ad</b>.
         *
         */
        @Keep
        REWARDED_VIDEO,

        /**
         * Represents only the video ad content.
         *
         */
        @Keep
        VIDEO,

    }
    /**
     * It is recommended to keep an instance in memory as a <b>Singleton</b> object, and then reuse
     * it multiple times to load and show ads. In other words, an instance should not be linked to
     * the <code>Activity</code> lifecycle, and it should survive the <code>Activity</code> recreation.
     *
     * @param context <code>Application</code> context
     */
    @Keep
    public StartAppAd(@NonNull Context context) {
        throw new RuntimeException("Stub!");
    }

    /**
     * <b>This method will be removed in version <code>4.12.0</code></b>
     *
     * @see StartAppSDK#init(Context, String, String)
     */
    @Keep
    @Deprecated
    public static void init(Context context, String devId, String appId) {
        throw new RuntimeException("Stub!");
    }

    /**
     * @see #loadAd(AdPreferences, AdEventListener)
     */
    @Keep
    @Deprecated
    @Override
    public void load(AdPreferences adPreferences, final AdEventListener callback) {
        throw new RuntimeException("Stub!");
    }

    /**
     * This methods does nothing.
     *
     */
    @Keep
    @Override
    @Deprecated
    protected void loadAds(AdPreferences adPreferences, AdEventListener callback) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Alias for <code>loadAd(AdMode.AUTOMATIC, new AdPreferences(), null);</code>
     *
     * @see #loadAd(AdMode, AdPreferences, AdEventListener)
     */
    @Keep
    @Override
    public void loadAd() {
        throw new RuntimeException("Stub!");
    }

    /**
     * Alias for <code>loadAd(AdMode.AUTOMATIC, adPreferences, null);</code>
     *
     * @see #loadAd(AdMode, AdPreferences, AdEventListener)
     */
    @Keep
    @Override
    public void loadAd(@NonNull AdPreferences adPreferences) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Alias for <code>loadAd(AdMode.AUTOMATIC, new AdPreferences(), listener);</code>
     *
     * @see #loadAd(AdMode, AdPreferences, AdEventListener)
     */
    @Keep
    @Override
    public void loadAd(@NonNull AdEventListener listener) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Alias for <code>loadAd(AdMode.AUTOMATIC, adPreferences, listener);</code>
     *
     * @see #loadAd(AdMode, AdPreferences, AdEventListener)
     */
    @Keep
    @Override
    public void loadAd(@NonNull AdPreferences adPreferences, @NonNull AdEventListener listener) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Alias for <code>loadAd(adMode, new AdPreferences(), null);</code>
     *
     * @see #loadAd(AdMode, AdPreferences, AdEventListener)
     */
    @Keep
    @Override
    public void loadAd(@NonNull AdMode adMode) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Alias for <code>loadAd(adMode, adPreferences, null);</code>
     *
     * @see #loadAd(AdMode, AdPreferences, AdEventListener)
     */
    @Keep
    @Override
    public void loadAd(@NonNull AdMode adMode, @NonNull AdPreferences adPreferences) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Alias for <code>loadAd(adMode, new AdPreferences(), listener);</code>
     *
     * @see #loadAd(AdMode, AdPreferences, AdEventListener)
     */
    @Keep
    @Override
    public void loadAd(@NonNull AdMode adMode, @NonNull AdEventListener listener) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Loads ad according to the <code>adMode</code> and <code>adPreferences</code> given.
     *
     * @param adMode        one of {@link AdMode#AUTOMATIC}, {@link AdMode#FULLPAGE}, {@link AdMode#VIDEO}
     *                      or {@link AdMode#REWARDED_VIDEO} for the <b>Rewarded Video Ad</b>
     * @param adPreferences ad preferences
     * @param listener      a callback to be invoked when ad finishes loading
     */
    @Keep
    @Override
    public void loadAd(
            @NonNull AdMode adMode,
            @Nullable final AdPreferences adPreferences,
            @Nullable final AdEventListener listener
    ) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Shows an ad, if it has been loaded.
     *
     * @return <code>true</code> if the ad has been shown
     */
    @Keep
    @Override
    public boolean showAd() {
        throw new RuntimeException("Stub!");
    }

    /**
     * <b>This method will be removed in version <code>4.12.0</code></b>
     * <p>
     * The <code>adTag</code> value must be set into {@link AdPreferences} and passed into {@link #loadAd(AdMode, AdPreferences, AdEventListener)}
     *
     * @param adTag adTag
     * @return <code>true</code> if the ad has been shown
     * @see AdPreferences#setAdTag(String)
     */
    @Keep
    @Deprecated
    @Override
    public boolean showAd(String adTag) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Shows an ad, if it has been loaded.
     *
     * @param listener callback to be invoked when an ad events occurred
     * @return <b>true</b> if ad has shown
     */
    @Keep
    @Override
    public boolean showAd(@Nullable AdDisplayListener listener) {
        throw new RuntimeException("Stub!");
    }

    /**
     * <b>This method will be removed in version <code>4.12.0</code></b>
     * <p>
     * The <code>adTag</code> value must be set into {@link AdPreferences} and passed into {@link #loadAd(AdMode, AdPreferences, AdEventListener)}
     *
     * @param adTag adTag
     * @return <code>true</code> if the ad has been shown
     * @see AdPreferences#setAdTag(String)
     */
    @Keep
    @Deprecated
    @Override
    public boolean showAd(@Deprecated String adTag, AdDisplayListener listener) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Sets a listener for video ad events.
     *
     * @param listener listener
     */
    @Keep
    @Override
    public void setVideoListener(@Nullable VideoListener listener) {
        throw new RuntimeException("Stub!");
    }

    /**
     * <b>This method is deprecated.</b>
     * <p>
     * Instead use {@link AdEventListener} in order to receive an event when the ad has been loaded.
     *
     * @return <code>true</code> if the ad has been loaded.
     */
    @Keep
    @Deprecated
    @Override
    public boolean isReady() {
        throw new RuntimeException("Stub!");
    }

    /**
     * This method does nothing and it will be removed completely from future release of SDK 6.0.0
     *
     */
    @Keep
    public static void setReturnAdsPreferences(@Nullable AdPreferences adPreferences) {
        throw new RuntimeException("Stub!");
    }

    /**
     * This method does nothing and it will be removed completely from future release of SDK 6.0.0
     *
     */
    @Keep
    @Deprecated
    public static void showSplash(Activity activity, Bundle savedInstanceState) {
        throw new RuntimeException("Stub!");
    }

    /**
     * This method does nothing and it will be removed completely from future release of SDK 6.0.0
     *
     */
    @Keep
    @Deprecated
    public static void showSplash(Activity activity, Bundle savedInstanceState, SplashConfig configuration) {
        throw new RuntimeException("Stub!");
    }

    /**
     * This method does nothing and it will be removed completely from future release of SDK 6.0.0
     *
     */
    @Keep
    @Deprecated
    public static void showSplash(Activity activity, Bundle savedInstanceState, AdPreferences adPreferences) {
        throw new RuntimeException("Stub!");
    }

    /**
     * This method does nothing and it will be removed completely from future release of SDK 6.0.0
     *
     */
    @Keep
    @Deprecated
    public static void showSplash(Activity activity, Bundle savedInstanceState, SplashConfig configuration, AdPreferences adPreferences) {
        throw new RuntimeException("Stub!");
    }

    /**
     * This method does nothing and it will be removed completely from future release of SDK 6.0.0
     *
     */
    @Keep
    @Deprecated
    public static void showSplash(final Activity activity,
                                  Bundle savedInstanceState,
                                  SplashConfig configuration,
                                  AdPreferences adPreferences,
                                  final SplashHideListener splashHideListener) {
        throw new RuntimeException("Stub!");
    }

}
