package com.startapp.sdk.adsbase;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.SharedPreferences;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.startapp.sdk.adsbase.remoteconfig.MetaDataRequest.RequestReason;
import com.startapp.sdk.adsbase.utils.SessionManager;
import com.startapp.sdk.components.ComponentLocator;

/**
 * Class contains static methods to initialize and configure the Start.io SDK
 *
 */
@Keep
public class StartAppSDK {
    /**
     * <b>Deprecated</b>. Use {@link #initParams(Context, String)} instead.
     * <p>
     * Initialize the SDK with default configuration.
     *
     * @param context context
     * @param appId   <b>app ID</b> from the publisher's portal
     */
    @Keep
    public static void init(@NonNull Context context, @NonNull String appId) {
        throw new RuntimeException("Stub!");
    }

    /**
     * <b>Deprecated</b>. Use {@link #initParams(Context, String)} instead.
     * <p>
     * Initialize the SDK with customized configuration.
     *
     * @param context    context
     * @param appId      <b>app ID</b> from the publisher's portal
     * @param sdkAdPrefs default ad preferences
     */
    @Keep
    public static void init(@NonNull Context context, @NonNull String appId, @NonNull SDKAdPreferences sdkAdPrefs) {
        throw new RuntimeException("Stub!");
    }

    /**
     * <b>Deprecated</b>. Use {@link #initParams(Context, String)} instead.
     * <p>
     * Initialize the SDK with default configuration.
     *
     * @param context   context
     * @param accountId <b>account ID</b> from the publisher's portal
     * @param appId     <b>app ID</b> from the publisher's portal
     */
    @Keep
    public static void init(@NonNull Context context, @Nullable String accountId, @NonNull String appId) {
        throw new RuntimeException("Stub!");
    }

    /**
     * <b>Deprecated</b>. Use {@link #initParams(Context, String)} instead.
     *
     * @param context    context
     * @param accountId  <b>account ID</b> from the publisher's portal
     * @param appId      <b>app ID</b> from the publisher's portal
     * @param sdkAdPrefs ad preferences
     */
    @Keep
    public static void init(
            @NonNull Context context,
            @Nullable String accountId,
            @NonNull String appId,
            @NonNull SDKAdPreferences sdkAdPrefs
    ) {
        throw new RuntimeException("Stub!");
    }

    /**
     * <b>Deprecated</b>. Use {@link #initParams(Context, String)} instead.
     * This method will be removed completely from future release of SDK 6.0.0.
     *
     * @param context         context
     * @param appId           <b>app ID</b> from the publisher's portal
     * @param enableReturnAds this parameter is ignored and has no effect
     */
    @Keep
    @Deprecated
    public static void init(@NonNull Context context, @NonNull String appId, boolean enableReturnAds) {
        throw new RuntimeException("Stub!");
    }

    /**
     * <b>Deprecated</b>. Use {@link #initParams(Context, String)} instead.
     * This method will be removed completely from future release of SDK 6.0.0.
     *
     * @param context         context
     * @param accountId       <b>account ID</b> from the publisher's portal
     * @param appId           <b>app ID</b> from the publisher's portal
     * @param enableReturnAds this parameter is ignored and has no effect
     */
    @Keep
    @Deprecated
    public static void init(
            @NonNull Context context,
            @Nullable String accountId,
            @NonNull String appId,
            boolean enableReturnAds
    ) {
        throw new RuntimeException("Stub!");
    }

    /**
     * <b>Deprecated</b>. Use {@link #initParams(Context, String)} instead.
     * This method will be removed completely from future release of SDK 6.0.0.
     *
     * @param context         context
     * @param appId           <b>app ID</b> from the publisher's portal
     * @param sdkAdPrefs      ad preferences
     * @param enableReturnAds this parameter is ignored and has no effect
     */
    @Keep
    @Deprecated
    public static void init(
            @NonNull Context context,
            @NonNull String appId,
            @NonNull SDKAdPreferences sdkAdPrefs,
            boolean enableReturnAds
    ) {
        throw new RuntimeException("Stub!");
    }

    /**
     * <b>Deprecated</b>. Use {@link #initParams(Context, String)} instead.
     * This method will be removed completely from future release of SDK 6.0.0.
     *
     * @param context         context
     * @param accountId       <b>account ID</b> from the publisher's portal
     * @param appId           <b>app ID</b> from the publisher's portal
     * @param sdkAdPrefs      ad preferences
     * @param enableReturnAds this parameter is ignored and has no effect
     */
    @Keep
    @Deprecated
    @SuppressWarnings("unused")
    public static void init(
            @NonNull Context context,
            @Nullable String accountId,
            @NonNull String appId,
            @Nullable SDKAdPreferences sdkAdPrefs,
            boolean enableReturnAds
    ) {
        throw new RuntimeException("Stub!");
    }

    /**
     * This method does nothing and it will be removed completely from future release of SDK 6.0.0
     *
     */
    @Keep
    @Deprecated
    public static void enableReturnAds(boolean enableReturnAd) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Configure test ads. Must be used during development.
     * <p>
     * Example usage:
     * <pre>
     * if (BuildConfig.DEBUG) {
     *     StartAppSDK.setTestAdsEnabled(true);
     * }
     * </pre>
     *
     * @param enable <code>true</code> - enabled, <code>false</code> - disabled
     */
    @Keep
    public static void setTestAdsEnabled(boolean enable) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Creates an intermediate object which holds parameters for SDK initialization.
     * <p>
     * Example usage:
     * <pre>
     * StartAppSDK.initParams(context, "YOUR_APP_ID")
     *   .setCallback(new Runnable() {
     *     public void run() {
     *       // request ads
     *     }
     *   })
     *   .init();
     * </pre>
     *
     * @param context context
     * @param appId   appId
     * @return new instance for method-chain calls
     * @see InitParams#init()
     */
    @Keep
    @NonNull
    public static InitParams initParams(@NonNull Context context, @NonNull String appId) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Provides a convenient way to configure SDK parameters.
     *
     */
    @Keep
    public static class InitParams {
        /**
         * <b>Account ID</b> from the publisher's portal (optional)
         *
         * @param accountId account ID
         * @return this
         */
        @Keep
        @NonNull
        public InitParams setAccountId(@NonNull String accountId) {
            throw new RuntimeException("Stub!");
        }

        /**
         * Additional parameters.
         *
         * @param sdkAdPrefs ad preferences
         * @return this
         */
        @Keep
        @NonNull
        public InitParams setSdkAdPrefs(@NonNull SDKAdPreferences sdkAdPrefs) {
            throw new RuntimeException("Stub!");
        }

        /**
         * This method does nothing and it will be removed completely from future release of SDK 6.0.0
         *
         */
        @Keep
        @NonNull
        @Deprecated
        public InitParams setReturnAdsEnabled(boolean value) {
            throw new RuntimeException("Stub!");
        }

        /**
         * Callback to be called in UI thread right after SDK initialization.
         *
         * @param callback callback
         * @return this
         */
        @Keep
        @NonNull
        public InitParams setCallback(@NonNull Runnable callback) {
            throw new RuntimeException("Stub!");
        }

        /**
         * Initialize the SDK with configured parameters.
         *
         */
        @Keep
        public void init() {
            throw new RuntimeException("Stub!");
        }

    }
}
