package com.startapp.sdk.adsbase.adlisteners;

import androidx.annotation.Keep;

import com.startapp.sdk.adsbase.Ad;

/**
 * Callback to be invoked when an ad events occurred.
 *
 */
@Keep
public interface AdDisplayListener {
    /**
     * Called when the ad hid full screen content.
     *
     */
    @Keep
    void adHidden(Ad ad);

    /**
     * Called when the ad showed the full screen content.
     *
     */
    @Keep
    void adDisplayed(Ad ad);

    /**
     * Called when a click is recorded for an ad.
     *
     */
    @Keep
    void adClicked(Ad ad);

    /**
     * Called when the ad failed to show full screen content.
     *
     */
    @Keep
    void adNotDisplayed(Ad ad);

}
