/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.cometd.CometdContext;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.DataHandler;
import com.sun.grizzly.cometd.bayeux.Advice;
import com.sun.grizzly.cometd.bayeux.ConnectRequest;
import com.sun.grizzly.cometd.bayeux.ConnectResponse;
import com.sun.grizzly.cometd.bayeux.Data;
import com.sun.grizzly.cometd.bayeux.DeliverResponse;
import com.sun.grizzly.cometd.bayeux.DisconnectRequest;
import com.sun.grizzly.cometd.bayeux.DisconnectResponse;
import com.sun.grizzly.cometd.bayeux.End;
import com.sun.grizzly.cometd.bayeux.HandshakeRequest;
import com.sun.grizzly.cometd.bayeux.HandshakeResponse;
import com.sun.grizzly.cometd.bayeux.PublishRequest;
import com.sun.grizzly.cometd.bayeux.PublishResponse;
import com.sun.grizzly.cometd.bayeux.ReconnectRequest;
import com.sun.grizzly.cometd.bayeux.ReconnectResponse;
import com.sun.grizzly.cometd.bayeux.SubscribeRequest;
import com.sun.grizzly.cometd.bayeux.SubscribeResponse;
import com.sun.grizzly.cometd.bayeux.UnsubscribeRequest;
import com.sun.grizzly.cometd.bayeux.UnsubscribeResponse;
import com.sun.grizzly.cometd.bayeux.VerbBase;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.LinkedTransferQueue;
import com.sun.grizzly.util.buf.Base64Utils;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BayeuxParser {
    private static final Logger logger = SelectorThread.logger();
    private static final Level level;
    private static boolean enforceSubscriptionUnderPush;
    public static final String DEFAULT_CONTENT_TYPE = "text/json";
    protected static final DataHandler dumyhandler;
    private final SecureRandom random = new SecureRandom();
    private final ConcurrentHashMap<String, AbstractQueue<String>> inactiveChannels = new ConcurrentHashMap(16, 0.75f, 64);
    private final ConcurrentHashMap<String, CometContext> activeCometContexts = new ConcurrentHashMap(16, 0.75f, 64);
    private final ConcurrentHashMap<String, DataHandler> authenticatedUsers = new ConcurrentHashMap(16, 0.75f, 64);
    private final ThreadLocal<Set<String>> deliverInChannels = new ThreadLocal<Set<String>>(){

        @Override
        protected Set initialValue() {
            return new HashSet();
        }
    };

    public void parse(CometdContext cometdContext) throws IOException {
        this.log(cometdContext.getVerb().toString());
        switch (cometdContext.getVerb().getType()) {
            case HANDSHAKE: {
                this.onHandshake(cometdContext);
                break;
            }
            case CONNECT: {
                this.onConnect(cometdContext);
                break;
            }
            case DISCONNECT: {
                this.onDisconnect(cometdContext);
                break;
            }
            case RECONNECT: {
                this.onReconnect(cometdContext);
                break;
            }
            case SUBSCRIBE: {
                this.onSubscribe(cometdContext);
                break;
            }
            case UNSUBSCRIBE: {
                this.onUnsubscribe(cometdContext);
                break;
            }
            case PUBLISH: {
                this.onPublish(cometdContext);
                break;
            }
            case PING: {
                this.onPing(cometdContext);
                break;
            }
            case STATUS: {
                this.onStatus(cometdContext);
                break;
            }
        }
    }

    public void onHandshake(CometdContext cometdContext) throws IOException {
        CometdResponse res = cometdContext.getResponse();
        HandshakeRequest handshakeReq = (HandshakeRequest)cometdContext.getVerb();
        HandshakeResponse handshakeRes = new HandshakeResponse(handshakeReq);
        handshakeRes.setAdvice(new Advice());
        if (handshakeReq.isValid()) {
            byte[] ba;
            String clientId = null;
            do {
                ba = new byte[16];
                this.random.nextBytes(ba);
            } while (this.authenticatedUsers.putIfAbsent(clientId = Base64Utils.encodeToString(ba, false), dumyhandler) != null);
            handshakeRes.setClientId(clientId);
        } else {
            handshakeRes.setSuccessful(false);
            handshakeRes.setError("501::invalid handshake");
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(handshakeRes.toJSON());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnect(CometdContext cometdContext) throws IOException {
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        DataHandler dataHandler = this.isAuthenticatedAndValid(cometdContext);
        if (dataHandler != null) {
            ConnectRequest connectReq = (ConnectRequest)cometdContext.getVerb();
            ConnectResponse connectRes = new ConnectResponse(connectReq);
            connectRes.setAdvice(new Advice());
            if (dataHandler != dumyhandler) {
                DataHandler dataHandler2 = dataHandler;
                synchronized (dataHandler2) {
                    if (dataHandler.getChannels().size() > 0) {
                        res.write(connectRes.toLongPolledJSON());
                        for (String channel : dataHandler.getChannels()) {
                            CometContext cc = this.getCometContext(channel);
                            if (cc.isActive(dataHandler)) continue;
                            if (logger.isLoggable(level)) {
                                this.log("Suspending client: " + connectReq.getClientId() + " channel: " + channel);
                            }
                            dataHandler.attach(new Object[]{req, res});
                            cc.addCometHandler(dataHandler);
                            dataHandler.setSuspended(true);
                        }
                        connectRes.setAdvice(null);
                        return;
                    }
                }
            }
            res.write(connectRes.toJSON());
        }
    }

    public void onDisconnect(CometdContext cometdContext) throws IOException {
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        DisconnectRequest disconnectReq = (DisconnectRequest)cometdContext.getVerb();
        DisconnectResponse disconnectRes = new DisconnectResponse(disconnectReq);
        DataHandler dataHandler = this.isAuthenticatedAndValid(cometdContext);
        if (dataHandler != null) {
            this.authenticatedUsers.remove(disconnectReq.getClientId());
            dataHandler.write(disconnectRes.toJSON(), res, true);
        }
        this.notifyEnd(disconnectRes, req.getRemotePort(), dataHandler);
    }

    public void onReconnect(CometdContext cometdContext) throws IOException {
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        ReconnectRequest reconnectReq = (ReconnectRequest)cometdContext.getVerb();
        ReconnectResponse reconnectRes = new ReconnectResponse(reconnectReq);
        DataHandler dataHandler = this.isAuthenticatedAndValid(cometdContext);
        if (dataHandler != null) {
            dataHandler.write(reconnectRes.toJSON(), res, true);
        }
        this.notifyEnd(reconnectRes, req.getRemotePort(), dataHandler);
    }

    public void onSubscribe(CometdContext cometdContext) throws IOException {
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        SubscribeRequest subscribeReq = (SubscribeRequest)cometdContext.getVerb();
        SubscribeResponse subscribeRes = new SubscribeResponse(subscribeReq);
        DataHandler dataHandler = this.isAuthenticatedAndValid(cometdContext);
        if (dataHandler != null) {
            if (dataHandler == dumyhandler) {
                dataHandler = new DataHandler(this);
                String clientId = subscribeReq.getClientId();
                this.authenticatedUsers.put(clientId, dataHandler);
            }
            dataHandler.addChannel(subscribeReq.getSubscription());
            if (dataHandler.isSuspended()) {
                subscribeRes.setLast(true);
            }
            dataHandler.write(subscribeRes.toJSON(), res, true);
        }
        this.notifyEnd(subscribeRes, req.getRemotePort(), dataHandler);
    }

    public void onUnsubscribe(CometdContext cometdContext) throws IOException {
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        UnsubscribeRequest unsubscribeReq = (UnsubscribeRequest)cometdContext.getVerb();
        UnsubscribeResponse unsubscribeRes = new UnsubscribeResponse(unsubscribeReq);
        boolean hasSubscription = false;
        String subscription = unsubscribeReq.getSubscription();
        DataHandler dataHandler = this.isAuthenticatedAndValid(cometdContext);
        if (dataHandler != null) {
            if (dataHandler != dumyhandler && (hasSubscription = dataHandler.containsChannel(subscription))) {
                AbstractQueue<String> uscs;
                String clientId = unsubscribeReq.getClientId();
                AbstractQueue<String> unsubscribedChannels = this.inactiveChannels.get(clientId);
                if (unsubscribedChannels == null && (uscs = this.inactiveChannels.putIfAbsent(clientId, unsubscribedChannels = new LinkedTransferQueue<String>())) != null) {
                    unsubscribedChannels = uscs;
                }
                unsubscribedChannels.add(subscription);
            }
            unsubscribeRes.setSuccessful(hasSubscription);
            dataHandler.write(unsubscribeRes.toJSON(), res, true);
        }
        this.notifyEnd(unsubscribeRes, req.getRemotePort(), dataHandler);
        if (hasSubscription) {
            dataHandler.removeChannel(subscription);
        }
    }

    public void onPublish(CometdContext cometdContext) throws IOException {
        DataHandler dataHandler = this.isAuthenticatedAndValid(cometdContext);
        if (dataHandler == null) {
            return;
        }
        CometdRequest req = cometdContext.getRequest();
        PublishRequest publishReq = (PublishRequest)cometdContext.getVerb();
        PublishResponse publishRes = new PublishResponse(publishReq);
        publishRes.setSuccessful(true);
        boolean justSubscribedInTheSameRequest = dataHandler != dumyhandler && dataHandler.getRemotePort() == -1;
        boolean deliverToSamePort = justSubscribedInTheSameRequest || dataHandler != dumyhandler && dataHandler.getRemotePort() == req.getRemotePort();
        Data data = publishReq.getData();
        DeliverResponse deliverRes = null;
        if (data != null) {
            deliverRes = new DeliverResponse(publishReq);
            deliverRes.setFollow(true);
            if (publishReq.isFirst()) {
                deliverRes.setFirst(false);
            }
        }
        if (publishReq.isLast() && deliverRes != null && deliverToSamePort) {
            publishRes.setLast(false);
        }
        CometdResponse res = cometdContext.getResponse();
        dataHandler.write(publishRes.toJSON(), res, false);
        if (deliverRes != null) {
            this.deliverInChannels.get().add(publishReq.getChannel());
            if (justSubscribedInTheSameRequest) {
                dataHandler.write(deliverRes.toJSON(), res, false);
            }
            this.notifyAll(deliverRes, publishRes.getChannel());
        }
        this.notifyEnd(deliverRes, req.getRemotePort(), dataHandler);
    }

    private void notifyAll(Object obj, String channel) throws IOException {
        if (enforceSubscriptionUnderPush) {
            for (Map.Entry<String, CometContext> entry : this.activeCometContexts.entrySet()) {
                entry.getValue().notify(obj);
            }
        } else {
            CometContext cc = this.getCometContext(channel);
            if (logger.isLoggable(level)) {
                this.log("Notifying " + channel + " to " + cc.getCometHandlers().size() + " CometHandler with message\n" + obj);
            }
            cc.notify(obj);
        }
    }

    private void notifyEnd(VerbBase verb, int requestPort, DataHandler dataHandler) throws IOException {
        if (verb.isLast()) {
            Set<String> dic = this.deliverInChannels.get();
            if (dic.size() > 0) {
                End end = new End(requestPort, dic);
                this.notifyAll(end, dic.iterator().next());
                dic.clear();
            }
            boolean dolog = logger.isLoggable(level);
            if (dataHandler != null && dataHandler != dumyhandler) {
                String clientId;
                AbstractQueue<String> unsubscribedChannels;
                Collection<String> subscribedChannels = dataHandler.getChannels();
                if (subscribedChannels != null && subscribedChannels.size() > 0) {
                    int i = 0;
                    for (String channel : subscribedChannels) {
                        if (dolog) {
                            this.log("Removing subscribed " + channel);
                        }
                        if (i++ == 0) continue;
                        this.getCometContext(channel).getCometHandlers().remove(dataHandler);
                    }
                }
                if ((unsubscribedChannels = this.inactiveChannels.get(clientId = verb.getClientId())) != null && !unsubscribedChannels.isEmpty()) {
                    int i = 0;
                    for (String channel : unsubscribedChannels) {
                        if (dolog) {
                            this.log("Removing unsubscribed " + channel);
                        }
                        if (i++ == 0) continue;
                        this.getCometContext(channel).getCometHandlers().remove(dataHandler);
                    }
                }
                if (unsubscribedChannels != null) {
                    unsubscribedChannels.clear();
                    this.inactiveChannels.remove(clientId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataHandler isAuthenticatedAndValid(CometdContext cometdContext) throws IOException {
        CometdResponse res = cometdContext.getResponse();
        res.setContentType(DEFAULT_CONTENT_TYPE);
        VerbBase verb = (VerbBase)cometdContext.getVerb();
        String clientId = verb.getClientId();
        if (clientId == null) {
            return dumyhandler;
        }
        DataHandler dataHandler = this.authenticatedUsers.get(clientId);
        String errmsg = null;
        if (dataHandler == null) {
            errmsg = BayeuxParser.constructError("402", "Unknown Client", verb.getMetaChannel());
        } else if (!verb.isValid()) {
            errmsg = BayeuxParser.constructError("501", "Invalid Operation", verb.getMetaChannel());
        }
        if (errmsg != null) {
            if (dataHandler != null && dataHandler != dumyhandler) {
                DataHandler dataHandler2 = dataHandler;
                synchronized (dataHandler2) {
                    res.write(errmsg);
                    res.flush();
                }
            } else {
                res.write(errmsg);
                res.flush();
            }
            return null;
        }
        return dataHandler;
    }

    private static final String constructError(String errorMessage, String errorMsg, String meta) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("[{\"successful\":false,\"error\":\"");
        sb.append(errorMessage);
        sb.append("::");
        sb.append(errorMsg);
        sb.append("\",\"advice\":{\"reconnect\":\"handshake\"},\"channel\":\"");
        sb.append(meta);
        sb.append("\"}]");
        return sb.toString();
    }

    private CometContext getCometContext(String channel) {
        CometContext cc = this.activeCometContexts.get(channel);
        if (cc == null) {
            cc = this.createCometContext(channel);
            this.activeCometContexts.put(channel, cc);
        }
        return cc;
    }

    private CometContext createCometContext(String channel) {
        CometContext cc = CometEngine.getEngine().register(channel);
        cc.setExpirationDelay(-1L);
        cc.setBlockingNotification(true);
        return cc;
    }

    private void log(String log) {
        logger.log(level, log);
    }

    public void onPing(CometdContext cometdContext) throws IOException {
    }

    public void onStatus(CometdContext cometdContext) throws IOException {
    }

    static {
        enforceSubscriptionUnderPush = true;
        level = System.getProperty("com.sun.grizzly.cometd.logAll") != null ? Level.INFO : Level.FINE;
        if (System.getProperty("com.sun.grizzly.cometd.enforceSubscription") != null) {
            enforceSubscriptionUnderPush = false;
        }
        dumyhandler = new DataHandler(null);
    }
}

