/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet.deployer;

import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.http.servlet.deployer.comparator.WarFileComparator;
import com.sun.grizzly.http.webxml.WebappLoader;
import com.sun.grizzly.http.webxml.schema.Filter;
import com.sun.grizzly.http.webxml.schema.FilterMapping;
import com.sun.grizzly.http.webxml.schema.InitParam;
import com.sun.grizzly.http.webxml.schema.Listener;
import com.sun.grizzly.http.webxml.schema.ServletMapping;
import com.sun.grizzly.http.webxml.schema.WebApp;
import com.sun.grizzly.util.ClassLoaderUtil;
import com.sun.grizzly.util.ExpandJar;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyWebServerDeployer {
    protected static Logger logger = Logger.getLogger("GrizzlyWebServerDeployerLogger");
    public static final String DEFAULT_CONTEXT = "/";
    public static final String WEB_XML_PATH = "WEB-INF" + File.separator + "web.xml";
    private GrizzlyWebServer ws = null;
    private String autodeployFolder;
    private String locations;
    private String webxmlPath;
    private String libraryPath;
    private String forcedContext;
    private boolean waitToStart = false;
    private boolean cometEnabled = false;
    private boolean forceWarDeployment = false;
    private boolean ajpEnabled = false;
    private List<String> deployedApplicationList = null;
    private int port = 8080;

    public void init(String[] args) throws MalformedURLException, IOException, Exception {
        if (args.length == 0) {
            this.printHelpAndExit();
        }
        this.parseOptions(args);
        this.deployedApplicationList = new ArrayList<String>();
    }

    private void deployWar(String location, String context) throws Exception {
        this.webxmlPath = this.appendWarContentToClassPath(location);
        if (context == null) {
            context = this.getContext(this.webxmlPath);
        }
        this.deploy(this.webxmlPath, context, this.webxmlPath + WEB_XML_PATH);
    }

    private void deployServlet(String location) throws Exception {
        this.deployServlet(location, null);
    }

    private void deployServlet(String location, String context) throws Exception {
        if (context == null) {
            context = this.getContext(DEFAULT_CONTEXT);
        }
        this.webxmlPath = this.appendWarContentToClassPath(null);
        this.deploy(null, context, location);
    }

    private void deployExpandedWar(String location) throws Exception {
        this.webxmlPath = this.appendWarContentToClassPath(location);
        this.deploy(this.webxmlPath, this.getContext(this.webxmlPath), this.webxmlPath + WEB_XML_PATH);
    }

    private Map<String, File> getFile(String location) {
        File folder;
        if (location.endsWith(DEFAULT_CONTEXT) && location.length() > 1) {
            location = location.substring(0, location.length() - 1);
        }
        if (!(folder = new File(location)).exists() || !folder.isDirectory()) {
            return null;
        }
        File[] files = folder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.endsWith(".war")) {
                    return true;
                }
                File file = new File(dir + File.separator + name);
                return file.exists() && file.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        Arrays.sort(files, new WarFileComparator());
        HashMap<String, File> fileList = new HashMap<String, File>();
        for (File file : files) {
            String name;
            if (file.isDirectory()) {
                fileList.put(file.getName(), file);
                continue;
            }
            if (file.getName().endsWith(".war") && !this.forceWarDeployment) {
                name = file.getName().substring(0, file.getName().length() - ".war".length());
                if (fileList.containsKey(name)) {
                    logger.log(Level.INFO, "War file skipped");
                    continue;
                }
                fileList.put(name, file);
                continue;
            }
            if (file.getName().endsWith(".war") && this.forceWarDeployment) {
                name = file.getName().substring(0, file.getName().length() - ".war".length());
                if (fileList.containsKey(name)) {
                    fileList.remove(name);
                }
                fileList.put(name, file);
                continue;
            }
            fileList.put(file.getName(), file);
        }
        return fileList;
    }

    public void deployApplications(String locations) throws Exception {
        if (locations != null && locations.length() > 0) {
            String[] location = locations.split(File.pathSeparator);
            for (int i = 0; i < location.length; ++i) {
                this.deployApplication(location[i]);
            }
        }
    }

    private void deployApplication(String location) throws Exception {
        if (location.endsWith(".war")) {
            this.deployWar(location, this.getForcedContext());
            return;
        }
        if (location.endsWith(".xml")) {
            this.deployServlet(location, this.getForcedContext());
            return;
        }
        Map<String, File> fileList = this.getFile(location);
        if (fileList != null) {
            for (File file : fileList.values()) {
                if (file.getName().endsWith(".war")) {
                    this.deployWar(file.getPath(), null);
                    continue;
                }
                File webxmlFile = new File(location + File.separator + WEB_XML_PATH);
                if (webxmlFile.exists()) {
                    this.deployExpandedWar(location + File.separator);
                    continue;
                }
                File webxmlFile2 = new File(location + File.separator + "web.xml");
                if (webxmlFile2.exists()) {
                    this.deployServlet(webxmlFile2.getPath());
                    continue;
                }
                File webapp = new File(file.getPath() + File.separator + WEB_XML_PATH);
                if (webapp.exists()) {
                    this.deployExpandedWar(file.getPath() + File.separator);
                    continue;
                }
                this.deployCustom(file.getPath() + File.separator);
            }
        }
    }

    public String getContext(String path) {
        int lastIndex;
        if (path == null || path.trim().length() == 0) {
            return DEFAULT_CONTEXT;
        }
        path = path.replaceAll("[/\\\\]+", "\\/");
        if ((path = path.replaceAll("\\\\", "\\/")).endsWith(DEFAULT_CONTEXT) && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        if ((lastIndex = path.lastIndexOf(DEFAULT_CONTEXT)) > 0) {
            path = DEFAULT_CONTEXT + path.substring(lastIndex + 1);
        } else if (lastIndex == -1) {
            path = DEFAULT_CONTEXT + path;
        }
        return path;
    }

    public String getServletPath(String path) {
        if (path == null) {
            return DEFAULT_CONTEXT;
        }
        if (!(path = path.replaceAll("\\\\", DEFAULT_CONTEXT)).startsWith(DEFAULT_CONTEXT)) {
            path = DEFAULT_CONTEXT + path;
        }
        if (path.endsWith(DEFAULT_CONTEXT) && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        } else if (!path.endsWith(DEFAULT_CONTEXT)) {
            int index = path.lastIndexOf(DEFAULT_CONTEXT);
            if (path.lastIndexOf("*") > index || path.lastIndexOf(".") > index) {
                if (index == 0) {
                    return DEFAULT_CONTEXT;
                }
                if (index > 0 && index < path.length()) {
                    path = path.substring(0, index);
                }
            }
        }
        return path;
    }

    private ConcurrentMap<ServletAdapter, List<String>> getServletAdapterList(WebApp webApp, String context) {
        ConcurrentHashMap<ServletAdapter, List<String>> servletAdapterMap = new ConcurrentHashMap<ServletAdapter, List<String>>();
        if (webApp == null || webApp.getServletMapping() == null || webApp.getServletMapping().isEmpty()) {
            ServletAdapter sa = new ServletAdapter();
            sa.setContextPath(context);
            sa.setServletPath("");
            ArrayList<String> aliasList = new ArrayList<String>();
            aliasList.add(DEFAULT_CONTEXT);
            servletAdapterMap.put(sa, aliasList);
        } else {
            for (ServletMapping servletMapping : webApp.getServletMapping()) {
                ServletAdapter sa = new ServletAdapter();
                List<String> urlPatternList = servletMapping.getUrlPattern();
                String urlPattern = null;
                urlPattern = urlPatternList == null || urlPatternList.size() == 0 ? DEFAULT_CONTEXT : urlPatternList.get(0);
                String servletUrlPattern = null;
                if (!urlPattern.startsWith(DEFAULT_CONTEXT)) {
                    urlPattern = DEFAULT_CONTEXT + urlPattern;
                }
                if ((servletUrlPattern = urlPattern).indexOf("//") > -1) {
                    servletUrlPattern = servletUrlPattern.replaceAll("//", DEFAULT_CONTEXT);
                }
                sa.setContextPath(context);
                sa.setServletPath(this.getServletPath(servletUrlPattern));
                this.setServlet(webApp, sa, servletMapping);
                ArrayList<String> aliasList = new ArrayList<String>();
                aliasList.add(urlPattern);
                servletAdapterMap.put(sa, aliasList);
            }
        }
        return servletAdapterMap;
    }

    private String getRootFolder(String location, String context) {
        if (location == null || context == null) {
            return location;
        }
        location = location.replaceAll("[/\\\\]+", "\\/");
        int index = (location = location.replaceAll("\\\\", "\\/")).lastIndexOf(context);
        if (index > -1) {
            location = location.substring(0, index);
        }
        return location;
    }

    protected void deployCustom(String location) throws Exception {
        this.webxmlPath = this.appendWarContentToClassPath(location);
        String context = this.getContext(this.webxmlPath);
        String root = this.getRootFolder(location, context);
        this.deploy(root, context, root + context);
    }

    public void deploy(String rootFolder, String context, String path) throws Exception {
        ServletAdapter sa2;
        List<WebApp> webAppList;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Will deploy application path=" + path);
        }
        if ((webAppList = this.getDefaultSupportWebApp()) == null) {
            webAppList = new ArrayList<WebApp>();
        }
        WebApp webApp = null;
        if (path != null && path.toLowerCase().endsWith(".xml")) {
            try {
                webApp = this.extractWebxmlInfo(path);
                webAppList.add(webApp);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Not a valid WebApp, will be ignored : path=" + path);
            }
        }
        boolean blankContextServletPathFound = false;
        boolean defaultContextServletPathFound = false;
        ArrayList<String> aliasesUsed = new ArrayList<String>();
        for (WebApp webApp2 : webAppList) {
            ConcurrentMap<ServletAdapter, List<String>> servletAdapterList = this.getServletAdapterList(webApp2, context);
            for (ServletAdapter sa : servletAdapterList.keySet()) {
                String[] alias;
                this.setFilters(webApp2, sa);
                this.setListeners(webApp2, sa);
                if (rootFolder != null) {
                    rootFolder = rootFolder.replaceAll("[/\\\\]+", "\\/");
                    rootFolder = rootFolder.replaceAll("\\\\", "\\/");
                    sa.setRootFolder(rootFolder);
                }
                if ((alias = this.getAlias(sa, (Collection)servletAdapterList.get(sa))) == null) {
                    alias = new String[]{DEFAULT_CONTEXT};
                }
                sa.setHandleStaticResources(false);
                for (String item : alias) {
                    if (!item.endsWith(DEFAULT_CONTEXT) && !item.endsWith("/*")) continue;
                    sa.setHandleStaticResources(true);
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "sa context=" + sa.getContextPath());
                    logger.log(Level.FINEST, "sa servletPath=" + sa.getServletPath());
                    StringBuffer sb = new StringBuffer();
                    sb.append("[");
                    for (String item : alias) {
                        sb.append(item).append(",");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append("]");
                    logger.log(Level.FINEST, "sa alias=" + sb.toString());
                    logger.log(Level.FINEST, "sa rootFolder=" + sa.getRootFolder());
                }
                this.deployedApplicationList.add(context);
                aliasesUsed.addAll(Arrays.asList(alias));
                this.ws.addGrizzlyAdapter(sa, alias);
                if (DEFAULT_CONTEXT.equals(sa.getServletPath())) {
                    defaultContextServletPathFound = true;
                }
                if (!"".equals(sa.getServletPath())) continue;
                blankContextServletPathFound = true;
            }
        }
        if (!defaultContextServletPathFound) {
            logger.log(Level.FINEST, "Adding a ServletAdapter to handle / path");
            sa2 = new ServletAdapter();
            sa2.setContextPath(context);
            sa2.setServletPath(DEFAULT_CONTEXT);
            sa2.setHandleStaticResources(true);
            sa2.setRootFolder(rootFolder);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "sa context=" + sa2.getContextPath());
                logger.log(Level.FINEST, "sa servletPath=" + sa2.getServletPath());
                logger.log(Level.FINEST, "sa alias=" + context + DEFAULT_CONTEXT);
                logger.log(Level.FINEST, "sa rootFolder=" + sa2.getRootFolder());
            }
            this.ws.addGrizzlyAdapter(sa2, new String[]{context + DEFAULT_CONTEXT});
        }
        if (!blankContextServletPathFound && !aliasesUsed.contains(context + DEFAULT_CONTEXT)) {
            logger.log(Level.FINEST, "Adding a ServletAdapter to handle root path");
            sa2 = new ServletAdapter();
            sa2.setContextPath(context);
            sa2.setServletPath("");
            sa2.setHandleStaticResources(true);
            sa2.setRootFolder(rootFolder);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "sa context=" + sa2.getContextPath());
                logger.log(Level.FINEST, "sa servletPath=" + sa2.getServletPath());
                logger.log(Level.FINEST, "sa alias=" + context + DEFAULT_CONTEXT);
                logger.log(Level.FINEST, "sa rootFolder=" + sa2.getRootFolder());
            }
            this.ws.addGrizzlyAdapter(sa2, new String[]{context + DEFAULT_CONTEXT});
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "deployed application path=" + path);
        }
    }

    public String[] getAlias(ServletAdapter sa, Collection<String> aliases) {
        if (sa == null || aliases == null) {
            return null;
        }
        ArrayList<String> aliasList = new ArrayList<String>();
        for (String urlPattern : aliases) {
            String aliasTmp;
            String mapping = "";
            if (!sa.getServletPath().equals(urlPattern) && urlPattern.indexOf(sa.getServletPath()) > -1) {
                mapping = urlPattern.substring(urlPattern.indexOf(sa.getServletPath()));
            }
            if ((aliasTmp = sa.getContextPath() + sa.getServletPath() + mapping).indexOf("//") > -1) {
                aliasTmp = aliasTmp.replaceAll("//", DEFAULT_CONTEXT);
            }
            aliasList.add(aliasTmp);
        }
        String[] array = new String[aliasList.size()];
        return aliasList.toArray(array);
    }

    public void setLocations(String filename) {
        this.locations = filename;
    }

    public String getLocations() {
        return this.locations;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public void setLibraryPath(String path) {
        this.libraryPath = path;
    }

    public String getAutoDeployFolder() {
        return this.autodeployFolder;
    }

    public void setAutoDeployFolder(String path) {
        this.autodeployFolder = path;
    }

    public boolean getCometEnabled() {
        return this.cometEnabled;
    }

    public void setCometEnabled(boolean enabled) {
        this.cometEnabled = enabled;
    }

    public boolean getAjpEnabled() {
        return this.ajpEnabled;
    }

    public void setAjpEnabled(boolean enabled) {
        this.ajpEnabled = enabled;
    }

    public boolean getForceWarDeployment() {
        return this.forceWarDeployment;
    }

    public void setForceWarDeployment(boolean forceWarDeployment) {
        this.forceWarDeployment = forceWarDeployment;
    }

    public List<String> getDeployedApplicationList() {
        return this.deployedApplicationList;
    }

    public void setDeployedApplicationList(List<String> deployedApplicationList) {
        this.deployedApplicationList = deployedApplicationList;
    }

    public void printHelpAndExit() {
        System.err.println();
        System.err.println("Usage: " + GrizzlyWebServerDeployer.class.getCanonicalName());
        System.err.println();
        System.err.println("  --application=[path]*       Application(s) path(s).");
        System.err.println("  --port=[port]               Runs Servlet on the specified port.");
        System.err.println("  --context=[context]         Force the context for a servlet.");
        System.err.println("  --dontstart=[true/false]    Won't start the server.");
        System.err.println("  --libraryPath=[path]        Add a libraries folder to the classpath.");
        System.err.println("  --autodeploy=[path]         AutoDeploy to each applications");
        System.err.println("  --cometEnabled              Starts the AsyncFilter for Comet");
        System.err.println("  --forceWar                  Force war's deployment over a expanded folder.");
        System.err.println("  --ajpEnabled                Enable mod_jk.");
        System.err.println("  --help                      Show this help message.");
        System.err.println("  --longhelp                  Show detailled help message.");
        System.err.println();
        System.err.println("  * are mandatory");
        System.exit(1);
    }

    public void printLongHelpAndExit() {
        System.err.println();
        System.err.println("Usage: " + GrizzlyWebServerDeployer.class.getCanonicalName());
        System.err.println();
        System.err.println("  -a, --application=[path]*   Application(s) path(s).");
        System.err.println();
        System.err.println("                              Application(s) deployed can be :");
        System.err.println("                              Servlet(s), war(s) and expanded war folder(s).");
        System.err.println("                              To deploy multiple applications");
        System.err.println("                              use File.pathSeparator");
        System.err.println();
        System.err.println("                              Example : -a /app.war:/servlet/web.xml:/warfolder/");
        System.err.println();
        System.err.println("  -p, --port=[port]           Runs Servlet on the specified port.");
        System.err.println("                              Default: 8080");
        System.err.println();
        System.err.println("  -c, --context=[context]     Force the context for a servlet.");
        System.err.println("                              Only valid for servlet deployed using");
        System.err.println("                              -a [path]/[filename].xml");
        System.err.println();
        System.err.println("  --dontstart=[true/false]    Won't start the server.");
        System.err.println("                              You will need to call the start method.");
        System.err.println("                              Useful for Unit testing.");
        System.err.println("                              Default : false");
        System.err.println();
        System.err.println("  --libraryPath=[path]        Add a libraries folder to the classpath.");
        System.err.println("                              You can append multiple folders using");
        System.err.println("                              File.pathSeparator");
        System.err.println();
        System.err.println("                              Example : --libraryPath=/libs:/common_libs");
        System.err.println();
        System.err.println("  --autodeploy=[path]         AutoDeploy to each applications.");
        System.err.println("                              You could add JSP support.");
        System.err.println("                              Just add a web.xml that contains Jasper");
        System.err.println();
        System.err.println("                              Example : --autodeploy=/autodeploy");
        System.err.println();
        System.err.println("  --cometEnabled=[true/false] Starts the AsyncFilter for Comet.");
        System.err.println("                              You need to active this for comet applications.");
        System.err.println("                              Default : false");
        System.err.println();
        System.err.println("  --forceWar=[true/false]     Force war's deployment over a expanded folder.");
        System.err.println("                              Will deploy the war instead of the folder.");
        System.err.println("                              Default : false");
        System.err.println();
        System.err.println("  --ajpEnabled=[true/false]   Enable mod_jk.");
        System.err.println("                              Default : false");
        System.err.println();
        System.err.println("  Default values will be applied if invalid values are passed.");
        System.err.println();
        System.err.println("  * are mandatory");
        System.exit(1);
    }

    public boolean parseOptions(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String value;
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                this.printHelpAndExit();
                continue;
            }
            if ("--longhelp".equals(arg)) {
                this.printLongHelpAndExit();
                continue;
            }
            if ("-a".equals(arg)) {
                if (++i >= args.length) continue;
                this.setLocations(args[i]);
                continue;
            }
            if (arg.startsWith("--application=")) {
                this.setLocations(arg.substring("--application=".length(), arg.length()));
                continue;
            }
            if ("-p".equals(arg)) {
                if (++i >= args.length) continue;
                this.setPort(Integer.parseInt(args[i]));
                continue;
            }
            if (arg.startsWith("--port=")) {
                String num = arg.substring("--port=".length(), arg.length());
                this.setPort(Integer.parseInt(num));
                continue;
            }
            if ("-c".equals(arg)) {
                if (++i >= args.length) continue;
                this.setForcedContext(args[i]);
                continue;
            }
            if (arg.startsWith("--context=")) {
                this.setForcedContext(arg.substring("--context=".length(), arg.length()));
                continue;
            }
            if (arg.startsWith("--dontstart=")) {
                this.setWaitToStart(Boolean.parseBoolean(arg.substring("--dontstart=".length(), arg.length())));
                continue;
            }
            if (arg.startsWith("--libraryPath=")) {
                value = arg.substring("--libraryPath=".length(), arg.length());
                this.setLibraryPath(value);
                continue;
            }
            if (arg.startsWith("--autodeploy=")) {
                value = arg.substring("--autodeploy=".length(), arg.length());
                this.setAutoDeployFolder(value);
                continue;
            }
            if (arg.startsWith("--cometEnabled=")) {
                this.setCometEnabled(Boolean.parseBoolean(arg.substring("--cometEnabled=".length(), arg.length())));
                continue;
            }
            if (arg.startsWith("--forceWar")) {
                this.setForceWarDeployment(Boolean.parseBoolean(arg.substring("--forceWar=".length(), arg.length())));
                continue;
            }
            if (!arg.startsWith("--ajpEnabled")) continue;
            this.setAjpEnabled(Boolean.parseBoolean(arg.substring("--ajpEnabled=".length(), arg.length())));
        }
        if (this.getLocations() == null) {
            System.err.println("Illegal War|Jar file or folder location.");
            this.printHelpAndExit();
        }
        return true;
    }

    protected void setServlet(WebApp webApp, ServletAdapter sa, ServletMapping servletMapping) {
        List<com.sun.grizzly.http.webxml.schema.Servlet> servletList = webApp.getServlet();
        for (com.sun.grizzly.http.webxml.schema.Servlet servletItem : servletList) {
            if (!servletItem.getServletName().equalsIgnoreCase(servletMapping.getServletName())) continue;
            Servlet servlet = (Servlet)ClassLoaderUtil.load(servletItem.getServletClass());
            sa.setServletInstance(servlet);
            List<InitParam> initParamsList = servletItem.getInitParam();
            if (initParamsList == null || initParamsList.size() <= 0) break;
            for (InitParam element : initParamsList) {
                sa.addInitParameter(element.getParamName(), element.getParamValue());
            }
        }
    }

    protected void setListeners(WebApp webApp, ServletAdapter sa) {
        if (webApp == null || sa == null) {
            return;
        }
        List<Listener> listeners = webApp.getListener();
        if (listeners != null) {
            for (Listener element : listeners) {
                sa.addServletListener(element.getListenerClass());
            }
        }
    }

    protected void setFilters(WebApp webApp, ServletAdapter sa) {
        if (webApp == null || sa == null) {
            return;
        }
        List<Filter> filterList = webApp.getFilter();
        List<FilterMapping> filterMappingList = webApp.getFilterMapping();
        if (filterList != null && filterList.size() > 0) {
            for (Filter filterItem : filterList) {
                for (FilterMapping filterMapping : filterMappingList) {
                    if (!filterItem.getFilterName().equalsIgnoreCase(filterMapping.getFilterName())) continue;
                    javax.servlet.Filter filter = (javax.servlet.Filter)ClassLoaderUtil.load(filterItem.getFilterClass());
                    List<InitParam> initParamList = filterItem.getInitParam();
                    HashMap<String, String> initParamsMap = new HashMap<String, String>();
                    if (initParamList != null) {
                        for (InitParam param : initParamList) {
                            initParamsMap.put(param.getParamName(), param.getParamValue());
                        }
                    }
                    sa.addFilter(filter, filterItem.getFilterName(), initParamsMap);
                }
            }
        }
    }

    protected Map<String, List<Object>> getItemMap(List<Object> itemList) throws Exception {
        HashMap<String, List<Object>> itemMap = null;
        if (itemList != null) {
            itemMap = new HashMap<String, List<Object>>();
            for (Object object : itemList) {
                List<Object> list = null;
                String key = object.getClass().getSimpleName();
                if (itemMap.containsKey(key)) {
                    list = (List)itemMap.get(key);
                } else {
                    list = new ArrayList();
                    itemMap.put(key, list);
                }
                list.add(object);
            }
        } else {
            throw new Exception("invalid");
        }
        return itemMap;
    }

    public String appendWarContentToClassPath(String appliPath) throws MalformedURLException, IOException {
        String[] array;
        String absolutePath;
        File libFiles;
        String path = null;
        File file = null;
        URL appRoot = null;
        URL classesURL = null;
        if (appliPath != null && appliPath.endsWith(File.pathSeparator)) {
            appliPath = appliPath + File.pathSeparator;
        }
        String separator = System.getProperty("os.name").toLowerCase().startsWith("win") ? DEFAULT_CONTEXT : "//";
        ArrayList<URL> classpathList = new ArrayList<URL>();
        if (appliPath != null && (appliPath.endsWith(".war") || appliPath.endsWith(".jar"))) {
            file = new File(appliPath);
            appRoot = new URL("jar:file:" + file.getCanonicalPath() + "!/");
            classesURL = new URL("jar:file:" + file.getCanonicalPath() + "!/WEB-INF/classes/");
            path = ExpandJar.expand(appRoot);
        } else if (appliPath != null) {
            path = appliPath;
            classesURL = new URL("file:///" + path + "WEB-INF/classes/");
            appRoot = new URL("file:///" + path);
        }
        if (appliPath != null && (libFiles = new File((absolutePath = new File(path).getAbsolutePath()) + File.separator + "WEB-INF" + File.separator + "lib")).exists() && libFiles.isDirectory()) {
            for (int i = 0; i < libFiles.listFiles().length; ++i) {
                classpathList.add(new URL("jar:file:" + separator + libFiles.listFiles()[i].toString().replace('\\', '/') + "!/"));
            }
        }
        if (this.libraryPath != null && (array = this.libraryPath.split(File.pathSeparator)) != null && array.length > 0) {
            for (int i = 0; i < array.length; ++i) {
                File libFolder = new File(array[i]);
                if (!libFolder.exists() || !libFolder.isDirectory()) continue;
                for (int k = 0; k < libFolder.listFiles().length; ++k) {
                    classpathList.add(new URL("jar:file:" + separator + libFolder.listFiles()[k].getCanonicalPath().toString().replace('\\', '/') + "!/"));
                }
            }
        }
        if (appliPath != null) {
            classpathList.add(appRoot);
            classpathList.add(classesURL);
        }
        if (logger.isLoggable(Level.FINEST)) {
            for (URL url : classpathList) {
                logger.log(Level.FINEST, "Classpath contains=" + url);
            }
        }
        URL[] urls = new URL[classpathList.size()];
        URLClassLoader urlClassloader = new URLClassLoader(classpathList.toArray(urls), Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(urlClassloader);
        if (path != null && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public WebApp extractWebxmlInfo(String webxml) throws Exception {
        if (webxml == null) {
            return null;
        }
        WebappLoader webappLoader = new WebappLoader();
        WebApp webApp = webappLoader.load(webxml);
        return webApp;
    }

    public void launch() {
        try {
            this.ws = new GrizzlyWebServer(this.port);
            if (this.locations != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Application(s) Found = " + this.locations);
                }
                this.deployApplications(this.locations);
            }
            if (this.cometEnabled) {
                SelectorThread st = this.ws.getSelectorThread();
                DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
                asyncHandler.addAsyncFilter(new CometAsyncFilter());
                st.setAsyncHandler(asyncHandler);
                st.setEnableAsyncExecution(true);
            }
            if (this.ajpEnabled) {
                this.ws.enableProtocol(GrizzlyWebServer.PROTOCOL.AJP);
            }
            if (!this.waitToStart) {
                this.ws.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.ws != null) {
            this.ws.stop();
        }
    }

    public void start() throws IOException {
        if (this.ws != null) {
            this.ws.start();
        }
    }

    public void setWaitToStart(boolean dontStart) {
        this.waitToStart = dontStart;
    }

    public String getForcedContext() {
        return this.forcedContext;
    }

    public void setForcedContext(String forcedContext) {
        this.forcedContext = forcedContext;
    }

    public List<WebApp> getDefaultSupportWebApp() throws Exception {
        File folder;
        if (this.autodeployFolder == null) {
            return null;
        }
        if (this.autodeployFolder.endsWith(DEFAULT_CONTEXT) && this.autodeployFolder.length() > 1) {
            this.autodeployFolder = this.autodeployFolder.substring(0, this.autodeployFolder.length() - 1);
        }
        if (!(folder = new File(this.autodeployFolder)).exists() || !folder.isDirectory()) {
            return null;
        }
        File[] files = folder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        ArrayList<WebApp> webappList = new ArrayList<WebApp>(files.length);
        for (File file : files) {
            WebApp webApp = this.extractWebxmlInfo(file.getPath());
            if (webApp == null) {
                throw new Exception("invalid");
            }
            webappList.add(webApp);
        }
        return webappList;
    }

    public static void main(String[] args) {
        GrizzlyWebServerDeployer ws = new GrizzlyWebServerDeployer();
        try {
            ws.init(args);
            ws.launch();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

