/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.webxml;

import com.sun.grizzly.http.webxml.parser.IJAXBWebXmlParser;
import com.sun.grizzly.http.webxml.parser.helper.WebXmlHelper;
import com.sun.grizzly.http.webxml.schema.WebApp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappLoader {
    protected static Logger logger = Logger.getLogger("webappLogger");
    public static final String WEB_APP_DEFAULT = "WEB_APP_DEFAULT";
    public static final String WEB_APP_2_2 = "web-app_2_2.dtd";
    public static final String WEB_APP_2_3 = "web-app_2_3.dtd";
    public static final String WEB_APP_2_4 = "web-app_2_4.xsd";
    public static final String WEB_APP_2_5 = "web-app_2_5.xsd";
    public static final String WEB_APP_3_0 = "web-app_3_0.xsd";
    private String defaultVersion = "WEB_APP_DEFAULT";
    private static final Map<String, String> webAppMap = new HashMap<String, String>();

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public static Collection<String> getAvailableVersion() {
        return webAppMap.values();
    }

    public void setDefaultVersion(String version) throws Exception {
        if (!webAppMap.containsKey(version)) {
            throw new Exception("Version not found");
        }
        this.defaultVersion = version;
    }

    public WebApp load(String webxml) throws Exception {
        WebXmlHelper helper = new WebXmlHelper();
        helper.getInfo(webxml);
        String schemaVersion = helper.getVersion();
        if (schemaVersion == null) {
            schemaVersion = WEB_APP_DEFAULT;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Version found=" + schemaVersion);
        }
        WebApp webapp = this.extractWebXmlInfo(schemaVersion, webxml);
        return webapp;
    }

    protected WebApp extractWebXmlInfo(String schemaVersion, String webxml) throws Exception {
        Class<?> clazz = Class.forName(webAppMap.get(schemaVersion));
        IJAXBWebXmlParser parser = (IJAXBWebXmlParser)clazz.newInstance();
        WebApp webapp = parser.parse(webxml);
        return webapp;
    }

    static {
        webAppMap.put(WEB_APP_DEFAULT, "com.sun.grizzly.http.webxml.parser.JAXBWebXml_2_3Parser");
        webAppMap.put(WEB_APP_2_2, "com.sun.grizzly.http.webxml.parser.JAXBWebXml_2_2Parser");
        webAppMap.put(WEB_APP_2_3, "com.sun.grizzly.http.webxml.parser.JAXBWebXml_2_3Parser");
        webAppMap.put(WEB_APP_2_4, "com.sun.grizzly.http.webxml.parser.JAXBWebXml_2_4Parser");
        webAppMap.put(WEB_APP_2_5, "com.sun.grizzly.http.webxml.parser.JAXBWebXml_2_5Parser");
        webAppMap.put(WEB_APP_3_0, "com.sun.grizzly.http.webxml.parser.JAXBWebXml_3_0Parser");
    }
}

