/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.webxml.parser.handler;

import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXWebXmlHandler
extends DefaultHandler {
    private boolean dtdFound = false;
    private boolean xsdFound = false;
    private String version = null;

    public void reset() {
        this.dtdFound = false;
        this.xsdFound = false;
        this.version = null;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        String value;
        if (this.dtdFound) {
            return;
        }
        if (qName.toUpperCase().equals("WEB-APP") && (value = atts.getValue("xsi:schemaLocation")) != null) {
            this.xsdFound = true;
            int index = value.lastIndexOf("/");
            if (index > 0) {
                this.version = value.substring(index + 1);
            }
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (systemId.toUpperCase().endsWith(".DTD")) {
            this.dtdFound = true;
            int index = systemId.lastIndexOf("/");
            if (index > 0) {
                this.version = systemId.substring(index + 1);
            }
        }
        return null;
    }

    public boolean getDtdFound() {
        return this.dtdFound;
    }

    public void setDtdFound(boolean dtdFound) {
        this.dtdFound = dtdFound;
    }

    public boolean getXsdFound() {
        return this.xsdFound;
    }

    public void setXsdFound(boolean xsdFound) {
        this.xsdFound = xsdFound;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

