/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.FixedThreadPool;
import com.sun.grizzly.util.LinkedTransferQueue;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThreadPool
extends FixedThreadPool
implements Thread.UncaughtExceptionHandler {
    public static int DEFAULT_MIN_THREAD_COUNT = 5;
    public static int DEFAULT_MAX_THREAD_COUNT = 5;
    public static int DEFAULT_MAX_TASKS_QUEUED = Integer.MAX_VALUE;
    public static int DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT = 30000;
    protected int initialByteBufferSize = 8192;
    protected ByteBufferFactory.ByteBufferType byteBufferType = WorkerThreadImpl.DEFAULT_BYTEBUFFER_TYPE;
    private final AtomicInteger queueSize = new AtomicInteger();
    protected int priority = 5;
    protected volatile int corePoolsize;
    protected final long idleTimeout;
    protected final TimeUnit timeUnit;
    protected final AtomicInteger workerThreadCounter = new AtomicInteger();

    public DefaultThreadPool() {
        this("Grizzly", DEFAULT_MIN_THREAD_COUNT, DEFAULT_MAX_THREAD_COUNT, DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public DefaultThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit) {
        this(name, corePoolsize, maxPoolSize, keepAliveTime, timeUnit, null);
    }

    public DefaultThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory) {
        this(name, corePoolsize, maxPoolSize, keepAliveTime, timeUnit, threadFactory, new LinkedTransferQueue<Runnable>());
    }

    public DefaultThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory, BlockingQueue<Runnable> workQueue) {
        super(workQueue, threadFactory);
        this.validateNewPoolsize(corePoolsize, maxPoolSize);
        if (keepAliveTime < 0L) {
            throw new IllegalArgumentException("keepAliveTime < 0");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("timeUnit == null");
        }
        this.corePoolsize = corePoolsize;
        this.maxPoolSize = maxPoolSize;
        this.idleTimeout = keepAliveTime;
        this.timeUnit = timeUnit;
        this.name = name;
        if (this.threadFactory == null) {
            this.threadFactory = new DefaultWorkerThreadFactory();
        }
    }

    private void validateNewPoolsize(int corePoolsize, int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolsize < 1");
        }
        if (corePoolsize < 1) {
            throw new IllegalArgumentException("corePoolsize < 1");
        }
        if (corePoolsize > maxPoolSize) {
            throw new IllegalArgumentException("corePoolsize > maxPoolSize");
        }
    }

    @Override
    public void execute(Runnable task) {
        int aliveWorkers;
        if (task == null) {
            throw new IllegalArgumentException("Runnable task is null");
        }
        while ((aliveWorkers = this.aliveworkerCount.get()) < this.maxPoolSize && (aliveWorkers < this.corePoolsize || this.queueSize.get() > 0 || !this.hasIdleWorkersApproximately()) && this.running) {
            if (!this.aliveworkerCount.compareAndSet(aliveWorkers, aliveWorkers + 1)) continue;
            this.startWorker(new Worker(task, false));
            return;
        }
        if (this.running) {
            if (this.workQueue.offer(task)) {
                this.queueSize.incrementAndGet();
            } else {
                throw new RejectedExecutionException("The queue is full");
            }
        }
    }

    private boolean hasIdleWorkersApproximately() {
        return this.aliveworkerCount.get() > this.approximateRunningWorkerCount.get();
    }

    public void start() {
        int aliveCount;
        while ((aliveCount = this.aliveworkerCount.get()) < this.corePoolsize) {
            if (!this.aliveworkerCount.compareAndSet(aliveCount, aliveCount + 1)) continue;
            this.startWorker(new Worker(null, true));
        }
    }

    public void stop() {
        this.shutdownNow();
    }

    @Override
    public int getQueueSize() {
        return this.queueSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCorePoolSize(int corePoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            this.validateNewPoolsize(this.corePoolsize, this.maxPoolSize);
            this.corePoolsize = corePoolSize;
        }
    }

    @Override
    public int getCorePoolSize() {
        return this.corePoolsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumPoolSize(int maxPoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            this.validateNewPoolsize(this.corePoolsize, maxPoolSize);
            this.maxPoolSize = maxPoolSize;
        }
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.idleTimeout, this.timeUnit);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        LoggerUtils.getLogger().log(Level.WARNING, "Uncaught thread exception. Thread: " + thread, throwable);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ByteBufferFactory.ByteBufferType getByteBufferType() {
        return this.byteBufferType;
    }

    public void setByteBufferType(ByteBufferFactory.ByteBufferType byteBufferType) {
        this.byteBufferType = byteBufferType;
    }

    public int getInitialByteBufferSize() {
        return this.initialByteBufferSize;
    }

    public void setInitialByteBufferSize(int initialByteBufferSize) {
        this.initialByteBufferSize = initialByteBufferSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(512);
        builder.append("DefaultThreadPool[");
        this.injectToStringAttributes(builder);
        builder.append(']');
        return builder.toString();
    }

    protected void injectToStringAttributes(StringBuilder sb) {
        sb.append("name=").append(this.name);
        sb.append(", min-threads=").append(this.getCorePoolSize());
        sb.append(", max-threads=").append(this.getMaximumPoolSize());
        sb.append(", max-queue-size=").append(this.getMaxQueuedTasksCount());
        sb.append(", is-shutdown=").append(this.isShutdown());
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        ((WorkerThreadImpl)t).createByteBuffer(false);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ((WorkerThreadImpl)Thread.currentThread()).reset();
    }

    private class DefaultWorkerThreadFactory
    implements ThreadFactory {
        private DefaultWorkerThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            WorkerThreadImpl thread = new WorkerThreadImpl(DefaultThreadPool.this, DefaultThreadPool.this.name + "-WorkerThread(" + DefaultThreadPool.this.workerThreadCounter.getAndIncrement() + ")", r, DefaultThreadPool.this.initialByteBufferSize);
            thread.setUncaughtExceptionHandler(DefaultThreadPool.this);
            thread.setPriority(DefaultThreadPool.this.priority);
            return thread;
        }
    }

    protected class Worker
    extends FixedThreadPool.BasicWorker {
        private final boolean core;
        private Runnable firstTask;

        public Worker(Runnable firstTask, boolean core) {
            super(DefaultThreadPool.this);
            this.core = core;
            this.firstTask = firstTask;
        }

        protected Runnable getTask() throws InterruptedException {
            Runnable r;
            if (this.firstTask != null) {
                r = this.firstTask;
                this.firstTask = null;
            } else {
                if (!this.core && DefaultThreadPool.this.aliveworkerCount.get() > DefaultThreadPool.this.maxPoolSize) {
                    return null;
                }
                Runnable runnable = r = this.core ? (Runnable)DefaultThreadPool.this.workQueue.take() : (Runnable)DefaultThreadPool.this.workQueue.poll(DefaultThreadPool.this.idleTimeout, DefaultThreadPool.this.timeUnit);
                if (r != null) {
                    DefaultThreadPool.this.queueSize.decrementAndGet();
                }
            }
            return r;
        }
    }
}

