/**
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER. *
 * Copyright 2007-2008 Sun Microsystems, Inc. All rights reserved. *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 */
package com.sun.grizzly.http.webxml.parser.handler;

import java.io.IOException;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXWebXmlHandler extends DefaultHandler {

	private boolean dtdFound = false;
	private boolean xsdFound = false;
	private String version = null;
	
	public void reset(){
		dtdFound = false;
		xsdFound = false;
		version = null;
	}
	
	public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {

		if(dtdFound){
			return;
		}
		
		if (qName.toUpperCase().equals("WEB-APP")) {
			
			String value = atts.getValue("xsi:schemaLocation");
			
			if(value!=null){
				xsdFound = true;
				int index = value.lastIndexOf("/");
				if(index>0){
					version = value.substring(index+1);
				}
			}
			
		}
	}

	@Override
	public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
		// DTD
		if(systemId.toUpperCase().endsWith(".DTD")){
			dtdFound = true;
			
			int index = systemId.lastIndexOf("/");
			if(index>0){
				version = systemId.substring(index+1);
			}
		}
		
		return null;
	}
	
	public boolean getDtdFound() {
		return dtdFound;
	}

	public void setDtdFound(boolean dtdFound) {
		this.dtdFound = dtdFound;
	}

	public boolean getXsdFound() {
		return xsdFound;
	}

	public void setXsdFound(boolean xsdFound) {
		this.xsdFound = xsdFound;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

}
