/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.AbstractConnectorHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultCallbackHandler;
import com.sun.grizzly.UDPSelectorHandler;
import com.sun.grizzly.util.InputReader;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPConnectorHandler
extends AbstractConnectorHandler<UDPSelectorHandler, CallbackHandler> {
    protected volatile CountDownLatch isConnectedLatch;
    private boolean isStandalone = false;

    public UDPConnectorHandler() {
        this.protocol(Controller.Protocol.UDP);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler, UDPSelectorHandler selectorHandler) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        if (selectorHandler == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        this.selectorHandler = selectorHandler;
        if (callbackHandler == null) {
            callbackHandler = new DefaultCallbackHandler(this);
        } else {
            this.callbackHandler = callbackHandler;
        }
        this.isConnectedLatch = new CountDownLatch(1);
        selectorHandler.connect(remoteAddress, localAddress, callbackHandler);
        try {
            this.isConnectedLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            this.isStandalone = true;
            this.controller = new Controller();
            this.controller.setSelectorHandler(new UDPSelectorHandler(true));
            final CountDownLatch latch = new CountDownLatch(1);
            this.controller.addStateListener(new ControllerStateListenerAdapter(){

                public void onReady() {
                    latch.countDown();
                }

                public void onException(Throwable e) {
                    latch.countDown();
                }
            });
            this.callbackHandler = new DefaultCallbackHandler(this, false);
            this.controller.executeUsingKernelExecutor();
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        this.connect(remoteAddress, localAddress, this.callbackHandler);
    }

    @Override
    public long read(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        if (blocking) {
            if (this.inputStream == null) {
                this.inputStream = new InputReader();
            }
            this.inputStream.setChannelType(InputReader.ChannelType.DatagramChannel);
        }
        return super.read(byteBuffer, blocking);
    }

    public long send(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking read needs a CallbackHandler");
        }
        return ((DatagramChannel)this.underlyingChannel).send(byteBuffer, socketAddress);
    }

    public SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking read needs a CallbackHandler");
        }
        SocketAddress socketAddress = ((DatagramChannel)this.underlyingChannel).receive(byteBuffer);
        return socketAddress;
    }

    @Override
    public void close() throws IOException {
        if (this.underlyingChannel != null) {
            if (this.selectorHandler != null) {
                SelectionKey key = ((UDPSelectorHandler)this.selectorHandler).keyFor(this.underlyingChannel);
                if (key == null) {
                    return;
                }
                ((UDPSelectorHandler)this.selectorHandler).getSelectionKeyHandler().cancel(key);
            } else {
                this.underlyingChannel.close();
            }
        }
        if (this.controller != null && this.isStandalone) {
            this.controller.stop();
            this.controller = null;
        }
        this.isStandalone = false;
        this.isConnected = false;
    }

    @Override
    public void finishConnect(SelectionKey key) throws IOException {
        if (Controller.logger().isLoggable(Level.FINE)) {
            Controller.logger().log(Level.FINE, "Finish connect");
        }
        DatagramChannel datagramChannel = (DatagramChannel)key.channel();
        this.underlyingChannel = datagramChannel;
        this.isConnected = datagramChannel.isConnected();
        if (this.isConnectedLatch != null) {
            this.isConnectedLatch.countDown();
        }
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.UDP;
    }
}

