/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.SSLUtils;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLReadFilter
implements ProtocolFilter {
    public static final String SSL_PREREAD_DATA = "SSLReadFilter.preread";
    protected SSLContext sslContext;
    private String[] enabledCipherSuites = null;
    private String[] enabledProtocols = null;
    private boolean clientMode = false;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    private boolean isProtocolConfigured = false;
    private boolean isCipherConfigured = false;
    private int sslActivityTimeout = 30000;
    protected int inputBBSize = 20480;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(Context ctx) throws IOException {
        WorkerThread workerThread;
        Logger logger = Controller.logger();
        boolean result = true;
        int count = 0;
        Object var5_5 = null;
        SelectionKey key = ctx.getSelectionKey();
        try {
            workerThread = (WorkerThread)Thread.currentThread();
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        SSLEngine sslEngine = workerThread.getSSLEngine();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Thread associated sslEngine: " + sslEngine);
        }
        if (sslEngine == null) {
            sslEngine = this.obtainSSLEngine(key);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Obtained sslEngine: " + sslEngine);
            }
            workerThread.setSSLEngine(sslEngine);
            ThreadAttachment attachment = workerThread.updateAttachment(16);
            key.attach(attachment);
        }
        boolean hasHandshake = sslEngine.getSession().isValid();
        try {
            block18: {
                try {
                    SSLUtils.allocateThreadBuffers(this.inputBBSize);
                    if (hasHandshake) {
                        count = SSLReadFilter.doRead(key);
                        if (count == 0 && ctx.removeAttribute(SSL_PREREAD_DATA) == null) {
                            result = false;
                        }
                        break block18;
                    }
                    if (SSLReadFilter.doHandshake(key, this.sslActivityTimeout)) {
                        hasHandshake = true;
                        ByteBuffer outputBB = workerThread.getOutputBB();
                        outputBB.limit(outputBB.position());
                    } else {
                        count = -1;
                    }
                }
                catch (IOException ex) {
                    IOException iOException = ex;
                    SSLReadFilter.log("SSLReadFilter.execute", ex);
                    Object var12_18 = null;
                    if (iOException == null) {
                        if (count != -1) return result;
                    }
                    ctx.setAttribute("throwable", iOException);
                    ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                    return false;
                }
                catch (Throwable ex) {
                    Throwable throwable = ex;
                    SSLReadFilter.log("SSLReadFilter.execute", ex);
                    Object var12_19 = null;
                    if (throwable == null) {
                        if (count != -1) return result;
                    }
                    ctx.setAttribute("throwable", throwable);
                    ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                    return false;
                }
            }
            Object var12_17 = null;
            if (var5_5 == null) {
                if (count != -1) return result;
            }
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            if (var5_5 == null) {
                if (count != -1) throw throwable;
            }
            ctx.setAttribute("throwable", var5_5);
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
            result = false;
            throw throwable;
        }
        ctx.setAttribute("throwable", var5_5);
        ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
        return false;
    }

    public boolean postExecute(Context ctx) throws IOException {
        if (ctx.getKeyRegistrationState() == Context.KeyRegistrationState.CANCEL) {
            ctx.getSelectorHandler().getSelectionKeyHandler().cancel(ctx.getSelectionKey());
        } else if (ctx.getKeyRegistrationState() == Context.KeyRegistrationState.REGISTER) {
            this.saveSecuredBufferRemainders(ctx.getSelectionKey());
            ctx.getSelectorHandler().register(ctx.getSelectionKey(), 1);
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
        }
        return true;
    }

    private static boolean doHandshake(SelectionKey key, int timeout) throws IOException {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        ByteBuffer outputBB = workerThread.getOutputBB();
        ByteBuffer inputBB = workerThread.getInputBB();
        SSLEngine sslEngine = workerThread.getSSLEngine();
        SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        boolean OK = true;
        try {
            byteBuffer = SSLUtils.doHandshake((SocketChannel)key.channel(), byteBuffer, inputBB, outputBB, sslEngine, handshakeStatus, timeout);
            if (SSLReadFilter.doRead(key) == -1) {
                throw new EOFException();
            }
        }
        catch (IOException ex) {
            SSLReadFilter.log("doHandshake", ex);
            OK = false;
        }
        return OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int doRead(SelectionKey key) {
        int n;
        int count;
        SSLEngine sslEngine;
        block23: {
            block17: {
                int n2;
                block22: {
                    int byteBufferPosition;
                    block20: {
                        int n3;
                        block21: {
                            block18: {
                                int n4;
                                block19: {
                                    WorkerThread workerThread = (WorkerThread)Thread.currentThread();
                                    ByteBuffer byteBuffer = workerThread.getByteBuffer();
                                    ByteBuffer outputBB = workerThread.getOutputBB();
                                    ByteBuffer inputBB = workerThread.getInputBB();
                                    sslEngine = workerThread.getSSLEngine();
                                    count = -1;
                                    int initialBufferPosition = byteBuffer.position();
                                    try {
                                        count = ((SocketChannel)key.channel()).read(inputBB);
                                    }
                                    catch (IOException e) {
                                        SSLReadFilter.log("Exception during SSL read.", e);
                                        count = -1;
                                    }
                                    if (count <= -1 && inputBB.position() <= 0) break block17;
                                    Logger logger = Controller.logger();
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.log(Level.FINE, "SSLReadFilter. Read: " + count + " Calling unwrapAll. InputBB: " + inputBB + " byteBuffer: " + byteBuffer);
                                    }
                                    int initialInputBBPosition = inputBB.position();
                                    byteBuffer = SSLUtils.unwrapAll(byteBuffer, inputBB, sslEngine);
                                    workerThread.setInputBB(inputBB);
                                    workerThread.setOutputBB(outputBB);
                                    workerThread.setByteBuffer(byteBuffer);
                                    byteBufferPosition = byteBuffer.position();
                                    if (count > 0 || byteBufferPosition == initialBufferPosition) break block18;
                                    n4 = initialInputBBPosition;
                                    Object var13_18 = null;
                                    if (count != -1) break block19;
                                    try {
                                        sslEngine.closeInbound();
                                    }
                                    catch (SSLException ex2) {
                                        // empty catch block
                                    }
                                }
                                return n4;
                            }
                            if (count <= 0 || byteBufferPosition != 0) break block20;
                            n3 = 0;
                            Object var13_19 = null;
                            if (count != -1) break block21;
                            try {
                                sslEngine.closeInbound();
                            }
                            catch (SSLException ex2) {
                                // empty catch block
                            }
                        }
                        return n3;
                    }
                    if (byteBufferPosition != 0 || !sslEngine.isInboundDone()) break block17;
                    n2 = -1;
                    Object var13_20 = null;
                    if (count != -1) break block22;
                    try {
                        sslEngine.closeInbound();
                    }
                    catch (SSLException ex2) {
                        // empty catch block
                    }
                }
                return n2;
            }
            n = count;
            Object var13_21 = null;
            if (count != -1) break block23;
            try {
                sslEngine.closeInbound();
            }
            catch (SSLException ex2) {
                // empty catch block
            }
        }
        return n;
        catch (IOException ex) {
            int n5;
            block24: {
                try {
                    SSLReadFilter.log("Exception during SSL read.", ex);
                    n5 = -1;
                    Object var13_22 = null;
                    if (count != -1) break block24;
                }
                catch (Throwable throwable) {
                    block25: {
                        Object var13_23 = null;
                        if (count != -1) break block25;
                        try {
                            sslEngine.closeInbound();
                        }
                        catch (SSLException ex2) {}
                    }
                    throw throwable;
                }
                try {
                    sslEngine.closeInbound();
                }
                catch (SSLException ex2) {
                    // empty catch block
                }
            }
            return n5;
        }
    }

    public static Object[] doPeerCertificateChain(SelectionKey key, boolean needClientAuth) throws IOException {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        ByteBuffer inputBB = workerThread.getInputBB();
        ByteBuffer outputBB = workerThread.getOutputBB();
        SSLEngine sslEngine = workerThread.getSSLEngine();
        return SSLUtils.doPeerCertificateChain((SocketChannel)key.channel(), byteBuffer, inputBB, outputBB, sslEngine, needClientAuth, InputReader.getDefaultReadTimeout());
    }

    protected SSLEngine newSSLEngine() {
        Logger logger = Controller.logger();
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "newSSLEngine: " + sslEngine);
        }
        if (this.enabledCipherSuites != null) {
            if (!this.isCipherConfigured) {
                this.enabledCipherSuites = SSLReadFilter.configureEnabledCiphers(sslEngine, this.enabledCipherSuites);
                this.isCipherConfigured = true;
            }
            sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            if (!this.isProtocolConfigured) {
                this.enabledProtocols = SSLReadFilter.configureEnabledProtocols(sslEngine, this.enabledProtocols);
                this.isProtocolConfigured = true;
            }
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        sslEngine.setUseClientMode(this.clientMode);
        return sslEngine;
    }

    protected SSLEngine obtainSSLEngine(SelectionKey key) {
        Logger logger = Controller.logger();
        SSLEngine sslEngine = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Obtaining sslEngine. Key attachment: " + key.attachment());
        }
        if (key.attachment() instanceof ThreadAttachment) {
            sslEngine = ((WorkerThread)Thread.currentThread()).getSSLEngine();
        }
        if (sslEngine == null) {
            sslEngine = this.newSSLEngine();
        }
        if (this.wantClientAuth) {
            sslEngine.setWantClientAuth(this.wantClientAuth);
        }
        if (this.needClientAuth) {
            sslEngine.setNeedClientAuth(this.needClientAuth);
        }
        return sslEngine;
    }

    public void configure(SSLConfig sslConfig) {
        this.sslContext = sslConfig.createSSLContext();
        this.wantClientAuth = sslConfig.isWantClientAuth();
        this.needClientAuth = sslConfig.isNeedClientAuth();
        this.clientMode = sslConfig.isClientMode();
        this.sslActivityTimeout = sslConfig.getSslInactivityTimeout();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public int getSslActivityTimeout() {
        return this.sslActivityTimeout;
    }

    public void setSslActivityTimeout(int sslActivityTimeout) {
        this.sslActivityTimeout = sslActivityTimeout;
    }

    private static final String[] configureEnabledProtocols(SSLEngine sslEngine, String[] requestedProtocols) {
        String[] supportedProtocols = sslEngine.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        block0: for (String supportedProtocol : supportedProtocols) {
            for (String protocol : requestedProtocols) {
                if (!supportedProtocol.equals(protocol = protocol.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(protocol);
                continue block0;
            }
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static final String[] configureEnabledCiphers(SSLEngine sslEngine, String[] requestedCiphers) {
        String[] supportedCiphers = sslEngine.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        block0: for (String supportedCipher : supportedCiphers) {
            for (String cipher : requestedCiphers) {
                if (!supportedCipher.equals(cipher = cipher.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(cipher);
                continue block0;
            }
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }

    private void saveSecuredBufferRemainders(SelectionKey selectionKey) {
        ByteBuffer inputBB;
        Logger logger = Controller.logger();
        ThreadAttachment attachment = (ThreadAttachment)selectionKey.attachment();
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        if (attachment == null || workerThread.getAttachment() != attachment) {
            logger.log(Level.FINE, "SelectionKey ThreadAttachment is NULL or doesn't correspond to the current thread, when saving buffers");
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "saveSecuredBufferRemainders inputBB: " + workerThread.getInputBB() + " outputBB: " + workerThread.getOutputBB() + " attach: " + attachment);
        }
        if ((inputBB = workerThread.getInputBB()) != null && inputBB.position() > 0) {
            workerThread.updateAttachment(attachment.getMode() | 4);
        } else {
            workerThread.updateAttachment(attachment.getMode() & 0x7FFFFFFB);
        }
        ByteBuffer outputBB = workerThread.getOutputBB();
        if (outputBB != null && outputBB.hasRemaining()) {
            workerThread.updateAttachment(attachment.getMode() | 8);
        } else {
            workerThread.updateAttachment(attachment.getMode() & 0x7FFFFFF7);
        }
    }

    protected static void log(String msg, Throwable t) {
        if (Controller.logger().isLoggable(Level.FINE)) {
            Controller.logger().log(Level.FINE, msg, t);
        }
    }
}

