/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet.deployer.annotation;

import com.sun.grizzly.http.webxml.schema.EnvEntry;
import com.sun.grizzly.http.webxml.schema.LifecycleCallback;
import com.sun.grizzly.http.webxml.schema.MessageDestinationRef;
import com.sun.grizzly.http.webxml.schema.ResourceRef;
import com.sun.grizzly.http.webxml.schema.SecurityRole;
import com.sun.grizzly.http.webxml.schema.ServiceRef;
import com.sun.grizzly.http.webxml.schema.WebApp;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationParser {
    private static Logger logger = Logger.getLogger(AnnotationParser.class.getName());

    protected void parseDeclareRoles(WebApp webapp, Class<?> clazz) throws Exception {
        if (webapp == null || clazz == null) {
            return;
        }
        DeclareRoles an = clazz.getAnnotation(DeclareRoles.class);
        if (an != null) {
            logger.fine("Annotation found : " + an.toString());
            for (String value : an.value()) {
                if (value == null) continue;
                SecurityRole role = new SecurityRole();
                role.setRoleName(value);
                webapp.getSecurityRole().add(role);
            }
        }
    }

    protected void parseEJB(WebApp webapp, Class<?> clazz) throws Exception {
        if (webapp == null || clazz == null) {
            return;
        }
        logger.finest("Not Implemented");
    }

    protected void parseEJBs(WebApp webapp, Class<?> clazz) throws Exception {
        if (webapp == null || clazz == null) {
            return;
        }
        logger.finest("Not Implemented");
    }

    protected void parseResource(WebApp webapp, Class<?> clazz) throws Exception {
        Resource resource;
        if (webapp == null || clazz == null) {
            return;
        }
        Resource an = clazz.getAnnotation(Resource.class);
        if (an != null) {
            logger.fine("Annotation found in Class Level: " + an.toString());
            AnnotationParser.populateResource(webapp, an);
        }
        for (Field field : clazz.getFields()) {
            resource = field.getAnnotation(Resource.class);
            if (resource == null) continue;
            logger.fine("Annotation found in Field Level: " + field.toString() + "  Resource found : " + resource.toString());
            AnnotationParser.populateResource(webapp, resource);
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            resource = ((Method)accessibleObject).getAnnotation(Resource.class);
            if (resource == null) continue;
            logger.fine("Annotation found in Method Level: " + ((Method)accessibleObject).toString() + "  Resource found : " + resource.toString());
            AnnotationParser.populateResource(webapp, resource);
        }
    }

    protected void parsePersistenceContext(WebApp webapp, Class<?> clazz) throws Exception {
        if (webapp == null || clazz == null) {
            return;
        }
        logger.finest("Not Implemented");
    }

    protected void parsePersistenceUnit(WebApp webapp, Class<?> clazz) throws Exception {
        if (webapp == null || clazz == null) {
            return;
        }
        logger.finest("Not Implemented");
    }

    protected void parsePersistenceUnits(WebApp webapp, Class<?> clazz) throws Exception {
        if (webapp == null || clazz == null) {
            return;
        }
        logger.finest("Not Implemented");
    }

    protected void parsePostConstruct(WebApp webapp, Class<?> clazz) throws Exception {
        if (webapp == null || clazz == null) {
            return;
        }
        for (Method method : clazz.getMethods()) {
            PostConstruct an = method.getAnnotation(PostConstruct.class);
            if (an == null) continue;
            logger.fine("Annotation found in Method Level: " + method.toString() + "  Resource found : " + an.toString());
            LifecycleCallback callback = new LifecycleCallback();
            callback.setLifecycleCallbackClass(clazz.getName());
            callback.setLifecycleCallbackMethod(method.getName());
            webapp.getPostConstruct().add(callback);
        }
    }

    protected void parsePreDestroy(WebApp webapp, Class<?> clazz) throws Exception {
        if (webapp == null || clazz == null) {
            return;
        }
        for (Method method : clazz.getMethods()) {
            PreDestroy an = method.getAnnotation(PreDestroy.class);
            if (an == null) continue;
            logger.fine("Annotation found in Method Level: " + method.toString() + "  Resource found : " + an.toString());
            LifecycleCallback callback = new LifecycleCallback();
            callback.setLifecycleCallbackClass(clazz.getName());
            callback.setLifecycleCallbackMethod(method.getName());
            webapp.getPreDestroy().add(callback);
        }
    }

    private static void populateResource(WebApp webapp, Resource resource) throws Exception {
        if (webapp == null || resource == null) {
            return;
        }
        if (resource.type().getCanonicalName().endsWith("Service")) {
            logger.finest("Populate Resource as : ServiceRef");
            ServiceRef serviceRef = new ServiceRef();
            serviceRef.setServiceRefName(resource.name());
            serviceRef.setServiceRefType(resource.type().getName());
            serviceRef.setMappedName(resource.mappedName());
            ArrayList<String> description = new ArrayList<String>();
            description.add(resource.description());
            serviceRef.setDescription(description);
            webapp.getServiceRef().add(serviceRef);
        } else if (resource.type().getCanonicalName().equals("javax.sql.DataSource") || resource.type().getCanonicalName().endsWith("ConnectionFactory") || resource.type().getCanonicalName().equals("javax.mail.Session") || resource.type().getCanonicalName().equals("java.net.URL")) {
            logger.finest("Populate Resource as : ResourceRef");
            ResourceRef resourceRef = new ResourceRef();
            ArrayList<String> description = new ArrayList<String>();
            description.add(resource.description());
            resourceRef.setDescription(description);
            resourceRef.setMappedName(resource.mappedName());
            if (resource.authenticationType() == Resource.AuthenticationType.CONTAINER) {
                resourceRef.setResAuth("Container");
            } else if (resource.authenticationType() == Resource.AuthenticationType.APPLICATION) {
                resourceRef.setResAuth("Application");
            }
            resourceRef.setResRefName(resource.name());
            resourceRef.setResSharingScope(resource.shareable() ? "Shareable" : "Unshareable");
            resourceRef.setResType(resource.type().getName());
            webapp.getResourceRef().add(resourceRef);
        } else if (resource.type().getCanonicalName().equals("javax.jms.Queue") || resource.type().getCanonicalName().equals("javax.jms.Topic")) {
            logger.finest("Populate Resource as : MessageDestinationRef");
            MessageDestinationRef messageRef = new MessageDestinationRef();
            ArrayList<String> description = new ArrayList<String>();
            description.add(resource.description());
            messageRef.setDescription(description);
            messageRef.setMappedName(resource.mappedName());
            messageRef.setMessageDestinationRefName(resource.name());
            messageRef.setMessageDestinationType(resource.type().getName());
            messageRef.setMessageDestinationUsage(resource.mappedName());
            webapp.getMessageDestinationRef().add(messageRef);
        } else if (resource.type().getCanonicalName().equals("java.lang.String") || resource.type().getCanonicalName().equals("java.lang.Character") || resource.type().getCanonicalName().equals("java.lang.Integer") || resource.type().getCanonicalName().equals("java.lang.Boolean") || resource.type().getCanonicalName().equals("java.lang.Double") || resource.type().getCanonicalName().equals("java.lang.Byte") || resource.type().getCanonicalName().equals("java.lang.Short") || resource.type().getCanonicalName().equals("java.lang.Long") || resource.type().getCanonicalName().equals("java.lang.Float")) {
            logger.finest("Populate Resource as : EnvEntry");
            EnvEntry entry = new EnvEntry();
            entry.setEnvEntryName(resource.name());
            entry.setEnvEntryValue(resource.mappedName());
            entry.setEnvEntryType(resource.type().getName());
            entry.setMappedName(resource.mappedName());
            ArrayList<String> description = new ArrayList<String>();
            description.add(resource.description());
            entry.setDescription(description);
            webapp.getEnvEntry().add(entry);
        }
    }

    protected void parseResources(WebApp webapp, Class<?> clazz) throws Exception {
        Resources resources;
        if (webapp == null || clazz == null) {
            return;
        }
        Resources an = clazz.getAnnotation(Resources.class);
        if (an != null && an.value() != null) {
            logger.fine("Annotation found : " + an.toString());
            for (AccessibleObject accessibleObject : an.value()) {
                AnnotationParser.populateResource(webapp, (Resource)accessibleObject);
            }
        }
        for (Method method : clazz.getMethods()) {
            resources = method.getAnnotation(Resources.class);
            if (resources == null || resources.value() == null) continue;
            for (Resource resource : an.value()) {
                logger.fine("Annotation found in Method Level: " + method.toString() + "  Resource found : " + an.toString());
                AnnotationParser.populateResource(webapp, resource);
            }
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            resources = ((Field)accessibleObject).getAnnotation(Resources.class);
            if (resources == null || resources.value() == null) continue;
            for (Resource resource : an.value()) {
                logger.fine("Annotation found in Field Level: " + ((Field)accessibleObject).toString() + "  Resource found : " + an.toString());
                AnnotationParser.populateResource(webapp, resource);
            }
        }
    }

    protected void parseRunAs(WebApp webapp, Class<?> clazz) throws Exception {
        RunAs an;
        if (webapp == null || clazz == null) {
            return;
        }
        if (Servlet.class.isAssignableFrom(clazz) && (an = clazz.getAnnotation(RunAs.class)) != null) {
            logger.fine("Annotation found : " + an.toString());
            com.sun.grizzly.http.webxml.schema.RunAs runAs = new com.sun.grizzly.http.webxml.schema.RunAs();
            runAs.setRoleName(an.value());
            com.sun.grizzly.http.webxml.schema.Servlet servlet = new com.sun.grizzly.http.webxml.schema.Servlet();
            servlet.setServletClass(clazz.getName());
            servlet.setRunAs(runAs);
            webapp.getServlet().add(servlet);
        }
    }

    protected void parseWebServiceRef(WebApp webapp, Class<?> clazz) throws Exception {
        if (webapp == null || clazz == null) {
            return;
        }
        logger.finest("Not Implemented");
    }

    protected void parseWebServiceRefs(WebApp webapp, Class<?> clazz) throws Exception {
        if (webapp == null || clazz == null) {
            return;
        }
        logger.finest("Not Implemented");
    }

    public boolean isValid(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        if (clazz == null) {
            return false;
        }
        return Servlet.class.isAssignableFrom(clazz) || Filter.class.isAssignableFrom(clazz) || ServletContextListener.class.isAssignableFrom(clazz) || ServletContextAttributeListener.class.isAssignableFrom(clazz) || ServletRequestListener.class.isAssignableFrom(clazz) || ServletRequestAttributeListener.class.isAssignableFrom(clazz) || HttpSessionListener.class.isAssignableFrom(clazz) || HttpSessionAttributeListener.class.isAssignableFrom(clazz);
    }

    protected void parseAnnotation(Class<?> clazz, WebApp webapp) throws Exception {
        if (!this.isValid(clazz)) {
            return;
        }
        logger.finest("Searching for Annotations for this class : " + clazz.getName());
        this.parseDeclareRoles(webapp, clazz);
        this.parseResource(webapp, clazz);
        this.parseResources(webapp, clazz);
        this.parsePostConstruct(webapp, clazz);
        this.parsePreDestroy(webapp, clazz);
        this.parseRunAs(webapp, clazz);
        this.parseWebServiceRef(webapp, clazz);
        this.parseWebServiceRefs(webapp, clazz);
        this.parsePersistenceContext(webapp, clazz);
        this.parsePersistenceUnit(webapp, clazz);
        this.parsePersistenceUnits(webapp, clazz);
        this.parseEJB(webapp, clazz);
        this.parseEJBs(webapp, clazz);
    }

    public List<String> listFilesAndFolders(String folder, int tabCounter) {
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(folder);
        if (!file.exists() || !file.isDirectory()) {
            logger.info("Parameter is not a directory : " + folder);
            return list;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".class");
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                list.addAll(this.listFilesAndFolders(fileArray[i].getAbsolutePath(), tabCounter + 1));
                continue;
            }
            String toSkip = "WEB-INF" + File.separator + "classes" + File.separator;
            String path = fileArray[i].getPath();
            path = path.substring(path.indexOf(toSkip) + toSkip.length());
            String classname = path.replace('\\', '/').replace('/', '.');
            list.add(classname);
        }
        return list;
    }

    public WebApp parseAnnotation(URLClassLoader classLoader) throws Exception {
        if (classLoader == null) {
            return null;
        }
        WebApp webapp = new WebApp();
        URL[] urls = classLoader.getURLs();
        ArrayList<String> list = new ArrayList<String>();
        for (URL url : urls) {
            if ("file".equals(url.getProtocol())) {
                if (!url.getPath().endsWith("WEB-INF/lib/") && !url.getPath().endsWith("WEB-INF/classes/")) continue;
                File file = null;
                try {
                    file = new File(url.toURI());
                }
                catch (Exception e) {
                    URI uri = new URI(url.toString());
                    file = uri.getAuthority() == null ? new File(uri) : new File("//" + uri.getAuthority() + url.getFile());
                }
                if (file == null || !file.isDirectory()) continue;
                list.addAll(this.listFilesAndFolders(file.getCanonicalPath(), 0));
                continue;
            }
            if (!"jar".equals(url.getProtocol())) continue;
            String spec = url.getFile();
            int separator = spec.indexOf("!/");
            if (separator == -1) {
                throw new MalformedURLException("no !/ found in url spec:" + spec);
            }
            String filename = spec.substring("file:/".length(), separator);
            JarFile jar = new JarFile(filename, false);
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                JarEntry jarEntry = en.nextElement();
                String classname = jarEntry.getName();
                if (!classname.endsWith(".class")) continue;
                classname = classname.replace('\\', '/').replace('/', '.').replace('$', '.');
                list.add(classname);
            }
            jar.close();
        }
        logger.finest("Number of classes to check for Annotation : " + list.size());
        for (String classname : list) {
            try {
                this.parseAnnotation(classLoader.loadClass(classname.substring(0, classname.indexOf(".class"))), webapp);
            }
            catch (Throwable t) {}
        }
        return webapp;
    }
}

