/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.util.http.Parameters;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocketApplication;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HandShake {
    private static final Logger logger = Logger.getLogger("websocket");
    private boolean secure;
    private String origin;
    private String serverHostName;
    private int port = 80;
    private String resourcePath;
    private String location;
    private final Map<String, String[]> queryParams = new TreeMap<String, String[]>();
    private List<String> subProtocol = new ArrayList<String>();
    private List<String> extensions = new ArrayList<String>();

    public HandShake() {
    }

    public HandShake(URL url) {
        this.resourcePath = url.getPath();
        if ("".equals(this.resourcePath)) {
            this.resourcePath = "/";
        }
        if (url.getQuery() != null) {
            this.resourcePath = this.resourcePath + "?" + url.getQuery();
        }
        this.origin = url.getHost();
        this.serverHostName = url.getHost();
        this.secure = "wss".equals(url.getProtocol());
        this.port = url.getPort();
        this.buildLocation();
    }

    public HandShake(Request request) {
        this.setSecure(request.scheme().equals("https"));
        MimeHeaders mimeHeaders = request.getMimeHeaders();
        this.checkForHeader(mimeHeaders, "Upgrade", "WebSocket");
        this.checkForHeader(mimeHeaders, "Connection", "Upgrade");
        this.origin = this.readHeader(mimeHeaders, "Sec-WebSocket-Origin");
        if (this.origin == null) {
            this.origin = this.readHeader(mimeHeaders, "Origin");
        }
        this.determineHostAndPort(mimeHeaders);
        this.subProtocol = this.split(mimeHeaders.getHeader("Sec-WebSocket-Protocol"));
        if (this.serverHostName == null) {
            throw new HandshakeException("Missing required headers for WebSocket negotiation");
        }
        this.resourcePath = request.requestURI().toString();
        MessageBytes messageBytes = request.queryString();
        if (messageBytes != null) {
            String queryString = messageBytes.toString().trim();
            if (!"".equals(queryString)) {
                this.resourcePath = this.resourcePath + "?" + request.queryString();
            }
            Parameters queryParameters = new Parameters();
            queryParameters.processParameters(messageBytes);
            Enumeration<String> names = queryParameters.getParameterNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                this.queryParams.put(name, queryParameters.getParameterValues(name));
            }
        }
        this.buildLocation();
    }

    protected final void buildLocation() {
        StringBuilder builder = new StringBuilder((this.isSecure() ? "wss" : "ws") + "://" + this.serverHostName);
        if (this.port != 80) {
            builder.append(":" + this.port);
        }
        if (this.resourcePath == null || !this.resourcePath.startsWith("/") && !"".equals(this.resourcePath)) {
            builder.append("/");
        }
        builder.append(this.resourcePath);
        this.location = builder.toString();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public final void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getServerHostName() {
        return this.serverHostName;
    }

    public void setServerHostName(String serverHostName) {
        this.serverHostName = serverHostName;
    }

    public List<String> getSubProtocol() {
        return this.subProtocol;
    }

    public void setSubProtocol(List<String> subProtocol) {
        this.subProtocol = subProtocol;
    }

    private void sanitize(List<String> strings) {
        if (strings != null) {
            for (int i = 0; i < strings.size(); ++i) {
                strings.set(i, strings.get(i) == null ? null : strings.get(i).trim());
            }
        }
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<String> extensions) {
        this.sanitize(extensions);
        this.extensions = extensions;
    }

    protected String join(List<String> values) {
        StringBuilder builder = new StringBuilder();
        for (String s : values) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(s);
        }
        return builder.toString();
    }

    protected void checkForHeader(Map<String, String> headers, String header, String validValue) {
        this.validate(header, validValue, headers.get(header));
    }

    protected final void checkForHeader(MimeHeaders headers, String header, String validValue) {
        this.validate(header, validValue, headers.getHeader(header));
    }

    private void validate(String header, String validValue, String value) {
        boolean found = false;
        if (value.contains(",")) {
            for (String part : value.split(",")) {
                found |= part.trim().equalsIgnoreCase(validValue);
            }
        } else {
            found = value.equalsIgnoreCase(validValue);
        }
        if (!found) {
            throw new HandshakeException(String.format("Invalid %s header returned: '%s'", header, value));
        }
    }

    public final String readHeader(MimeHeaders headers, String name) {
        MessageBytes value = headers.getValue(name);
        return value == null ? null : value.toString();
    }

    private void determineHostAndPort(MimeHeaders headers) {
        int i;
        String header = this.readHeader(headers, "host");
        int n = i = header == null ? -1 : header.indexOf(":");
        if (i == -1) {
            this.setServerHostName(header);
            this.setPort(80);
        } else {
            this.setServerHostName(header.substring(0, i));
            this.setPort(Integer.valueOf(header.substring(i + 1)));
        }
    }

    public void initiate(NetworkHandler handler) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("GET %s HTTP/1.1\r\n", this.getResourcePath()));
        builder.append(String.format("Host: %s\r\n", this.getServerHostName()));
        builder.append(String.format("Connection: Upgrade\r\n", new Object[0]));
        builder.append(String.format("Upgrade: WebSocket\r\n", new Object[0]));
        if (!this.getSubProtocol().isEmpty()) {
            builder.append(String.format("%s: %s\r\n", "Sec-WebSocket-Protocol", this.join(this.getSubProtocol())));
        }
        handler.write(builder.toString().getBytes());
    }

    public void validateServerResponse(Map<String, String> map) {
        if (map.isEmpty()) {
            throw new HandshakeException("No response headers received");
        }
        if (!"101".equals(map.get("Response Code"))) {
            throw new HandshakeException(String.format("Response code was not %s: %s", "101", map.get("Response Code")));
        }
        this.checkForHeader(map, "upgrade", "websocket");
        this.checkForHeader(map, "connection", "upgrade");
        if (this.getSubProtocol().isEmpty() || map.get("Sec-WebSocket-Protocol") == null) {
            // empty if block
        }
    }

    public void respond(WebSocketApplication application, Response response) {
        response.setStatus(101);
        response.setMessage("Web Socket Protocol Handshake");
        response.setHeader("Upgrade", "websocket");
        response.setHeader("Connection", "Upgrade");
        this.setHeaders(response);
        if (!this.getSubProtocol().isEmpty()) {
            response.setHeader("Sec-WebSocket-Protocol", this.join(application.getSupportedProtocols(this.getSubProtocol())));
        }
        try {
            response.sendHeaders();
            response.flush();
        }
        catch (IOException e) {
            throw new HandshakeException(e.getMessage(), e);
        }
    }

    protected abstract void setHeaders(Response var1);

    protected final List<String> split(String header) {
        if (header == null) {
            return Collections.emptyList();
        }
        List<String> list = Arrays.asList(header.split(","));
        this.sanitize(list);
        return list;
    }
}

