/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.ClientNetworkHandler;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.DefaultWebSocket;
import com.sun.grizzly.websockets.HandShake;
import com.sun.grizzly.websockets.Version;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketAdapter;
import com.sun.grizzly.websockets.WebSocketEngine;
import com.sun.grizzly.websockets.WebSocketException;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class WebSocketClient
extends DefaultWebSocket {
    public static final int DEFAULT_TIMEOUT = WebSocketEngine.DEFAULT_TIMEOUT;
    public static final TimeUnit TIMEOUT_UNIT = TimeUnit.SECONDS;
    private final URL address;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public WebSocketClient(String url, WebSocketListener ... listeners) throws IOException {
        this(url, WebSocketEngine.DEFAULT_VERSION, listeners);
    }

    public WebSocketClient(String url, Version version, WebSocketListener ... listeners) throws IOException {
        super(version.createHandler(true), listeners);
        this.address = new URL(url);
        this.setNetworkHandler(new ClientNetworkHandler(this));
        this.add(new CloseAdapter());
    }

    public WebSocket connect() {
        return this.connect(WebSocketEngine.DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    public WebSocket connect(int timeout, TimeUnit unit) {
        Callable<WebSocket> callable = new Callable<WebSocket>(){

            @Override
            public WebSocketClient call() {
                try {
                    HandShake handshake = WebSocketClient.this.protocolHandler.handshake(WebSocketClient.this.address);
                    WebSocketClient.this.onConnect();
                    WebSocketClient.this.queueRead();
                    return WebSocketClient.this;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        };
        Future<WebSocket> future = this.executorService.submit(callable);
        try {
            return future.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new WebSocketException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new WebSocketException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            throw new WebSocketException(e.getMessage(), e);
        }
    }

    private void queueRead() {
        this.execute(new Runnable(){

            public void run() {
                WebSocketClient.this.protocolHandler.readFrame();
                if (WebSocketClient.this.isConnected()) {
                    WebSocketClient.this.queueRead();
                }
            }
        });
    }

    public URL getAddress() {
        return this.address;
    }

    protected void execute(Runnable runnable) {
        this.executorService.submit(runnable);
    }

    private static class CloseAdapter
    extends WebSocketAdapter {
        private CloseAdapter() {
        }

        public void onClose(WebSocket socket, DataFrame frame) {
            socket.close();
        }
    }
}

