/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets.draft07;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.HandShake;
import com.sun.grizzly.websockets.Masker;
import com.sun.grizzly.websockets.ProtocolError;
import com.sun.grizzly.websockets.ProtocolHandler;
import com.sun.grizzly.websockets.draft07.HandShake07;
import com.sun.grizzly.websockets.frametypes.BinaryFrameType;
import com.sun.grizzly.websockets.frametypes.ClosingFrameType;
import com.sun.grizzly.websockets.frametypes.ContinuationFrameType;
import com.sun.grizzly.websockets.frametypes.PingFrameType;
import com.sun.grizzly.websockets.frametypes.PongFrameType;
import com.sun.grizzly.websockets.frametypes.TextFrameType;

public class Draft07Handler
extends ProtocolHandler {
    public Draft07Handler(boolean maskData) {
        super(maskData);
    }

    public byte[] frame(DataFrame frame) {
        byte opcode = this.checkForLastFrame(frame, this.getOpcode(frame.getType()));
        byte[] bytes = frame.getType().getBytes(frame);
        byte[] lengthBytes = this.encodeLength(bytes.length);
        int length = 1 + lengthBytes.length + bytes.length + (this.maskData ? 4 : 0);
        int payloadStart = 1 + lengthBytes.length + (this.maskData ? 4 : 0);
        byte[] packet = new byte[length];
        packet[0] = opcode;
        System.arraycopy(lengthBytes, 0, packet, 1, lengthBytes.length);
        if (this.maskData) {
            Masker masker = new Masker(this.handler);
            masker.generateMask();
            packet[1] = (byte)(packet[1] | 0x80);
            masker.mask(packet, payloadStart, bytes);
            System.arraycopy(masker.getMask(), 0, packet, payloadStart - 4, 4);
        } else {
            System.arraycopy(bytes, 0, packet, payloadStart, bytes.length);
        }
        return packet;
    }

    public DataFrame unframe() {
        byte[] data;
        long length;
        boolean masked;
        boolean rsvBitSet;
        byte opcode = this.handler.get();
        boolean bl = rsvBitSet = this.isBitSet(opcode, 6) || this.isBitSet(opcode, 5) || this.isBitSet(opcode, 4);
        if (rsvBitSet) {
            throw new ProtocolError("RSV bit(s) incorrectly set.");
        }
        boolean finalFragment = this.isBitSet(opcode, 7);
        boolean controlFrame = this.isControlFrame(opcode);
        opcode = (byte)(opcode & 0x7F);
        FrameType type = this.valueOf(this.inFragmentedType, opcode);
        if (!finalFragment && controlFrame) {
            throw new ProtocolError("Fragmented control frame");
        }
        if (!controlFrame) {
            if (this.isContinuationFrame(opcode) && !this.processingFragment) {
                throw new ProtocolError("End fragment sent, but wasn't processing any previous fragments");
            }
            if (this.processingFragment && !this.isContinuationFrame(opcode)) {
                throw new ProtocolError("Fragment sent but opcode was 0");
            }
            if (!finalFragment && !this.isContinuationFrame(opcode)) {
                this.processingFragment = true;
            }
            if (!finalFragment) {
                if (this.inFragmentedType == 0) {
                    this.inFragmentedType = opcode;
                }
            } else {
                this.processingFragment = false;
            }
        }
        byte lengthCode = this.handler.get();
        Masker masker = new Masker(this.handler);
        boolean bl2 = masked = (lengthCode & 0x80) == 128;
        if (masked) {
            lengthCode = (byte)(lengthCode ^ 0x80);
        }
        if (lengthCode <= 125) {
            length = lengthCode;
        } else {
            if (controlFrame) {
                throw new ProtocolError("Control frame payloads must be no greater than 125 bytes.");
            }
            length = this.decodeLength(this.handler.get(lengthCode == 126 ? 2 : 8));
        }
        if (masked) {
            masker.setMask(this.handler.get(4));
        }
        if ((long)(data = masker.unmask((int)length)).length != length) {
            throw new ProtocolError(String.format("Data read (%s) is not the expected size (%s)", data.length, length));
        }
        DataFrame dataFrame = type.create(finalFragment, data);
        if (!controlFrame && (this.isTextFrame(opcode) || this.inFragmentedType == 1)) {
            this.utf8Decode(finalFragment, data, dataFrame);
        }
        if (!controlFrame && finalFragment) {
            this.inFragmentedType = 0;
        }
        return dataFrame;
    }

    protected boolean isControlFrame(byte opcode) {
        return (opcode & 8) == 8;
    }

    private boolean isBitSet(byte b, int bit) {
        return (b >> bit & 1) != 0;
    }

    private boolean isContinuationFrame(byte opcode) {
        return opcode == 0;
    }

    private boolean isTextFrame(byte opcode) {
        return opcode == 1;
    }

    private byte getOpcode(FrameType type) {
        if (type instanceof TextFrameType) {
            return 1;
        }
        if (type instanceof BinaryFrameType) {
            return 2;
        }
        if (type instanceof ClosingFrameType) {
            return 8;
        }
        if (type instanceof PingFrameType) {
            return 9;
        }
        if (type instanceof PongFrameType) {
            return 10;
        }
        throw new ProtocolError("Unknown frame type: " + type.getClass().getName());
    }

    private FrameType valueOf(byte fragmentType, byte value) {
        int opcode = value & 0xF;
        switch (opcode) {
            case 0: {
                return new ContinuationFrameType((fragmentType & 1) == 1);
            }
            case 1: {
                return new TextFrameType();
            }
            case 2: {
                return new BinaryFrameType();
            }
            case 8: {
                return new ClosingFrameType();
            }
            case 9: {
                return new PingFrameType();
            }
            case 10: {
                return new PongFrameType();
            }
        }
        throw new ProtocolError(String.format("Unknown frame type: %s, %s", Integer.toHexString(opcode & 0xFF).toUpperCase(), this.handler));
    }

    protected HandShake createHandShake(Request request) {
        return new HandShake07(request);
    }

    protected HandShake createHandShake(URL url) {
        return new HandShake07(url);
    }
}

