/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.http.servlet.FilterChainImpl;
import com.sun.grizzly.http.servlet.FilterConfigImpl;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletConfigImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ServletAdapter
extends GrizzlyAdapter {
    public static final int REQUEST_RESPONSE_NOTES = 12;
    public static final int SERVLETCONFIG_NOTES = 13;
    private Servlet servletInstance = null;
    private FilterChainImpl filterChain = new FilterChainImpl();
    private HashMap<String, String> parameters = new HashMap();
    private boolean isInitialized = false;
    private ReentrantLock initializedLock = new ReentrantLock();

    public ServletAdapter() {
    }

    public ServletAdapter(String publicDirectory) {
        super(publicDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        try {
            Request req = request.getRequest();
            Response res = response.getResponse();
            HttpServletRequestImpl httpRequest = (HttpServletRequestImpl)req.getNote(12);
            HttpServletResponseImpl httpResponse = (HttpServletResponseImpl)res.getNote(12);
            ServletConfigImpl servletConfig = (ServletConfigImpl)req.getNote(13);
            if (httpRequest == null) {
                httpRequest = new HttpServletRequestImpl(request);
                httpResponse = new HttpServletResponseImpl(response);
                ServletContextImpl servletCtx = new ServletContextImpl();
                servletCtx.setInitParameter(this.parameters);
                servletConfig = new ServletConfigImpl(servletCtx);
                httpRequest.setContextImpl(servletCtx);
                req.setNote(12, (Object)httpRequest);
                req.setNote(13, (Object)servletConfig);
                res.setNote(12, (Object)httpResponse);
            }
            this.initializedLock.lock();
            try {
                if (this.servletInstance == null) {
                    String servletClassName = System.getProperty("com.sun.grizzly.servletClass");
                    if (servletClassName != null) {
                        this.servletInstance = ServletAdapter.loadServletInstance(servletClassName);
                    }
                    if (this.servletInstance == null) {
                        throw new RuntimeException("No Servlet defined");
                    }
                }
                if (!this.isInitialized) {
                    this.servletInstance.init((ServletConfig)servletConfig);
                    this.isInitialized = true;
                    this.filterChain.setServlet(servletConfig, this.servletInstance);
                }
            }
            finally {
                this.initializedLock.unlock();
            }
            httpResponse.addHeader("server", "grizzly/1.7");
            this.filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        catch (Throwable ex) {
            this.getLogger().log(Level.SEVERE, "service exception:", ex);
        }
    }

    public void afterService(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
        Request req = request.getRequest();
        Response res = response.getResponse();
        HttpServletRequestImpl httpRequest = (HttpServletRequestImpl)req.getNote(12);
        HttpServletResponseImpl httpResponse = (HttpServletResponseImpl)req.getNote(12);
        httpRequest.recycle();
        httpResponse.recycle();
    }

    public void addInitParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    private static Servlet loadServletInstance(String servletClass) {
        Class<?> className = null;
        try {
            className = Class.forName(servletClass, true, Thread.currentThread().getContextClassLoader());
            return (Servlet)className.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public void addFilter(Filter filter, String filterName, Map initParameters) {
        FilterConfigImpl filterConfig = new FilterConfigImpl();
        filterConfig.setFilter(filter);
        filterConfig.setFilterName(filterName);
        filterConfig.setinitParameters(initParameters);
        this.filterChain.addFilter(filterConfig);
    }

    public Servlet getServletInstance() {
        return this.servletInstance;
    }

    public void setServletInstance(Servlet servletInstance) {
        this.servletInstance = servletInstance;
    }
}

