/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.http.servlet.FilterChainImpl;
import com.sun.grizzly.http.servlet.FilterConfigImpl;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletConfigImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.IntrospectionUtils;
import com.sun.grizzly.util.http.Cookie;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ServletAdapter
extends GrizzlyAdapter {
    public static final int REQUEST_RESPONSE_NOTES = 29;
    public static final int SERVLETCONFIG_NOTES = 30;
    private Servlet servletInstance = null;
    private FilterChainImpl filterChain = new FilterChainImpl();
    private String servletPath = "";
    private String contextPath = "";
    private String basePath = "";
    private String fullUrlPath = null;
    private HashMap<String, String> parameters = new HashMap();
    private boolean isInitialized = false;
    private ReentrantLock initializedLock = new ReentrantLock();
    protected HashMap<String, Object> properties = new HashMap();

    public ServletAdapter() {
    }

    public ServletAdapter(String publicDirectory) {
        super(publicDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        try {
            Cookie[] cookies;
            if (this.fullUrlPath == null) {
                this.fullUrlPath = this.contextPath + this.servletPath;
            }
            Request req = request.getRequest();
            Response res = response.getResponse();
            String uri = request.getRequestURI();
            if (!uri.startsWith(this.fullUrlPath)) {
                this.customizeErrorPage(response, "Resource Not Found", 404);
                return;
            }
            HttpServletRequestImpl httpRequest = (HttpServletRequestImpl)req.getNote(29);
            HttpServletResponseImpl httpResponse = (HttpServletResponseImpl)res.getNote(29);
            ServletConfigImpl servletConfig = (ServletConfigImpl)req.getNote(30);
            if (httpRequest == null) {
                httpRequest = new HttpServletRequestImpl(request);
                httpResponse = new HttpServletResponseImpl(response);
                ServletContextImpl servletCtx = new ServletContextImpl();
                servletCtx.setInitParameter(this.parameters);
                servletCtx.setServletPath(this.servletPath);
                servletCtx.setContextPath(this.contextPath);
                servletCtx.setBasePath(this.basePath);
                this.configureProperties(servletCtx);
                servletConfig = new ServletConfigImpl(servletCtx);
                httpRequest.setContextImpl(servletCtx);
                req.setNote(29, (Object)httpRequest);
                req.setNote(30, (Object)servletConfig);
                res.setNote(29, (Object)httpResponse);
            }
            if ((cookies = request.getCookies()) != null) {
                for (Cookie c : cookies) {
                    if (!"JSESSIONID".equals(c.getName())) continue;
                    request.setRequestedSessionId(c.getValue());
                    request.setRequestedSessionCookie(true);
                    break;
                }
            }
            httpRequest.initSession();
            if (!this.isInitialized) {
                this.initializedLock.lock();
                try {
                    if (this.servletInstance == null) {
                        String servletClassName = System.getProperty("com.sun.grizzly.servletClass");
                        if (servletClassName != null) {
                            this.servletInstance = ServletAdapter.loadServletInstance(servletClassName);
                        }
                        if (this.servletInstance == null) {
                            throw new RuntimeException("Invalid Servlet defined");
                        }
                    }
                    if (!this.isInitialized) {
                        this.servletInstance.init((ServletConfig)servletConfig);
                        this.isInitialized = true;
                        this.filterChain.setServlet(servletConfig, this.servletInstance);
                    }
                }
                finally {
                    this.initializedLock.unlock();
                }
            }
            httpResponse.addHeader("server", "grizzly/1.8.1");
            this.filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        catch (Throwable ex) {
            this.getLogger().log(Level.SEVERE, "service exception:", ex);
            this.customizeErrorPage(response, "Internal Error", 500);
        }
    }

    public void customizeErrorPage(GrizzlyResponse response, String message, int errorCode) {
        response.setStatus(errorCode, "Not Found");
        response.setContentType("text/html");
        try {
            response.getWriter().write("<html><body><h1>" + message + "</h1></body></html>");
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public void afterService(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
        this.filterChain.recycle();
    }

    public void addInitParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    private static final Servlet loadServletInstance(String servletClass) {
        Class<?> className = null;
        try {
            className = Class.forName(servletClass, true, Thread.currentThread().getContextClassLoader());
            return (Servlet)className.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public void addFilter(Filter filter, String filterName, Map initParameters) {
        FilterConfigImpl filterConfig = new FilterConfigImpl();
        filterConfig.setFilter(filter);
        filterConfig.setFilterName(filterName);
        filterConfig.setinitParameters(initParameters);
        this.filterChain.addFilter(filterConfig);
    }

    public Servlet getServletInstance() {
        return this.servletInstance;
    }

    public void setServletInstance(Servlet servletInstance) {
        this.servletInstance = servletInstance;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    protected String getBasePath() {
        return this.basePath;
    }

    protected void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private void configureProperties(Object object) {
        for (String name : this.properties.keySet()) {
            String value = this.properties.get(name).toString();
            IntrospectionUtils.setProperty((Object)object, (String)name, (String)value);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }
}

