/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.async;

import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AbstractAsyncQueueReader;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;

public class TCPAsyncQueueReader
extends AbstractAsyncQueueReader {
    public TCPAsyncQueueReader(SelectorHandler selectorHandler) {
        super(selectorHandler);
    }

    protected SocketAddress doRead(ReadableByteChannel channel, ByteBuffer byteBuffer, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        if (readPostProcessor != null) {
            ByteBuffer inputByteBuffer = null;
            int oldPosition = byteBuffer.position();
            do {
                int readBytes;
                if ((readBytes = this.doRead(channel, inputByteBuffer = readPostProcessor.getInternalByteBuffer())) > 0) {
                    readPostProcessor.process(byteBuffer);
                    continue;
                }
                if (readBytes != -1) continue;
                if (byteBuffer.position() == oldPosition) {
                    throw new EOFException();
                }
                break;
            } while (byteBuffer.hasRemaining() && !inputByteBuffer.hasRemaining());
        } else {
            this.doRead(channel, byteBuffer);
        }
        return ((SocketChannel)channel).socket().getRemoteSocketAddress();
    }

    private int doRead(ReadableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
        int readBytes = 0;
        int lastReadBytes = 0;
        do {
            if ((lastReadBytes = channel.read(byteBuffer)) > 0) {
                readBytes += lastReadBytes;
                continue;
            }
            if (lastReadBytes != -1 || readBytes != 0) continue;
            readBytes = -1;
        } while (lastReadBytes > 0 && byteBuffer.hasRemaining());
        return readBytes;
    }
}

