/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.http.mapper;

import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.buf.Ascii;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;

public class Mapper {
    private static final Logger logger = LoggerUtils.getLogger();
    protected Host[] hosts = new Host[0];
    protected String defaultHostName = null;
    protected Context context = new Context();
    private HashMap defaultContextPathsMap = new HashMap();
    private int port = 0;
    private static boolean allowReplacement = false;

    public static void setAllowReplacement(boolean ar) {
        allowReplacement = ar;
    }

    public static boolean allowReplacement() {
        return allowReplacement;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getDefaultHostName() {
        return this.defaultHostName;
    }

    public void setDefaultHostName(String defaultHostName) {
        this.defaultHostName = defaultHostName;
    }

    public synchronized void addHost(String name, String[] aliases, Object host) {
        MapElement[] newHosts = new Host[this.hosts.length + 1];
        Host newHost = new Host();
        ContextList contextList = new ContextList();
        Context[] defaultContexts = new Context[1];
        String[] defaultContextPaths = new String[1];
        newHost.name = name;
        newHost.contextList = contextList;
        newHost.object = host;
        newHost.defaultContexts = defaultContexts;
        newHost.defaultContextPaths = defaultContextPaths;
        Host oldElem = (Host)Mapper.insertMap(this.hosts, newHosts, newHost);
        if (oldElem == null) {
            this.hosts = newHosts;
        } else if (allowReplacement) {
            oldElem.object = host;
            contextList = oldElem.contextList;
        }
        for (int i = 0; i < aliases.length; ++i) {
            newHosts = new Host[this.hosts.length + 1];
            newHost = new Host();
            newHost.name = aliases[i];
            newHost.contextList = contextList;
            newHost.defaultContexts = defaultContexts;
            newHost.defaultContextPaths = defaultContextPaths;
            newHost.object = host;
            if (Mapper.insertMap(this.hosts, newHosts, newHost) != null) continue;
            this.hosts = newHosts;
        }
        String defaultContextPath = (String)this.defaultContextPathsMap.get(name);
        if (defaultContextPath != null) {
            newHost.defaultContextPaths[0] = defaultContextPath;
        }
    }

    public synchronized void removeHost(String name) {
        int pos = Mapper.find((MapElement[])this.hosts, name);
        if (pos < 0) {
            return;
        }
        Object host = this.hosts[pos].object;
        MapElement[] newHosts = new Host[this.hosts.length - 1];
        if (Mapper.removeMap(this.hosts, newHosts, name)) {
            this.hosts = newHosts;
        }
        for (int i = 0; i < newHosts.length; ++i) {
            MapElement[] newHosts2;
            if (((Host)newHosts[i]).object != host || !Mapper.removeMap(this.hosts, newHosts2 = new Host[this.hosts.length - 1], ((Host)newHosts[i]).name)) continue;
            this.hosts = newHosts2;
        }
        this.defaultContextPathsMap.remove(name);
    }

    public String[] getHosts() {
        String[] hostN = new String[this.hosts.length];
        for (int i = 0; i < this.hosts.length; ++i) {
            hostN[i] = this.hosts[i].name;
        }
        return hostN;
    }

    public void setContext(String path, String[] welcomeResources, javax.naming.Context resources) {
        this.context.name = path;
        this.context.welcomeResources = welcomeResources;
        this.context.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContext(String hostName, String path, Object context, String[] welcomeResources, javax.naming.Context resources) {
        MapElement[] hosts = this.hosts;
        int pos = Mapper.find(hosts, hostName);
        if (pos < 0) {
            this.addHost(hostName, new String[0], "");
            hosts = this.hosts;
            pos = Mapper.find(hosts, hostName);
        }
        if (pos < 0) {
            logger.severe("No host found: " + hostName);
        }
        MapElement host = hosts[pos];
        if (((Host)host).name.equals(hostName)) {
            int slashCount = Mapper.slashCount(path);
            MapElement mapElement = host;
            synchronized (mapElement) {
                MapElement[] contexts = ((Host)host).contextList.contexts;
                if (slashCount > ((Host)host).contextList.nesting) {
                    ((Host)host).contextList.nesting = slashCount;
                }
                MapElement[] newContexts = new Context[contexts.length + 1];
                Context newContext = new Context();
                newContext.name = path;
                newContext.object = context;
                newContext.welcomeResources = welcomeResources;
                newContext.resources = resources;
                Context oldElem = (Context)Mapper.insertMap(contexts, newContexts, newContext);
                if (oldElem == null) {
                    ((Host)host).contextList.contexts = newContexts;
                    if (path.equals(((Host)host).defaultContextPaths[0])) {
                        ((Host)host).defaultContexts[0] = newContext;
                    }
                } else if (allowReplacement) {
                    oldElem.object = context;
                    oldElem.welcomeResources = welcomeResources;
                    oldElem.resources = resources;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(String hostName, String path) {
        MapElement[] hosts = this.hosts;
        int pos = Mapper.find(hosts, hostName);
        if (pos < 0) {
            return;
        }
        MapElement host = hosts[pos];
        if (((Host)host).name.equals(hostName)) {
            MapElement mapElement = host;
            synchronized (mapElement) {
                MapElement[] contexts = ((Host)host).contextList.contexts;
                if (contexts.length == 0) {
                    return;
                }
                MapElement[] newContexts = new Context[contexts.length - 1];
                if (Mapper.removeMap(contexts, newContexts, path)) {
                    ((Host)host).contextList.contexts = newContexts;
                    ((Host)host).contextList.nesting = 0;
                    for (int i = 0; i < newContexts.length; ++i) {
                        int slashCount = Mapper.slashCount(((Context)newContexts[i]).name);
                        if (slashCount <= ((Host)host).contextList.nesting) continue;
                        ((Host)host).contextList.nesting = slashCount;
                    }
                }
            }
        }
    }

    public String[] getContextNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.hosts.length; ++i) {
            for (int j = 0; j < this.hosts[i].contextList.contexts.length; ++j) {
                String cname = this.hosts[i].contextList.contexts[j].name;
                list.add("//" + this.hosts[i].name + (cname.startsWith("/") ? cname : "/"));
            }
        }
        String[] res = new String[list.size()];
        return list.toArray(res);
    }

    public void addWrapper(String hostName, String contextPath, String path, Object wrapper) {
        this.addWrapper(hostName, contextPath, path, wrapper, false);
    }

    public void addWrapper(String hostName, String contextPath, String path, Object wrapper, boolean jspWildCard) {
        MapElement[] hosts = this.hosts;
        int pos = Mapper.find(hosts, hostName);
        if (pos < 0) {
            return;
        }
        MapElement host = hosts[pos];
        if (((Host)host).name.equals(hostName)) {
            MapElement[] contexts = ((Host)host).contextList.contexts;
            int pos2 = Mapper.find(contexts, contextPath);
            if (pos2 < 0) {
                logger.severe("No context found: " + contextPath);
                return;
            }
            MapElement context = contexts[pos2];
            if (((Context)context).name.equals(contextPath)) {
                this.addWrapper((Context)context, path, wrapper, jspWildCard);
            }
        }
    }

    public void addWrapper(String path, Object wrapper) {
        this.addWrapper(this.context, path, wrapper);
    }

    public void addWrapper(String path, Object wrapper, boolean jspWildCard) {
        this.addWrapper(this.context, path, wrapper, jspWildCard);
    }

    protected void addWrapper(Context context, String path, Object wrapper) {
        this.addWrapper(context, path, wrapper, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWrapper(Context context, String path, Object wrapper, boolean jspWildCard) {
        Context context2 = context;
        synchronized (context2) {
            Wrapper newWrapper = new Wrapper();
            newWrapper.object = wrapper;
            newWrapper.jspWildCard = jspWildCard;
            if (path.endsWith("/*")) {
                newWrapper.name = path.substring(0, path.length() - 2);
                MapElement[] oldWrappers = context.wildcardWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length + 1];
                if (Mapper.insertMap(oldWrappers, newWrappers, newWrapper) == null) {
                    context.wildcardWrappers = newWrappers;
                    int slashCount = Mapper.slashCount(newWrapper.name);
                    if (slashCount > context.nesting) {
                        context.nesting = slashCount;
                    }
                }
            } else if (path.startsWith("*.")) {
                newWrapper.name = path.substring(2);
                MapElement[] oldWrappers = context.extensionWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length + 1];
                if (Mapper.insertMap(oldWrappers, newWrappers, newWrapper) == null) {
                    context.extensionWrappers = newWrappers;
                }
            } else if (path.equals("/")) {
                newWrapper.name = "";
                context.defaultWrapper = newWrapper;
            } else {
                newWrapper.name = path;
                MapElement[] oldWrappers = context.exactWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length + 1];
                if (Mapper.insertMap(oldWrappers, newWrappers, newWrapper) == null) {
                    context.exactWrappers = newWrappers;
                }
            }
        }
    }

    public void removeWrapper(String path) {
        this.removeWrapper(this.context, path);
    }

    public void removeWrapper(String hostName, String contextPath, String path) {
        MapElement[] hosts = this.hosts;
        int pos = Mapper.find(hosts, hostName);
        if (pos < 0) {
            return;
        }
        MapElement host = hosts[pos];
        if (((Host)host).name.equals(hostName)) {
            MapElement[] contexts = ((Host)host).contextList.contexts;
            int pos2 = Mapper.find(contexts, contextPath);
            if (pos2 < 0) {
                return;
            }
            MapElement context = contexts[pos2];
            if (((Context)context).name.equals(contextPath)) {
                this.removeWrapper((Context)context, path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeWrapper(Context context, String path) {
        Context context2 = context;
        synchronized (context2) {
            if (path.endsWith("/*")) {
                MapElement[] oldWrappers = context.wildcardWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length - 1];
                String name = path.substring(0, path.length() - 2);
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.nesting = 0;
                    for (int i = 0; i < newWrappers.length; ++i) {
                        int slashCount = Mapper.slashCount(((Wrapper)newWrappers[i]).name);
                        if (slashCount <= context.nesting) continue;
                        context.nesting = slashCount;
                    }
                    context.wildcardWrappers = newWrappers;
                }
            } else if (path.startsWith("*.")) {
                MapElement[] oldWrappers = context.extensionWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length - 1];
                String name = path.substring(2);
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.extensionWrappers = newWrappers;
                }
            } else if (path.equals("/")) {
                context.defaultWrapper = null;
            } else {
                MapElement[] oldWrappers = context.exactWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length - 1];
                String name = path;
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.exactWrappers = newWrappers;
                }
            }
        }
    }

    public String getWrappersString(String host, String context) {
        String[] names = this.getWrapperNames(host, context);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            sb.append(names[i]).append(":");
        }
        return sb.toString();
    }

    public String[] getWrapperNames(String host, String context) {
        ArrayList<String> list = new ArrayList<String>();
        if (host == null) {
            host = "";
        }
        if (context == null) {
            context = "";
        }
        for (int i = 0; i < this.hosts.length; ++i) {
            if (!host.equals(this.hosts[i].name)) continue;
            for (int j = 0; j < this.hosts[i].contextList.contexts.length; ++j) {
                int k;
                if (!context.equals(this.hosts[i].contextList.contexts[j].name)) continue;
                Context ctx = this.hosts[i].contextList.contexts[j];
                list.add(ctx.defaultWrapper.path);
                for (k = 0; k < ctx.exactWrappers.length; ++k) {
                    list.add(ctx.exactWrappers[k].path);
                }
                for (k = 0; k < ctx.wildcardWrappers.length; ++k) {
                    list.add(ctx.wildcardWrappers[k].path + "*");
                }
                for (k = 0; k < ctx.extensionWrappers.length; ++k) {
                    list.add("*." + ctx.extensionWrappers[k].path);
                }
            }
        }
        String[] res = new String[list.size()];
        return list.toArray(res);
    }

    public void setDefaultContextPath(String hostName, String defaultContextPath) throws Exception {
        int pos;
        if (defaultContextPath != null) {
            this.defaultContextPathsMap.put(hostName, defaultContextPath);
        }
        if ((pos = Mapper.find((MapElement[])this.hosts, hostName)) < 0) {
            return;
        }
        this.hosts[pos].defaultContextPaths[0] = defaultContextPath;
        if (defaultContextPath != null) {
            this.addDefaultContext(this.hosts[pos], defaultContextPath);
        } else {
            this.hosts[pos].defaultContexts[0] = null;
            this.defaultContextPathsMap.remove(hostName);
        }
    }

    private void addDefaultContext(Host host, String defaultContextPath) throws Exception {
        boolean defaultContextFound = false;
        Context[] contexts = host.contextList.contexts;
        if (contexts != null) {
            for (int i = 0; i < contexts.length; ++i) {
                if (!contexts[i].name.equals(defaultContextPath)) continue;
                host.defaultContexts[0] = contexts[i];
                defaultContextFound = true;
                break;
            }
        }
        if (!defaultContextFound) {
            throw new Exception("No context matching " + defaultContextPath + " deployed on virtual server " + host.name);
        }
    }

    public void map(MessageBytes host, MessageBytes uri, MappingData mappingData) throws Exception {
        if (host.isNull()) {
            host.getCharChunk().append(this.defaultHostName);
        }
        host.toChars();
        uri.toChars();
        this.internalMap(host.getCharChunk(), uri.getCharChunk(), mappingData);
    }

    public void map(MessageBytes uri, MappingData mappingData) throws Exception {
        uri.toChars();
        CharChunk uricc = uri.getCharChunk();
        uricc.setLimit(-1);
        this.internalMapWrapper(this.context, uricc, mappingData);
    }

    private final void internalMap(CharChunk host, CharChunk uri, MappingData mappingData) throws Exception {
        int pos;
        uri.setLimit(-1);
        MapElement[] contexts = null;
        Context context = null;
        int nesting = 0;
        int hostPos = -1;
        if (mappingData.host == null) {
            MapElement[] hosts = this.hosts;
            pos = Mapper.findIgnoreCase(hosts, host);
            if (pos != -1 && host.equalsIgnoreCase(((Host)hosts[pos]).name)) {
                mappingData.host = ((Host)hosts[pos]).object;
                hostPos = pos;
                contexts = ((Host)hosts[pos]).contextList.contexts;
                nesting = ((Host)hosts[pos]).contextList.nesting;
            } else {
                if (this.defaultHostName == null) {
                    return;
                }
                pos = Mapper.find(hosts, this.defaultHostName);
                if (pos != -1 && this.defaultHostName.equals(((Host)hosts[pos]).name)) {
                    mappingData.host = ((Host)hosts[pos]).object;
                    hostPos = pos;
                    contexts = ((Host)hosts[pos]).contextList.contexts;
                    nesting = ((Host)hosts[pos]).contextList.nesting;
                } else {
                    return;
                }
            }
        }
        if (mappingData.context == null) {
            boolean found = false;
            pos = Mapper.find(contexts, uri);
            if (pos == -1) {
                if (this.hosts[hostPos].defaultContexts[0] == null) {
                    return;
                }
                context = this.hosts[hostPos].defaultContexts[0];
                mappingData.context = context.object;
                mappingData.contextPath.setString(context.name);
                found = true;
                mappingData.isDefaultContext = true;
            }
            if (!found) {
                int lastSlash = -1;
                int uriEnd = uri.getEnd();
                int length = -1;
                while (pos >= 0) {
                    if (uri.startsWith(contexts[pos].name)) {
                        length = contexts[pos].name.length();
                        if (uri.getLength() == length) {
                            found = true;
                            break;
                        }
                        if (uri.startsWithIgnoreCase("/", length)) {
                            found = true;
                            break;
                        }
                    }
                    lastSlash = lastSlash == -1 ? Mapper.nthSlash(uri, nesting + 1) : Mapper.lastSlash(uri);
                    uri.setEnd(lastSlash);
                    pos = Mapper.find(contexts, uri);
                }
                uri.setEnd(uriEnd);
                if (!found) {
                    if (contexts[0].name.equals("")) {
                        context = contexts[0];
                    } else if (this.hosts[hostPos].defaultContexts[0] != null) {
                        context = this.hosts[hostPos].defaultContexts[0];
                        mappingData.isDefaultContext = true;
                    }
                } else {
                    context = contexts[pos];
                }
                if (context != null) {
                    mappingData.context = context.object;
                    mappingData.contextPath.setString(context.name);
                }
            }
        }
        if (context != null && mappingData.wrapper == null) {
            this.internalMapWrapper(context, uri, mappingData);
        }
    }

    private final void internalMapWrapper(Context context, CharChunk path, MappingData mappingData) throws Exception {
        int pathOffset = path.getOffset();
        int pathEnd = path.getEnd();
        int servletPath = pathOffset;
        boolean noServletPath = false;
        if (mappingData.isDefaultContext) {
            servletPath = pathOffset;
        } else {
            int length = context.name.length();
            if (length != pathEnd - pathOffset) {
                servletPath = pathOffset + length;
            } else {
                noServletPath = true;
                path.append('/');
                pathOffset = path.getOffset();
                pathEnd = path.getEnd();
                servletPath = pathOffset + length;
            }
        }
        path.setOffset(servletPath);
        Wrapper[] exactWrappers = context.exactWrappers;
        this.internalMapExactWrapper(exactWrappers, path, mappingData);
        boolean checkJspWelcomeFiles = false;
        Wrapper[] wildcardWrappers = context.wildcardWrappers;
        if (mappingData.wrapper == null) {
            this.internalMapWildcardWrapper(wildcardWrappers, context.nesting, path, mappingData);
            if (mappingData.wrapper != null && mappingData.jspWildCard) {
                char[] buf = path.getBuffer();
                if (buf[pathEnd - 1] == '/') {
                    mappingData.wrapper = null;
                    checkJspWelcomeFiles = true;
                } else {
                    mappingData.wrapperPath.setChars(buf, path.getStart(), path.getLength());
                    mappingData.pathInfo.recycle();
                }
            }
        }
        if (mappingData.wrapper == null && noServletPath) {
            mappingData.redirectPath.setChars(path.getBuffer(), pathOffset, pathEnd);
            path.setEnd(pathEnd - 1);
            return;
        }
        Wrapper[] extensionWrappers = context.extensionWrappers;
        if (mappingData.wrapper == null && !checkJspWelcomeFiles) {
            this.internalMapExtensionWrapper(extensionWrappers, path, mappingData);
        }
        if (mappingData.wrapper == null) {
            boolean checkWelcomeFiles = checkJspWelcomeFiles;
            if (!checkWelcomeFiles) {
                char[] buf = path.getBuffer();
                boolean bl = checkWelcomeFiles = buf[pathEnd - 1] == '/';
            }
            if (checkWelcomeFiles) {
                for (int i = 0; i < context.welcomeResources.length && mappingData.wrapper == null; ++i) {
                    path.setOffset(pathOffset);
                    path.setEnd(pathEnd);
                    path.append(context.welcomeResources[i], 0, context.welcomeResources[i].length());
                    path.setOffset(servletPath);
                    this.internalMapExactWrapper(exactWrappers, path, mappingData);
                    if (mappingData.wrapper == null) {
                        this.internalMapWildcardWrapper(wildcardWrappers, context.nesting, path, mappingData);
                    }
                    if (mappingData.wrapper != null || context.resources == null) continue;
                    Object file = null;
                    String pathStr = path.toString();
                    try {
                        file = context.resources.lookup(pathStr);
                    }
                    catch (NamingException nex) {
                        // empty catch block
                    }
                    if (file == null || file instanceof DirContext) continue;
                    this.internalMapExtensionWrapper(extensionWrappers, path, mappingData);
                    if (mappingData.wrapper != null || context.defaultWrapper == null) continue;
                    mappingData.wrapper = context.defaultWrapper.object;
                    mappingData.requestPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
                    mappingData.wrapperPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
                    mappingData.requestPath.setString(pathStr);
                    mappingData.wrapperPath.setString(pathStr);
                }
                path.setOffset(servletPath);
                path.setEnd(pathEnd);
            }
        }
        if (mappingData.wrapper == null && !checkJspWelcomeFiles) {
            if (context.defaultWrapper != null) {
                mappingData.wrapper = context.defaultWrapper.object;
                mappingData.requestPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
                mappingData.wrapperPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
            }
            char[] buf = path.getBuffer();
            if (context.resources != null && buf[pathEnd - 1] != '/') {
                Object file = null;
                String pathStr = path.toString();
                try {
                    file = context.resources.lookup(pathStr);
                }
                catch (NamingException nex) {
                    // empty catch block
                }
                if (file != null && file instanceof DirContext) {
                    path.setOffset(pathOffset);
                    path.append('/');
                    mappingData.redirectPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
                } else {
                    mappingData.requestPath.setString(pathStr);
                    mappingData.wrapperPath.setString(pathStr);
                }
            }
        }
        path.setOffset(pathOffset);
        path.setEnd(pathEnd);
    }

    private final void internalMapExactWrapper(Wrapper[] wrappers, CharChunk path, MappingData mappingData) {
        int pos = Mapper.find((MapElement[])wrappers, path);
        if (pos != -1 && path.equals(wrappers[pos].name)) {
            mappingData.requestPath.setString(wrappers[pos].name);
            mappingData.wrapperPath.setString(wrappers[pos].name);
            mappingData.wrapper = wrappers[pos].object;
        }
    }

    private final void internalMapWildcardWrapper(Wrapper[] wrappers, int nesting, CharChunk path, MappingData mappingData) {
        int pathEnd = path.getEnd();
        int pathOffset = path.getOffset();
        int lastSlash = -1;
        int length = -1;
        int pos = Mapper.find((MapElement[])wrappers, path);
        if (pos != -1) {
            boolean found = false;
            while (pos >= 0) {
                if (path.startsWith(wrappers[pos].name)) {
                    length = wrappers[pos].name.length();
                    if (path.getLength() == length) {
                        found = true;
                        break;
                    }
                    if (path.startsWithIgnoreCase("/", length)) {
                        found = true;
                        break;
                    }
                }
                lastSlash = lastSlash == -1 ? Mapper.nthSlash(path, nesting + 1) : Mapper.lastSlash(path);
                path.setEnd(lastSlash);
                pos = Mapper.find((MapElement[])wrappers, path);
            }
            path.setEnd(pathEnd);
            if (found) {
                mappingData.wrapperPath.setString(wrappers[pos].name);
                if (path.getLength() > length) {
                    mappingData.pathInfo.setChars(path.getBuffer(), path.getOffset() + length, path.getLength() - length);
                }
                mappingData.requestPath.setChars(path.getBuffer(), path.getOffset(), path.getLength());
                mappingData.wrapper = wrappers[pos].object;
                mappingData.jspWildCard = wrappers[pos].jspWildCard;
            }
        }
    }

    private final void internalMapExtensionWrapper(Wrapper[] wrappers, CharChunk path, MappingData mappingData) {
        char[] buf = path.getBuffer();
        int pathEnd = path.getEnd();
        int servletPath = path.getOffset();
        int slash = -1;
        for (int i = pathEnd - 1; i >= servletPath; --i) {
            if (buf[i] != '/') continue;
            slash = i;
            break;
        }
        if (slash >= 0) {
            int period = -1;
            for (int i = pathEnd - 1; i > slash; --i) {
                if (buf[i] != '.') continue;
                period = i;
                break;
            }
            if (period >= 0) {
                path.setOffset(period + 1);
                path.setEnd(pathEnd);
                int pos = Mapper.find((MapElement[])wrappers, path);
                if (pos != -1 && path.equals(wrappers[pos].name)) {
                    mappingData.wrapperPath.setChars(buf, servletPath, pathEnd - servletPath);
                    mappingData.requestPath.setChars(buf, servletPath, pathEnd - servletPath);
                    mappingData.wrapper = wrappers[pos].object;
                }
                path.setOffset(servletPath);
                path.setEnd(pathEnd);
            }
        }
    }

    private static final int find(MapElement[] map, CharChunk name) {
        return Mapper.find(map, name, name.getStart(), name.getEnd());
    }

    private static final int find(MapElement[] map, CharChunk name, int start, int end) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (Mapper.compare(name, start, end, map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        int i = 0;
        do {
            i = (b + a) / 2;
            int result = Mapper.compare(name, start, end, map[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = Mapper.compare(name, start, end, map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static final int findIgnoreCase(MapElement[] map, CharChunk name) {
        return Mapper.findIgnoreCase(map, name, name.getStart(), name.getEnd());
    }

    private static final int findIgnoreCase(MapElement[] map, CharChunk name, int start, int end) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (Mapper.compareIgnoreCase(name, start, end, map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        int i = 0;
        do {
            i = (b + a) / 2;
            int result = Mapper.compareIgnoreCase(name, start, end, map[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = Mapper.compareIgnoreCase(name, start, end, map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static final int find(MapElement[] map, String name) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (name.compareTo(map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        int i = 0;
        do {
            i = (b + a) / 2;
            int result = name.compareTo(map[i].name);
            if (result > 0) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = name.compareTo(map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static final int compare(CharChunk name, int start, int end, String compareTo) {
        int result = 0;
        char[] c = name.getBuffer();
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (c[i + start] > compareTo.charAt(i)) {
                result = 1;
                continue;
            }
            if (c[i + start] >= compareTo.charAt(i)) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    private static final int compareIgnoreCase(CharChunk name, int start, int end, String compareTo) {
        int result = 0;
        char[] c = name.getBuffer();
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (Ascii.toLower(c[i + start]) > Ascii.toLower(compareTo.charAt(i))) {
                result = 1;
                continue;
            }
            if (Ascii.toLower(c[i + start]) >= Ascii.toLower(compareTo.charAt(i))) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    private static final int lastSlash(CharChunk name) {
        char[] c = name.getBuffer();
        int end = name.getEnd();
        int start = name.getStart();
        int pos = end;
        while (pos > start && c[--pos] != '/') {
        }
        return pos;
    }

    private static final int nthSlash(CharChunk name, int n) {
        int start;
        char[] c = name.getBuffer();
        int end = name.getEnd();
        int pos = start = name.getStart();
        int count = 0;
        while (pos < end) {
            if (c[pos++] != '/' || ++count != n) continue;
            --pos;
            break;
        }
        return pos;
    }

    private static final int slashCount(String name) {
        int pos = -1;
        int count = 0;
        while ((pos = name.indexOf(47, pos + 1)) != -1) {
            ++count;
        }
        return count;
    }

    private static final MapElement insertMap(MapElement[] oldMap, MapElement[] newMap, MapElement newElement) {
        int pos = Mapper.find(oldMap, newElement.name);
        if (pos != -1 && newElement.name.equals(oldMap[pos].name)) {
            return oldMap[pos];
        }
        System.arraycopy(oldMap, 0, newMap, 0, pos + 1);
        newMap[pos + 1] = newElement;
        System.arraycopy(oldMap, pos + 1, newMap, pos + 2, oldMap.length - pos - 1);
        return null;
    }

    private static final boolean removeMap(MapElement[] oldMap, MapElement[] newMap, String name) {
        int pos = Mapper.find(oldMap, name);
        if (pos != -1 && name.equals(oldMap[pos].name)) {
            System.arraycopy(oldMap, 0, newMap, 0, pos);
            System.arraycopy(oldMap, pos + 1, newMap, pos, oldMap.length - pos - 1);
            return true;
        }
        return false;
    }

    protected static class Wrapper
    extends MapElement {
        public String path = null;
        public boolean jspWildCard = false;

        protected Wrapper() {
        }
    }

    protected static final class Context
    extends MapElement {
        public String path = null;
        public String[] welcomeResources = new String[0];
        public javax.naming.Context resources = null;
        public Wrapper defaultWrapper = null;
        public Wrapper[] exactWrappers = new Wrapper[0];
        public Wrapper[] wildcardWrappers = new Wrapper[0];
        public Wrapper[] extensionWrappers = new Wrapper[0];
        public int nesting = 0;

        protected Context() {
        }
    }

    protected static final class ContextList {
        public Context[] contexts = new Context[0];
        public int nesting = 0;

        protected ContextList() {
        }
    }

    protected static final class Host
    extends MapElement {
        public ContextList contextList = null;
        public String[] defaultContextPaths = null;
        public Context[] defaultContexts = null;

        protected Host() {
        }
    }

    protected static abstract class MapElement {
        public String name = null;
        public Object object = null;

        protected MapElement() {
        }
    }
}

