/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Pipeline;
import com.sun.grizzly.PipelineFullException;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolExecutorServicePipeline
extends ThreadPoolExecutor
implements Pipeline<Callable> {
    private static int DEFAULT_MIN_THREAD_COUNT = 5;
    private static int DEFAULT_MAX_THREAD_COUNT = 20;
    private static int DEFAULT_MAX_TASKS_QUEUED = Integer.MAX_VALUE;
    private static int DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT = 30000;
    private String name;
    protected int port;
    private int maxTasksCount;
    private AtomicInteger workerThreadCounter = new AtomicInteger();
    protected int priority;
    protected int initialByteBufferSize = 8192;
    private ByteBufferFactory.ByteBufferType byteBufferType = ByteBufferFactory.ByteBufferType.HEAP_VIEW;

    public ThreadPoolExecutorServicePipeline() {
        this(DEFAULT_MIN_THREAD_COUNT, DEFAULT_MAX_THREAD_COUNT, DEFAULT_MAX_TASKS_QUEUED, DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public ThreadPoolExecutorServicePipeline(int minThreads, int maxThreads, int maxTasksCount, long keepAliveTime, TimeUnit unit) {
        this(minThreads, maxThreads, maxTasksCount, keepAliveTime, unit, "Grizzly", 8080, 5);
    }

    public ThreadPoolExecutorServicePipeline(int minThreads, int maxThreads, int maxTasksCount, long keepAliveTime, TimeUnit unit, String name, int port, int priority) {
        super(minThreads, maxThreads, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(maxTasksCount));
        this.setThreadFactory(new WorkerThreadFactory(this));
        this.maxTasksCount = maxTasksCount;
        this.name = name;
        this.port = port;
        this.priority = priority;
    }

    @Override
    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized String getName() {
        return this.name + this.port;
    }

    public synchronized void setPort(int port) {
        this.port = port;
    }

    @Override
    public void execute(Callable task) throws PipelineFullException {
        this.submit(task);
    }

    @Override
    public Callable waitForIoTask() {
        Callable callable = null;
        try {
            final Runnable r = this.getQueue().take();
            if (r != null) {
                callable = new Callable(){

                    public Object call() throws Exception {
                        r.run();
                        return null;
                    }
                };
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return callable;
    }

    @Override
    public int getWaitingThread() {
        int waitingThreads = this.getPoolSize() - this.getActiveCount();
        if (waitingThreads < 0) {
            waitingThreads = 0;
        }
        return waitingThreads;
    }

    @Override
    public int getMaxThreads() {
        return this.getMaximumPoolSize();
    }

    @Override
    public void setMaxThreads(int maxThread) {
        this.setMaximumPoolSize(maxThread);
    }

    @Override
    public int getCurrentThreadCount() {
        return this.getPoolSize();
    }

    @Override
    public int getCurrentThreadsBusy() {
        return this.getActiveCount();
    }

    @Override
    public void initPipeline() {
    }

    @Override
    public void startPipeline() {
        this.prestartCoreThread();
    }

    @Override
    public void stopPipeline() {
        this.shutdownNow();
    }

    @Override
    public synchronized void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public void setMinThreads(int minThread) {
        this.setCorePoolSize(minThread);
    }

    public synchronized int getMaxQueueSize() {
        return this.maxTasksCount;
    }

    @Override
    public void setMaxQueueSize(int maxQueue) {
        throw new UnsupportedOperationException("Value could not be changed!");
    }

    @Override
    public void setThreadsIncrement(int threadIncrements) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int size() {
        return this.getQueue().size();
    }

    public ByteBufferFactory.ByteBufferType getByteBufferType() {
        return this.byteBufferType;
    }

    public void setByteBufferType(ByteBufferFactory.ByteBufferType byteBufferType) {
        this.byteBufferType = byteBufferType;
    }

    public synchronized int getInitialByteBufferSize() {
        return this.initialByteBufferSize;
    }

    public synchronized void setInitialByteBufferSize(int size) {
        this.initialByteBufferSize = size;
    }

    protected static class WorkerThreadFactory
    implements ThreadFactory {
        private ThreadPoolExecutorServicePipeline threadPool;

        public WorkerThreadFactory(ThreadPoolExecutorServicePipeline threadPool) {
            this.threadPool = threadPool;
        }

        public Thread newThread(Runnable r) {
            WorkerThreadImpl workerThread = new WorkerThreadImpl(this.threadPool, this.threadPool.name + "WorkerThread-" + this.threadPool.port + "-" + this.threadPool.workerThreadCounter.getAndIncrement(), r, this.threadPool.initialByteBufferSize);
            workerThread.setByteBufferType(this.threadPool.byteBufferType);
            workerThread.setPriority(this.threadPool.priority);
            return workerThread;
        }
    }
}

