/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.Controller;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.PipelineFullException;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.comet.NotificationHandler;
import com.sun.grizzly.http.TaskBase;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNotificationHandler
implements NotificationHandler {
    private static final Logger logger = Controller.logger();
    protected Pipeline pipeline;
    protected boolean blockingNotification = false;

    protected void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public boolean isBlockingNotification() {
        return this.blockingNotification;
    }

    @Override
    public void setBlockingNotification(boolean blockingNotification) {
        this.blockingNotification = blockingNotification;
    }

    @Override
    public void notify(final CometEvent cometEvent, final Iterator<CometHandler> iteratorHandlers) throws IOException {
        if (this.blockingNotification || this.pipeline == null) {
            this.notify0(cometEvent, iteratorHandlers);
        } else {
            try {
                this.pipeline.execute(new TaskBase(){

                    public void doTask() throws IOException {
                        DefaultNotificationHandler.this.notify0(cometEvent, iteratorHandlers);
                    }
                });
            }
            catch (PipelineFullException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    protected void notify0(CometEvent cometEvent, Iterator<CometHandler> iteratorHandlers) throws IOException {
        while (iteratorHandlers.hasNext()) {
            CometHandler cometHandler = iteratorHandlers.next();
            try {
                this.notify0(cometEvent, cometHandler);
            }
            catch (Throwable ex) {
                block5: {
                    try {
                        cometEvent.getCometContext().resumeCometHandler(cometHandler, true);
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(Level.FINE)) break block5;
                        logger.log(Level.FINEST, "Resume phase failed: ", ex);
                    }
                }
                logger.log(Level.WARNING, "Notification failed: ", ex);
            }
        }
    }

    @Override
    public void notify(final CometEvent cometEvent, final CometHandler cometHandler) throws IOException {
        if (this.blockingNotification || this.pipeline == null) {
            this.notify0(cometEvent, cometHandler);
        } else {
            try {
                this.pipeline.execute(new TaskBase(){

                    public void doTask() throws IOException {
                        try {
                            DefaultNotificationHandler.this.notify0(cometEvent, cometHandler);
                        }
                        catch (Throwable ex) {
                            try {
                                cometEvent.getCometContext().resumeCometHandler(cometHandler, true);
                            }
                            catch (Throwable t) {
                                logger.log(Level.FINEST, "Resume phase failed: ", ex);
                            }
                            logger.log(Level.WARNING, "Notification failed: ", ex);
                        }
                    }
                });
            }
            catch (PipelineFullException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    protected void notify0(CometEvent cometEvent, CometHandler cometHandler) throws IOException {
        if (!cometEvent.getCometContext().isActive(cometHandler)) {
            return;
        }
        switch (cometEvent.getType()) {
            case 0: {
                cometHandler.onInterrupt(cometEvent);
                break;
            }
            case 1: {
                cometHandler.onEvent(cometEvent);
                break;
            }
            case 4: {
                cometHandler.onEvent(cometEvent);
                break;
            }
            case 5: {
                cometHandler.onEvent(cometEvent);
                break;
            }
            case 2: {
                cometHandler.onInitialize(cometEvent);
                break;
            }
            case 3: {
                cometHandler.onTerminate(cometEvent);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

