/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.util.State;
import com.sun.grizzly.util.StateHolder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorHandlerRunner
implements Runnable {
    private final SelectorHandler selectorHandler;
    private final Controller controller;

    public SelectorHandlerRunner(Controller controller, SelectorHandler selectorHandler) {
        this.controller = controller;
        this.selectorHandler = selectorHandler;
    }

    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StateHolder<State> controllerStateHolder = this.controller.getStateHolder();
        StateHolder<State> selectorHandlerStateHolder = this.selectorHandler.getStateHolder();
        try {
            this.selectorHandler.getStateHolder().setState(State.STARTED);
            while (controllerStateHolder.getState(false) != State.STOPPED && selectorHandlerStateHolder.getState(false) != State.STOPPED) {
                Object var10_9;
                State controllerState = controllerStateHolder.getState(false);
                State selectorHandlerState = (State)((Object)selectorHandlerStateHolder.getState(false));
                if (controllerState != State.PAUSED && selectorHandlerState != State.PAUSED) {
                    this.controller.doSelect(this.selectorHandler);
                    continue;
                }
                CountDownLatch latch = new CountDownLatch(1);
                StateHolder.ConditionListener<State> controllerConditionListener = this.registerForNotification(controllerState, controllerStateHolder, latch);
                StateHolder.ConditionListener<State> selectorHandlerConditionListener = this.registerForNotification(selectorHandlerState, selectorHandlerStateHolder, latch);
                try {
                    try {
                        latch.await(5000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        var10_9 = null;
                        controllerStateHolder.removeConditionListener(controllerConditionListener);
                        selectorHandlerStateHolder.removeConditionListener(selectorHandlerConditionListener);
                        continue;
                    }
                    var10_9 = null;
                    controllerStateHolder.removeConditionListener(controllerConditionListener);
                    selectorHandlerStateHolder.removeConditionListener(selectorHandlerConditionListener);
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    controllerStateHolder.removeConditionListener(controllerConditionListener);
                    selectorHandlerStateHolder.removeConditionListener(selectorHandlerConditionListener);
                    throw throwable;
                }
            }
            Object var12_11 = null;
            this.selectorHandler.shutdown();
            this.controller.notifyStopped();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.selectorHandler.shutdown();
            this.controller.notifyStopped();
            throw throwable;
        }
    }

    private StateHolder.ConditionListener<State> registerForNotification(State currentState, StateHolder<State> stateHolder, CountDownLatch latch) {
        if (currentState == State.PAUSED) {
            return stateHolder.notifyWhenStateIsNotEqual(State.PAUSED, latch);
        }
        return stateHolder.notifyWhenStateIsEqual(State.STOPPED, latch);
    }
}

