/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.SelectionKeyAttachment;
import com.sun.grizzly.util.ThreadAttachment;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorThreadKeyHandler
extends DefaultSelectionKeyHandler {
    private SelectorThread selectorThread;
    private boolean disableOptimization = false;

    public SelectorThreadKeyHandler() {
    }

    public SelectorThreadKeyHandler(SelectorThread selectorThread) {
        this.selectorThread = selectorThread;
    }

    @Override
    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        SelectorThreadKeyHandler copyHandler = (SelectorThreadKeyHandler)copy;
        copyHandler.selectorThread = this.selectorThread;
    }

    @Override
    public void doRegisterKey(SelectionKey key, int ops, long currentTime) {
        if (!key.isValid() || !this.selectorThread.getKeepAliveCounter().trap(key)) {
            this.selectorThread.cancelKey(key);
            return;
        }
        if (this.selectorThread.getEnableAsyncExecution() && key.attachment() instanceof String) {
            key.attach(null);
            return;
        }
        if (key.isValid()) {
            key.interestOps(key.interestOps() | ops);
            Object attachment = key.attachment();
            if (attachment == null) {
                key.attach(currentTime);
            } else if (attachment instanceof ThreadAttachment) {
                ((ThreadAttachment)attachment).setTimeout(currentTime);
            }
        }
    }

    @Override
    public void cancel(SelectionKey key) {
        if (key != null) {
            this.selectorThread.getKeepAliveCounter().untrap(key);
        }
        if (this.selectorThread.isMonitoringEnabled()) {
            this.selectorThread.getRequestGroupInfo().decreaseCountOpenConnections();
        }
        super.cancel(key);
    }

    public void addBannedSelectionKey(SelectionKey key) {
        key.attach("banned");
    }

    public void resetExpiration() {
        this.disableOptimization = true;
    }

    @Override
    public void expire(Iterator<SelectionKey> iterator) {
        if (this.timeout <= 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (!this.disableOptimization && currentTime < this.nextKeysExpiration) {
            return;
        }
        this.nextKeysExpiration = currentTime + this.timeout;
        while (iterator.hasNext()) {
            Long expire;
            SelectionKey key = iterator.next();
            if (!key.isValid() || (expire = this.getExpirationStamp(key)) == null) continue;
            if (currentTime - expire >= this.timeout) {
                Object attachment = key.attachment();
                if (attachment != null) {
                    if (attachment instanceof Response.ResponseAttachment) {
                        ((Response.ResponseAttachment)attachment).timeout();
                        key.attach(null);
                        continue;
                    }
                    this.cancel(key);
                    continue;
                }
                this.cancel(key);
                continue;
            }
            if (expire + this.timeout >= this.nextKeysExpiration) continue;
            this.nextKeysExpiration = expire + this.timeout;
        }
    }

    private Long getExpirationStamp(SelectionKey key) {
        block6: {
            Object attachment = key.attachment();
            if (attachment != null) {
                try {
                    if (attachment instanceof Long) {
                        return (Long)attachment;
                    }
                    if (attachment instanceof SelectionKeyAttachment) {
                        return ((SelectionKeyAttachment)attachment).getTimeout();
                    }
                    if (attachment instanceof Response.ResponseAttachment) {
                        return ((Response.ResponseAttachment)attachment).getExpirationTime() - this.timeout;
                    }
                }
                catch (ClassCastException ex) {
                    if (!this.logger.isLoggable(Level.FINEST)) break block6;
                    this.logger.log(Level.FINEST, "Invalid SelectionKey attachment", ex);
                }
            }
        }
        return null;
    }
}

