/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp;

import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.FileOutputBuffer;
import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.http.HtmlHelper;
import com.sun.grizzly.util.http.MimeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StaticResourcesAdapter
implements Adapter {
    private static final String USE_SEND_FILE = "com.sun.grizzly.useSendFile";
    protected String rootFolder = ".";
    protected String resourcesContextPath = "";
    protected File webDir = null;
    protected ConcurrentHashMap<String, File> cache = new ConcurrentHashMap();
    protected Logger logger = LoggerUtils.getLogger();
    private boolean useSendFile = true;
    protected boolean commitErrorResponse = true;
    private ReentrantLock initializedLock = new ReentrantLock();

    public StaticResourcesAdapter() {
        this(".");
    }

    public StaticResourcesAdapter(String rootFolder) {
        this.rootFolder = rootFolder;
        if (System.getProperty("os.name").equalsIgnoreCase("linux") && !System.getProperty("java.version").startsWith("1.7")) {
            this.useSendFile = false;
        }
        if (System.getProperty(USE_SEND_FILE) != null) {
            this.useSendFile = Boolean.valueOf(System.getProperty(USE_SEND_FILE));
            this.logger.info("Send-file enabled:" + this.useSendFile);
        }
    }

    public void service(Request req, Response res) throws Exception {
        String uri = req.requestURI().toString();
        if (uri.indexOf("..") >= 0 || !uri.startsWith(this.resourcesContextPath)) {
            res.setStatus(404);
            if (this.commitErrorResponse) {
                this.customizedErrorPage(req, res);
            }
            return;
        }
        if (uri.indexOf(".") != -1) {
            uri = uri.substring(this.resourcesContextPath.length());
        }
        this.service(uri, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(String uri, Request req, Response res) throws Exception {
        FileInputStream fis = null;
        try {
            this.initWebDir();
            File resource = this.cache.get(uri);
            if (resource == null) {
                resource = new File(this.webDir, uri);
                this.cache.put(uri, resource);
            }
            if (resource.isDirectory()) {
                req.action(ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE, null);
                res.setStatus(302);
                res.setMessage("Moved Temporarily");
                res.setHeader("Location", req.scheme() + "://" + req.serverName() + ":" + req.getServerPort() + "/index.html");
                res.setHeader("Connection", "close");
                res.setHeader("Cache-control", "private");
                res.sendHeaders();
                return;
            }
            if (!resource.exists()) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "File not found  " + resource);
                }
                res.setStatus(404);
                if (this.commitErrorResponse) {
                    this.customizedErrorPage(req, res);
                }
                return;
            }
            res.setStatus(200);
            int dot = uri.lastIndexOf(".");
            if (dot > 0) {
                String ext = uri.substring(dot + 1);
                String ct = MimeType.get(ext);
                if (ct != null) {
                    res.setContentType(ct);
                }
            } else {
                res.setContentType(MimeType.get("html"));
            }
            long length = resource.length();
            res.setContentLengthLong(length);
            res.sendHeaders();
            fis = new FileInputStream(resource);
            OutputBuffer outputBuffer = res.getOutputBuffer();
            if (this.useSendFile && outputBuffer instanceof FileOutputBuffer && ((FileOutputBuffer)((Object)outputBuffer)).isSupportFileSend()) {
                res.flush();
                for (long nWrite = 0L; nWrite < length; nWrite += ((FileOutputBuffer)((Object)outputBuffer)).sendFile(fis.getChannel(), nWrite, length - nWrite)) {
                }
            } else {
                byte[] b = new byte[8192];
                ByteChunk chunk = new ByteChunk();
                int rd = 0;
                while ((rd = fis.read(b)) > 0) {
                    chunk.setBytes(b, 0, rd);
                    res.doWrite(chunk);
                }
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    protected void customizedErrorPage(Request req, Response res) throws Exception {
        res.setMessage("Not Found");
        ByteBuffer bb = HtmlHelper.getErrorPage("Not Found", "HTTP/1.1 404 Not Found\r\n", "Grizzly");
        res.setContentLength(bb.limit());
        res.setContentType("text/html");
        res.flushHeaders();
        res.getChannel().write(bb);
        req.setNote(14, "SkipAfterService");
    }

    public void afterService(Request req, Response res) throws Exception {
        if (req.getNote(14) != null) {
            req.setNote(14, null);
            return;
        }
        if (res.getStatus() == 404 && !this.commitErrorResponse) {
            return;
        }
        try {
            req.action(ActionCode.ACTION_POST_REQUEST, null);
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "afterService unexpected exception: ", t);
        }
        res.finish();
        req.recycle();
        res.recycle();
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWebDir() {
        if (this.webDir == null) {
            try {
                this.initializedLock.lock();
                this.webDir = new File(this.rootFolder);
                try {
                    this.rootFolder = this.webDir.getCanonicalPath();
                }
                catch (IOException e) {
                    this.logger.log(Level.WARNING, "service()", e);
                }
            }
            finally {
                this.initializedLock.unlock();
            }
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isUseSendFile() {
        return this.useSendFile;
    }

    public void setUseSendFile(boolean useSendFile) {
        this.useSendFile = useSendFile;
    }

    public String getResourcesContextPath() {
        return this.resourcesContextPath;
    }

    public void setResourcesContextPath(String resourcesContextPath) {
        this.resourcesContextPath = resourcesContextPath;
    }
}

