/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class GrizzlyAdapterChain
extends GrizzlyAdapter {
    private UDecoder urlDecoder = new UDecoder();
    protected static final int MAPPING_DATA = 12;
    protected static final int MAPPED_ADAPTER = 13;
    private ConcurrentHashMap<GrizzlyAdapter, String[]> adapters = new ConcurrentHashMap();
    private Mapper mapper = new Mapper();
    private static final String LOCAL_HOST = "localhost";
    private boolean oldMappingAlgorithm = false;

    public GrizzlyAdapterChain() {
        this.mapper.setDefaultHostName(LOCAL_HOST);
        this.setHandleStaticResources(false);
        this.setDecodeUrl(false);
    }

    public void start() {
        for (Map.Entry<GrizzlyAdapter, String[]> entry : this.adapters.entrySet()) {
            entry.getKey().start();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        if (this.oldMappingAlgorithm) {
            int i = 0;
            int size = this.adapters.size();
            for (Map.Entry<GrizzlyAdapter, String[]> entry : this.adapters.entrySet()) {
                entry.getKey().service(request, response);
                if (response.getStatus() != 404 || i == size - 1) return;
                response.setStatus(200, "OK");
            }
            return;
        } else {
            Request req = request.getRequest();
            MappingData mappingData = null;
            try {
                MessageBytes decodedURI = req.decodedURI();
                decodedURI.duplicate(req.requestURI());
                mappingData = (MappingData)req.getNote(12);
                if (mappingData == null) {
                    mappingData = new MappingData();
                    req.setNote(12, mappingData);
                } else {
                    mappingData.recycle();
                }
                ByteChunk uriBB = decodedURI.getByteChunk();
                int semicolon = uriBB.indexOf(';', 0);
                if (semicolon > 0) {
                    decodedURI.setBytes(uriBB.getBuffer(), uriBB.getStart(), semicolon);
                }
                HttpRequestURIDecoder.decode(decodedURI, this.urlDecoder, null, null);
                if (mappingData == null) {
                    mappingData = (MappingData)req.getNote(12);
                }
                this.mapper.map(req.serverName(), decodedURI, mappingData);
                GrizzlyAdapter adapter = null;
                if (mappingData.context != null && mappingData.context instanceof GrizzlyAdapter) {
                    adapter = (GrizzlyAdapter)mappingData.context;
                    adapter.setDecodeUrl(false);
                    adapter.service(request.getRequest(), response.getResponse());
                    return;
                }
                response.getResponse().setStatus(404);
                this.customizedErrorPage(req, response.getResponse());
                return;
            }
            catch (Throwable t) {
                try {
                    response.setStatus(404);
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "Invalid URL: " + req.decodedURI(), t);
                    }
                    this.customizedErrorPage(req, response.getResponse());
                    return;
                }
                catch (Exception ex2) {
                    if (!this.logger.isLoggable(Level.WARNING)) return;
                    this.logger.log(Level.WARNING, "Unable to error page", ex2);
                }
            }
        }
    }

    public void addGrizzlyAdapter(GrizzlyAdapter adapter) {
        this.oldMappingAlgorithm = true;
        this.adapters.put(adapter, new String[]{""});
    }

    public void addGrizzlyAdapter(GrizzlyAdapter adapter, String[] mappings) {
        if (this.oldMappingAlgorithm) {
            throw new IllegalStateException("Cannot mix addGrizzlyAdapter(GrizzlyAdapter) and addGrizzlyAdapter(GrizzlyAdapter,String[]");
        }
        if (mappings.length == 0) {
            this.addGrizzlyAdapter(adapter);
        } else {
            this.adapters.put(adapter, mappings);
            for (String mapping : mappings) {
                this.mapper.addContext(LOCAL_HOST, mapping, adapter, null, null);
            }
        }
    }

    public void destroy() {
        for (Map.Entry<GrizzlyAdapter, String[]> adapter : this.adapters.entrySet()) {
            adapter.getKey().destroy();
        }
    }

    public boolean removeAdapter(GrizzlyAdapter adapter) {
        if (adapter == null) {
            throw new IllegalStateException();
        }
        String[] mappings = this.adapters.remove(adapter);
        if (mappings != null) {
            for (String mapping : mappings) {
                this.mapper.removeContext(LOCAL_HOST, mapping);
            }
            adapter.destroy();
        }
        return mappings != null;
    }
}

