/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.http;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public final class FastHttpDateFormat {
    protected static final int CACHE_SIZE = Integer.parseInt(System.getProperty("com.sun.grizzly.util.http.FastHttpDateFormat.CACHE_SIZE", "1000"));
    protected static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final SimpleDateFormat format2 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    protected static volatile long nextGeneration;
    protected static volatile String currentDate;
    protected static final ConcurrentHashMap<Long, String> formatCache;
    protected static final ConcurrentHashMap<String, Long> parseCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getCurrentDate() {
        long now = System.currentTimeMillis();
        if (now > nextGeneration) {
            SimpleDateFormat simpleDateFormat = format;
            synchronized (simpleDateFormat) {
                if (now > nextGeneration) {
                    nextGeneration = now + 1000L;
                    currentDate = format.format(new Date(now));
                }
            }
        }
        return currentDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String formatDate(long value, DateFormat threadLocalformat) {
        Long longValue = value = value / 1000L * 1000L;
        String cachedDate = formatCache.get(longValue);
        if (cachedDate != null) {
            return cachedDate;
        }
        String newDate = null;
        Date dateValue = new Date(value);
        if (threadLocalformat != null) {
            newDate = threadLocalformat.format(dateValue);
        } else {
            SimpleDateFormat simpleDateFormat = format2;
            synchronized (simpleDateFormat) {
                newDate = format2.format(dateValue);
            }
        }
        FastHttpDateFormat.updateFormatCache(longValue, newDate);
        return newDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static final long parseDate(String value, DateFormat[] threadLocalformats) {
        long date;
        Long cachedDate = parseCache.get(value);
        if (cachedDate != null) {
            return cachedDate;
        }
        if (threadLocalformats != null) {
            date = FastHttpDateFormat.internalParseDate(value, threadLocalformats);
        } else {
            SimpleDateFormat[] simpleDateFormatArray = formats;
            // MONITORENTER : formats
            date = FastHttpDateFormat.internalParseDate(value, formats);
            // MONITOREXIT : simpleDateFormatArray
        }
        if (date == -1L) return date;
        FastHttpDateFormat.updateParseCache(value, date);
        return date;
    }

    private static final long internalParseDate(String value, DateFormat[] formats) {
        int i = 0;
        if (i < formats.length) {
            try {
                return formats[i].parse(value).getTime();
            }
            catch (ParseException e) {
                return -1L;
            }
        }
        return -1L;
    }

    private static void updateFormatCache(Long key, String value) {
        if (value == null) {
            return;
        }
        if (formatCache.size() > CACHE_SIZE) {
            formatCache.clear();
        }
        formatCache.put(key, value);
    }

    private static void updateParseCache(String key, Long value) {
        if (parseCache.size() > CACHE_SIZE) {
            parseCache.clear();
        }
        parseCache.put(key, value);
    }

    static {
        format.setTimeZone(gmtZone);
        format2.setTimeZone(gmtZone);
        formats[0].setTimeZone(gmtZone);
        formats[1].setTimeZone(gmtZone);
        formats[2].setTimeZone(gmtZone);
        formatCache = new ConcurrentHashMap(CACHE_SIZE, 0.75f, 64);
        parseCache = new ConcurrentHashMap(CACHE_SIZE, 0.75f, 64);
    }
}

