/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.launcher.web;

import com.sun.grizzly.arp.AsyncWebFilter;
import com.sun.grizzly.arp.AsyncWebFilterConfig;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.http.WebFilter;
import com.sun.grizzly.http.WebFilterConfig;
import com.sun.grizzly.standalone.StandaloneMainUtil;
import com.sun.grizzly.standalone.StaticHandler;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.ClassLoaderUtil;

public class Main
extends StandaloneMainUtil {
    private static final String ADAPTER = "com.sun.grizzly.adapter";
    private static final String ENABLE_ASYNC = "com.sun.grizzly.enableARP";
    static int port = 8080;
    static String folder = ".";

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        main.start(args);
    }

    public WebFilter createWebFilter(String[] args) throws Exception {
        if (args.length == 0) {
            this.printHelpAndExit();
        }
        this.parseOptions(args);
        String appliPath = this.parseApplicationLocation(args);
        appliPath = this.appendWarContentToClassPath(appliPath);
        AsyncWebFilterConfig webConfig = new AsyncWebFilterConfig();
        webConfig.setAdapter(this.configureAdapter(webConfig));
        webConfig.setDisplayConfiguration(true);
        webConfig.setWebAppRootPath(appliPath);
        AsyncWebFilter webFilter = new AsyncWebFilter("MyHtttpServer", webConfig);
        webConfig.setInterceptor(new StaticHandler(webFilter));
        boolean enableAsync = Boolean.valueOf(System.getProperty(ENABLE_ASYNC));
        webConfig.setAsyncEnabled(enableAsync);
        if (enableAsync) {
            webConfig.setAsyncHandler(new DefaultAsyncHandler());
        }
        return webFilter;
    }

    public void printHelpAndExit() {
        System.err.println("Usage: " + Main.class.getCanonicalName() + " [options]");
        System.err.println();
        System.err.println("    -p, --port=port                  Server file on the specified port.");
        System.err.println("                                     Default: 8080");
        System.err.println("    -a, --apps=application path      The static resourde folder or jar or war location.");
        System.err.println("                                     Default: .");
        System.err.println("    -h, --help                       Show this help message.");
        System.exit(1);
    }

    public boolean parseOptions(String[] args) {
        if (args.length == 0) {
            this.printHelpAndExit();
            return false;
        }
        for (int i = 0; i < args.length - 1; ++i) {
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                this.printHelpAndExit();
                continue;
            }
            if ("-a".equals(arg)) {
                folder = args[++i];
                continue;
            }
            if (arg.startsWith("--application=")) {
                folder = arg.substring("--application=".length(), arg.length());
                continue;
            }
            if ("-p".equals(arg)) {
                this.setPort(args[++i]);
                continue;
            }
            if (!arg.startsWith("--port=")) continue;
            String num = arg.substring("--port=".length(), arg.length());
            this.setPort(num);
        }
        return true;
    }

    public Adapter configureAdapter(WebFilterConfig wf) {
        String adapterClass = System.getProperty(ADAPTER);
        Adapter adapter = adapterClass == null ? new StaticResourcesAdapter(folder) : (Adapter)ClassLoaderUtil.load(adapterClass);
        if (adapter instanceof StaticResourcesAdapter) {
            ((StaticResourcesAdapter)adapter).setRootFolder(folder);
        }
        return adapter;
    }

    public String parseApplicationLocation(String[] args) {
        return folder;
    }
}

