/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.tmpselectors;

import com.sun.grizzly.AbstractReader;
import com.sun.grizzly.Buffer;
import com.sun.grizzly.CompletionHandler;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.Interceptor;
import com.sun.grizzly.ReadResult;
import com.sun.grizzly.Transport;
import com.sun.grizzly.impl.ReadyFutureImpl;
import com.sun.grizzly.nio.NIOConnection;
import com.sun.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public abstract class TemporarySelectorReader
extends AbstractReader<SocketAddress> {
    private static final int DEFAULT_TIMEOUT = 30000;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected int defaultBufferSize = 8192;
    protected final TemporarySelectorsEnabledTransport transport;
    private Logger logger = Grizzly.logger;
    private int timeoutMillis = 30000;

    public TemporarySelectorReader(TemporarySelectorsEnabledTransport transport) {
        this.transport = transport;
    }

    public int getTimeout() {
        return this.timeoutMillis;
    }

    public void setTimeout(int timeout) {
        this.timeoutMillis = timeout;
    }

    @Override
    public Future<ReadResult<Buffer, SocketAddress>> read(Connection connection, Buffer buffer, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler, Interceptor<ReadResult> interceptor) throws IOException {
        return this.read(connection, buffer, completionHandler, interceptor, this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public Future<ReadResult<Buffer, SocketAddress>> read(Connection connection, Buffer buffer, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler, Interceptor<ReadResult> interceptor, long timeout, TimeUnit timeunit) throws IOException {
        if (connection == null || !(connection instanceof NIOConnection)) {
            throw new IllegalStateException("Connection should be NIOConnection and cannot be null.");
        }
        ReadResult<Buffer, Object> currentResult = new ReadResult<Buffer, Object>(connection, buffer, null, 0);
        ReadyFutureImpl<ReadResult<Buffer, SocketAddress>> currentFuture = new ReadyFutureImpl<ReadResult<Buffer, SocketAddress>>(currentResult);
        if (buffer == null) {
            buffer = this.acquireBuffer(connection);
        }
        boolean isCompleted = false;
        while (!isCompleted) {
            isCompleted = true;
            int readBytes = this.read0(connection, currentResult, buffer, timeout, timeunit);
            if (readBytes <= 0) {
                currentFuture.failure(new TimeoutException());
                continue;
            }
            if (interceptor == null) continue;
            isCompleted = (interceptor.intercept(1, null, currentResult) & 1) != 0;
        }
        if (completionHandler != null) {
            completionHandler.completed(connection, currentResult);
        }
        if (interceptor != null) {
            interceptor.intercept(this.timeoutMillis, connection, currentResult);
        }
        return currentFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int read0(Connection connection, ReadResult currentResult, Buffer buffer, long timeout, TimeUnit timeunit) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        Selector readSelector = null;
        SelectionKey key = null;
        SelectableChannel channel = nioConnection.getChannel();
        long readTimeout = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        try {
            int bytesRead = this.readNow0(connection, buffer, currentResult);
            if (bytesRead == 0) {
                readSelector = this.transport.getTemporarySelectorIO().getSelectorPool().poll();
                if (readSelector == null) {
                    int n = bytesRead;
                    this.transport.getTemporarySelectorIO().recycleTemporaryArtifacts(readSelector, key);
                    return n;
                }
                key = channel.register(readSelector, 1);
                key.interestOps(key.interestOps() | 1);
                int code = readSelector.select(readTimeout);
                key.interestOps(key.interestOps() & 0xFFFFFFFE);
                if (code == 0) {
                    int n = bytesRead;
                    this.transport.getTemporarySelectorIO().recycleTemporaryArtifacts(readSelector, key);
                    return n;
                }
                bytesRead = this.readNow0(connection, buffer, currentResult);
            }
            if (bytesRead == -1) {
                throw new EOFException();
            }
            this.transport.getTemporarySelectorIO().recycleTemporaryArtifacts(readSelector, key);
            return bytesRead;
        }
        catch (Throwable throwable) {
            this.transport.getTemporarySelectorIO().recycleTemporaryArtifacts(readSelector, key);
            throw throwable;
        }
    }

    protected abstract int readNow0(Connection var1, Buffer var2, ReadResult var3) throws IOException;

    protected Buffer acquireBuffer(Connection connection) {
        Transport connectionTransport = connection.getTransport();
        return connectionTransport.getMemoryManager().allocate(this.defaultBufferSize);
    }

    private void releaseBuffer(Connection connection, Buffer inputBuffer) {
        Transport connectionTransport = connection.getTransport();
        connectionTransport.getMemoryManager().release(inputBuffer);
    }

    public TemporarySelectorsEnabledTransport getTransport() {
        return this.transport;
    }
}

