/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.tmpselectors;

import com.sun.grizzly.AbstractWriter;
import com.sun.grizzly.Buffer;
import com.sun.grizzly.CompletionHandler;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.Interceptor;
import com.sun.grizzly.WriteResult;
import com.sun.grizzly.impl.ReadyFutureImpl;
import com.sun.grizzly.nio.NIOConnection;
import com.sun.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public abstract class TemporarySelectorWriter
extends AbstractWriter<SocketAddress> {
    private static final int DEFAULT_TIMEOUT = 30000;
    private Logger logger = Grizzly.logger;
    protected final TemporarySelectorsEnabledTransport transport;
    private int timeoutMillis = 30000;

    public TemporarySelectorWriter(TemporarySelectorsEnabledTransport transport) {
        this.transport = transport;
    }

    public int getTimeout() {
        return this.timeoutMillis;
    }

    public void setTimeout(int timeout) {
        this.timeoutMillis = timeout;
    }

    @Override
    public Future<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult> interceptor) throws IOException {
        return this.write(connection, dstAddress, buffer, completionHandler, interceptor, this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public Future<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult> interceptor, long timeout, TimeUnit timeunit) throws IOException {
        if (buffer == null) {
            throw new IllegalStateException("Message cannot be null.");
        }
        if (connection == null || !(connection instanceof NIOConnection)) {
            throw new IllegalStateException("Connection should be NIOConnection and cannot be null.");
        }
        WriteResult<Buffer, SocketAddress> writeResult = new WriteResult<Buffer, SocketAddress>(connection, buffer, dstAddress, 0);
        this.write0(connection, dstAddress, buffer, writeResult, timeout, timeunit);
        writeResult.setMessage(buffer);
        ReadyFutureImpl<WriteResult<Buffer, SocketAddress>> writeFuture = new ReadyFutureImpl<WriteResult<Buffer, SocketAddress>>(writeResult);
        if (completionHandler != null) {
            completionHandler.completed(connection, writeResult);
        }
        return writeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int write0(Connection connection, SocketAddress dstAddress, Buffer buffer, WriteResult currentResult, long timeout, TimeUnit timeunit) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        SelectableChannel channel = nioConnection.getChannel();
        long writeTimeout = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        int bytesWritten = 0;
        try {
            while (buffer.hasRemaining()) {
                int len = this.writeNow0(connection, dstAddress, buffer, currentResult);
                if (len > 0) {
                    attempts = 0;
                    bytesWritten += len;
                    continue;
                }
                ++attempts;
                if (writeSelector == null) {
                    writeSelector = this.transport.getTemporarySelectorIO().getSelectorPool().poll();
                    if (writeSelector == null) continue;
                    key = channel.register(writeSelector, 4);
                }
                if (writeSelector.select(writeTimeout) != 0 || attempts <= 2) continue;
                throw new IOException("Client disconnected");
            }
        }
        finally {
            this.transport.getTemporarySelectorIO().recycleTemporaryArtifacts(writeSelector, key);
        }
        return bytesWritten;
    }

    public TemporarySelectorsEnabledTransport getTransport() {
        return this.transport;
    }

    protected abstract int writeNow0(Connection var1, SocketAddress var2, Buffer var3, WriteResult var4) throws IOException;
}

