/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.transport;

import com.sun.grizzly.AbstractSocketConnectorHandler;
import com.sun.grizzly.Connection;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.impl.ReadyFutureImpl;
import com.sun.grizzly.nio.RegisterChannelResult;
import com.sun.grizzly.nio.transport.UDPNIOConnection;
import com.sun.grizzly.nio.transport.UDPNIOTransport;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class UDPNIOConnectorHandler
extends AbstractSocketConnectorHandler {
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    protected boolean isReuseAddress;
    protected int connectionTimeout = 30000;

    public UDPNIOConnectorHandler(UDPNIOTransport transport) {
        super(transport);
        UDPNIOTransport nioTransport = transport;
        this.connectionTimeout = nioTransport.getConnectionTimeout();
        this.isReuseAddress = nioTransport.isReuseAddress();
    }

    public Future<Connection> connect() throws IOException {
        return this.connect(null, null);
    }

    @Override
    public Future<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        if (!this.transport.isBlocking()) {
            return this.connectAsync(remoteAddress, localAddress);
        }
        return this.connectSync(remoteAddress, localAddress);
    }

    protected Future<Connection> connectSync(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        Future<Connection> future = this.connectAsync(remoteAddress, localAddress);
        this.waitNIOFuture(future);
        return future;
    }

    protected Future<Connection> connectAsync(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        DatagramChannel datagramChannel = DatagramChannel.open();
        DatagramSocket socket = datagramChannel.socket();
        socket.setReuseAddress(this.isReuseAddress);
        if (localAddress != null) {
            socket.bind(localAddress);
        }
        datagramChannel.configureBlocking(false);
        UDPNIOTransport nioTransport = (UDPNIOTransport)this.transport;
        UDPNIOConnection newConnection = (UDPNIOConnection)nioTransport.obtainNIOConnection(datagramChannel);
        if (remoteAddress != null) {
            datagramChannel.connect(remoteAddress);
        }
        newConnection.setProcessor(this.defaultProcessor);
        newConnection.setProcessorSelector(this.defaultProcessorSelector);
        Future<RegisterChannelResult> registerChannelFuture = nioTransport.getNioChannelDistributor().registerChannelAsync(datagramChannel, 1, newConnection, null);
        RegisterChannelResult result = this.waitNIOFuture(registerChannelFuture);
        nioTransport.registerChannelCompletionHandler.completed((Connection)null, result);
        this.transport.fireIOEvent(IOEvent.CONNECTED, newConnection);
        return new ReadyFutureImpl<Connection>(newConnection);
    }

    public boolean isReuseAddress() {
        return this.isReuseAddress;
    }

    public void setReuseAddress(boolean isReuseAddress) {
        this.isReuseAddress = isReuseAddress;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    protected <E> E waitNIOFuture(Future<E> future) throws IOException {
        try {
            return future.get(this.connectionTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException("Connection was interrupted!");
        }
        catch (TimeoutException e) {
            throw new IOException("Channel registration on Selector timeout!");
        }
        catch (ExecutionException e) {
            Throwable internalException = e.getCause();
            if (internalException instanceof IOException) {
                throw (IOException)internalException;
            }
            throw new IOException("Unexpected exception connection exception. " + internalException.getClass().getName() + ": " + internalException.getMessage());
        }
        catch (CancellationException e) {
            throw new IOException("Connection was cancelled!");
        }
    }
}

