/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.transport;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.CompletionHandler;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Interceptor;
import com.sun.grizzly.ReadResult;
import com.sun.grizzly.impl.FutureImpl;
import com.sun.grizzly.impl.ReadyFutureImpl;
import com.sun.grizzly.nio.tmpselectors.TemporarySelectorReader;
import com.sun.grizzly.nio.transport.UDPNIOConnection;
import com.sun.grizzly.nio.transport.UDPNIOTransport;
import com.sun.grizzly.streams.AbstractStreamReader;
import com.sun.grizzly.streams.AddressableStreamReader;
import com.sun.grizzly.streams.StreamReader;
import com.sun.grizzly.utils.conditions.Condition;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class UDPNIOStreamReader
extends AbstractStreamReader
implements AddressableStreamReader<SocketAddress> {
    public UDPNIOStreamReader(UDPNIOConnection connection) {
        super(connection);
    }

    @Override
    public Future<Integer> notifyCondition(Condition<StreamReader> condition, CompletionHandler<Integer> completionHandler) {
        if (this.notifyObject != null) {
            throw new IllegalStateException("Only one available listener allowed!");
        }
        if (this.isClosed()) {
            EOFException exception = new EOFException();
            if (completionHandler != null) {
                completionHandler.failed(null, exception);
            }
            return new ReadyFutureImpl<Integer>(exception);
        }
        int availableDataSize = this.availableDataSize();
        if (condition.check(this)) {
            if (completionHandler != null) {
                completionHandler.completed(null, availableDataSize);
            }
            return new ReadyFutureImpl<Integer>(availableDataSize);
        }
        if (this.isBlocking()) {
            return this.notifyConditionBlocking(condition, completionHandler);
        }
        return this.notifyConditionNonBlocking(condition, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Integer> notifyConditionNonBlocking(Condition<StreamReader> condition, CompletionHandler<Integer> completionHandler) {
        final FutureImpl<Integer> future = new FutureImpl<Integer>(this.sync);
        Object object = this.sync;
        synchronized (object) {
            try {
                this.notifyObject = new AbstractStreamReader.NotifyObject(future, completionHandler, condition);
                Connection connection = this.getConnection();
                UDPNIOTransport transport = (UDPNIOTransport)connection.getTransport();
                transport.getAsyncQueueIO().getReader().read(connection, null, null, new Interceptor(){

                    public int intercept(int event, Object context, Object result) {
                        if (event == 1) {
                            ReadResult readResult = (ReadResult)result;
                            Buffer buffer = (Buffer)readResult.getMessage();
                            if (buffer == null) {
                                return 2;
                            }
                            buffer.flip();
                            UDPNIOStreamReader.this.append(readResult);
                            if (future.isDone()) {
                                return 1;
                            }
                            return 6;
                        }
                        return 0;
                    }
                });
            }
            catch (IOException e) {
                future.failure(e);
            }
        }
        return future;
    }

    private Future<Integer> notifyConditionBlocking(Condition<StreamReader> condition, CompletionHandler<Integer> completionHandler) {
        FutureImpl<Integer> future = new FutureImpl<Integer>();
        this.notifyObject = new AbstractStreamReader.NotifyObject(future, completionHandler, condition);
        try {
            while (!future.isDone()) {
                ReadResult data = this.read0();
                this.append(data);
            }
        }
        catch (Exception e) {
            future.failure(e);
        }
        return future;
    }

    @Override
    protected ReadResult read0() throws IOException {
        Connection connection = this.getConnection();
        UDPNIOTransport transport = (UDPNIOTransport)connection.getTransport();
        Buffer buffer = this.newBuffer(this.bufferSize);
        if (this.isBlocking()) {
            ReadResult<Buffer, SocketAddress> result;
            try {
                TemporarySelectorReader reader = (TemporarySelectorReader)transport.getTemporarySelectorIO().getReader();
                Future<ReadResult<Buffer, SocketAddress>> future = reader.read(connection, buffer, null, null, this.timeoutMillis, TimeUnit.MILLISECONDS);
                result = future.get();
                buffer.trim();
            }
            catch (Exception e) {
                buffer.dispose();
                throw new EOFException();
            }
            return result;
        }
        ReadResult result = new ReadResult(connection);
        try {
            int readBytes = transport.read(connection, buffer, result);
            if (readBytes <= 0) {
                if (readBytes == -1) {
                    throw new EOFException();
                }
                buffer.dispose();
                return null;
            }
            buffer.trim();
        }
        catch (IOException e) {
            buffer.dispose();
            throw e;
        }
        return result;
    }

    @Override
    public SocketAddress getPeerAddress() {
        UDPNIOConnection connection = (UDPNIOConnection)this.getConnection();
        if (connection.isConnected()) {
            return connection.getPeerAddress();
        }
        ReadResult current = (ReadResult)this.current();
        if (current != null) {
            return (SocketAddress)current.getSrcAddress();
        }
        return null;
    }

    @Override
    protected final boolean append(Object data) {
        return super.append(data);
    }

    @Override
    protected Object wrap(Buffer buffer) {
        if (buffer == null) {
            return null;
        }
        return new ReadResult<Buffer, Object>(this.getConnection(), buffer, null, buffer.remaining());
    }

    @Override
    protected Buffer unwrap(Object record) {
        if (record == null) {
            return null;
        }
        return (Buffer)((ReadResult)record).getMessage();
    }
}

