/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.smart.transformers;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.TransformationException;
import com.sun.grizzly.TransformationResult;
import com.sun.grizzly.Transformer;
import com.sun.grizzly.attributes.AttributeStorage;
import com.sun.grizzly.memory.MemoryManager;
import com.sun.grizzly.smart.SmartTransformer;
import com.sun.grizzly.smart.annotations.Sequence;
import com.sun.grizzly.smart.transformers.AbstractSmartMemberEncoder;
import java.lang.reflect.Field;

public abstract class SequenceEncoder<E>
extends AbstractSmartMemberEncoder<E> {
    protected Sequence config;
    protected Class componentType;
    protected Transformer componentEncoder;

    protected abstract Object get(AttributeStorage var1, E var2);

    protected abstract boolean next(AttributeStorage var1, E var2);

    protected abstract boolean previous(AttributeStorage var1, E var2);

    protected abstract int size(AttributeStorage var1, E var2);

    @Override
    public void initialize(SmartTransformer parentTransformer, Field field) {
        Transformer componentTransformer;
        super.initialize(parentTransformer, field);
        this.setComponentType(field.getType().getComponentType());
        Class<?> prefTransformerClass = null;
        Sequence sequence = field.getAnnotation(Sequence.class);
        if (sequence != null) {
            String prefTransformerClassName;
            if (sequence.codec() != null && sequence.codec().encoder() != null && (prefTransformerClassName = sequence.codec().encoder()) != null && prefTransformerClassName.length() > 0) {
                try {
                    prefTransformerClass = Class.forName(prefTransformerClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        } else {
            throw new IllegalStateException("Sequence annotation should be used with array element!");
        }
        if ((componentTransformer = parentTransformer.createTransformer(this.componentType, prefTransformerClass)) == null) {
            throw new IllegalStateException("Can not find decoder for type: " + this.componentType);
        }
        this.setConfig(sequence);
        this.setComponentEncoder(componentTransformer);
    }

    @Override
    public TransformationResult<Buffer> transform(AttributeStorage storage, E input, Buffer output) throws TransformationException {
        if (input == null) {
            throw new TransformationException("Input should not be null");
        }
        MemoryManager memoryManager = null;
        boolean isAllocated = false;
        if (output == null) {
            memoryManager = this.obtainMemoryManager(storage);
            if (memoryManager != null) {
                output = memoryManager.allocate(1024);
                isAllocated = true;
            } else {
                throw new TransformationException("Output Buffer is null and there is no way to allocate one");
            }
        }
        while (this.next(storage, input)) {
            Object element = this.get(storage, input);
            TransformationResult<Buffer> result = this.componentEncoder.transform(storage, element, output);
            TransformationResult.Status status = result.getStatus();
            if (status == TransformationResult.Status.COMPLETED) {
                this.componentEncoder.release(storage);
                continue;
            }
            if (status == TransformationResult.Status.INCOMPLED) {
                if (isAllocated) {
                    output = memoryManager.reallocate(output, output.capacity() * 2);
                    this.previous(storage, input);
                    continue;
                }
                this.saveState(storage, incompletedResult);
                return incompletedResult;
            }
            return result;
        }
        TransformationResult<Buffer> result = new TransformationResult<Buffer>(TransformationResult.Status.COMPLETED, output.duplicate().flip());
        this.saveState(storage, result);
        return result;
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public void setComponentType(Class componentClass) {
        this.componentType = componentClass;
    }

    public Transformer getComponentEncoder() {
        return this.componentEncoder;
    }

    public void setComponentEncoder(Transformer elementDecoder) {
        this.componentEncoder = elementDecoder;
    }

    public Sequence getConfig() {
        return this.config;
    }

    public void setConfig(Sequence config) {
        this.config = config;
    }

    protected void saveState(AttributeStorage storage, TransformationResult<Buffer> lastResult) {
        this.lastResultAttribute.set(storage, lastResult);
    }
}

