/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone;

import com.sun.grizzly.TransportFactory;
import com.sun.grizzly.filterchain.TransportFilter;
import com.sun.grizzly.http.WebFilter;
import com.sun.grizzly.http.WebFilterConfig;
import com.sun.grizzly.nio.transport.TCPNIOTransport;
import com.sun.grizzly.standalone.StaticHandler;
import com.sun.grizzly.strategies.LeaderFollowerStrategy;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.ExpandJar;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;

public abstract class StandaloneMainUtil {
    private static int port = 8080;
    private TCPNIOTransport transport;

    public void start(String[] args) throws Exception {
        WebFilter webFilter = this.createWebFilter(args);
        this.transport = TransportFactory.getInstance().createTCPTransport();
        this.transport.getFilterChain().add(new TransportFilter());
        this.transport.getFilterChain().add(webFilter);
        this.transport.setSelectorRunnersCount(Runtime.getRuntime().availableProcessors());
        this.transport.setStrategy(new LeaderFollowerStrategy(this.transport));
        try {
            webFilter.initialize();
            this.transport.bind(port);
            this.transport.start();
        }
        catch (Exception ex) {
            WebFilter.logger().log(Level.WARNING, "", ex);
        }
    }

    public void stop() throws Exception {
        if (this.transport != null) {
            this.transport.stop();
        }
    }

    public WebFilter createWebFilter(String[] args) throws Exception {
        if (args.length == 0) {
            this.printHelpAndExit();
        }
        this.parseOptions(args);
        String appliPath = this.parseApplicationLocation(args);
        appliPath = this.appendWarContentToClassPath(appliPath);
        WebFilterConfig webConfig = new WebFilterConfig();
        webConfig.setAdapter(this.configureAdapter(webConfig));
        webConfig.setDisplayConfiguration(true);
        webConfig.setWebAppRootPath(appliPath);
        WebFilter<WebFilterConfig> webFilter = new WebFilter<WebFilterConfig>("MyHtttpServer", webConfig);
        webConfig.setInterceptor(new StaticHandler(webFilter));
        return webFilter;
    }

    public String appendWarContentToClassPath(String appliPath) throws MalformedURLException, IOException {
        String separator;
        String path;
        File file = null;
        URL appRoot = null;
        URL classesURL = null;
        if (appliPath != null && (appliPath.endsWith(".war") || appliPath.endsWith(".jar"))) {
            file = new File(appliPath);
            appRoot = new URL("jar:file:" + file.getCanonicalPath() + "!/");
            classesURL = new URL("jar:file:" + file.getCanonicalPath() + "!/WEB-INF/classes/");
            path = ExpandJar.expand(appRoot);
        } else {
            path = appliPath;
            classesURL = new URL("file://" + path + "WEB-INF/classes/");
            appRoot = new URL("file://" + path);
        }
        String absolutePath = new File(path).getAbsolutePath();
        WebFilter.logger().info("Servicing resources from: " + absolutePath);
        URL[] urls = null;
        File libFiles = new File(absolutePath + File.separator + "WEB-INF" + File.separator + "lib");
        int arraySize = appRoot == null ? 1 : 2;
        String string = separator = System.getProperty("os.name").toLowerCase().startsWith("win") ? "/" : "//";
        if (libFiles.exists() && libFiles.isDirectory()) {
            urls = new URL[libFiles.listFiles().length + arraySize];
            for (int i = 0; i < libFiles.listFiles().length; ++i) {
                urls[i] = new URL("jar:file:" + separator + libFiles.listFiles()[i].toString().replace('\\', '/') + "!/");
            }
        } else {
            urls = new URL[arraySize];
        }
        urls[urls.length - 1] = classesURL;
        urls[urls.length - 2] = appRoot;
        URLClassLoader urlClassloader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(urlClassloader);
        return path;
    }

    public void setPort(String num) {
        try {
            port = Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            System.err.println("Illegal port number -- " + num);
            this.printHelpAndExit();
        }
    }

    public abstract void printHelpAndExit();

    public abstract boolean parseOptions(String[] var1);

    public abstract Adapter configureAdapter(WebFilterConfig var1);

    public abstract String parseApplicationLocation(String[] var1);
}

