/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.streams;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.CompletionHandler;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.impl.FutureImpl;
import com.sun.grizzly.streams.StreamReader;
import com.sun.grizzly.utils.conditions.Condition;
import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.LinkedList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public abstract class AbstractStreamReader
implements StreamReader {
    private static final boolean DEBUG = false;
    private static Logger logger = Grizzly.logger;
    private boolean isBlocking;
    private Connection connection;
    protected int bufferSize = 8192;
    protected long timeoutMillis = 30000L;
    protected final Object sync = new Object();
    protected LinkedList dataRecords;
    private int queueSize;
    private Object current;
    private boolean closed;
    protected NotifyObject notifyObject;

    private static void msg(String msg) {
        logger.info("READERSTREAM:DEBUG:" + msg);
    }

    private static void msg(Exception exc) {
        AbstractStreamReader.msg("Exception:" + exc);
        exc.printStackTrace();
    }

    private static void displayBuffer(String str, Buffer wrapper) {
        AbstractStreamReader.msg(str);
        AbstractStreamReader.msg("\tposition()     = " + wrapper.position());
        AbstractStreamReader.msg("\tlimit()        = " + wrapper.limit());
        AbstractStreamReader.msg("\tcapacity()     = " + wrapper.capacity());
    }

    public AbstractStreamReader() {
        this(null);
    }

    protected AbstractStreamReader(Connection connection) {
        this.setConnection(connection);
        this.dataRecords = new LinkedList();
        this.queueSize = 0;
        this.current = null;
        this.closed = false;
        if (this.timeoutMillis < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative.");
        }
    }

    @Override
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Override
    public void setBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    @Override
    public boolean prependBuffer(Buffer buffer) {
        return this.prepend(this.wrap(buffer));
    }

    protected boolean prepend(Object data) {
        if (data == null) {
            return false;
        }
        Buffer buffer = this.unwrap(data);
        if (this.closed) {
            buffer.dispose();
        } else {
            if (buffer.hasRemaining()) {
                if (this.current == null) {
                    this.current = data;
                } else {
                    this.dataRecords.addFirst(data);
                    this.queueSize += buffer.remaining();
                }
            }
            this.notifyCondition();
        }
        return true;
    }

    @Override
    public boolean appendBuffer(Buffer buffer) {
        return this.append(this.wrap(buffer));
    }

    protected boolean append(Object data) {
        if (data == null) {
            return false;
        }
        Buffer buffer = this.unwrap(data);
        if (this.closed) {
            buffer.dispose();
        } else {
            if (buffer.hasRemaining()) {
                if (this.current == null) {
                    this.current = data;
                } else {
                    this.dataRecords.addLast(data);
                    this.queueSize += buffer.remaining();
                }
            }
            this.notifyCondition();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCondition() {
        Object object = this.sync;
        synchronized (object) {
            if (this.notifyObject != null && this.notifyObject.condition.check(this)) {
                NotifyObject localNotifyAvailObject = this.notifyObject;
                this.notifyObject = null;
                this.notifySuccess(localNotifyAvailObject.future, localNotifyAvailObject.completionHandler, this.availableDataSize());
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.current != null) {
            this.unwrap(this.current).dispose();
            this.current = null;
        }
        if (this.dataRecords != null) {
            for (Object record : this.dataRecords) {
                this.unwrap(record).dispose();
            }
            this.dataRecords = null;
        }
        this.queueSize = 0;
        if (this.notifyObject != null) {
            NotifyObject localNotifyAvailObject = this.notifyObject;
            this.notifyObject = null;
            this.notifyFailure(localNotifyAvailObject.future, localNotifyAvailObject.completionHandler, new EOFException());
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private int currentAvailable() {
        if (this.current == null) {
            return 0;
        }
        return this.unwrap(this.current).remaining();
    }

    private boolean checkRemaining(int size) throws IOException {
        if (this.current == null || !this.unwrap(this.current).hasRemaining()) {
            this.ensureRead();
        }
        return this.unwrap(this.current).remaining() >= size;
    }

    protected void ensureRead() throws IOException {
        this.ensureRead(true);
    }

    protected void ensureRead(boolean readIfEmpty) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("ByteBufferReader is closed");
        }
        Object next = this.poll();
        if (next == null) {
            if (readIfEmpty) {
                Object data = this.read0();
                if (data != null) {
                    this.append(data);
                    next = this.poll();
                }
                if (next == null) {
                    throw new BufferUnderflowException();
                }
            } else {
                return;
            }
        }
        if (this.current != null) {
            this.unwrap(this.current).dispose();
        }
        this.current = next;
    }

    protected Buffer pollBuffer() {
        if (!this.dataRecords.isEmpty()) {
            Object data = this.dataRecords.removeFirst();
            Buffer buffer = this.unwrap(data);
            this.queueSize -= buffer.remaining();
            return buffer;
        }
        return null;
    }

    protected Object poll() {
        if (!this.dataRecords.isEmpty()) {
            Object data = this.dataRecords.removeFirst();
            this.queueSize -= this.unwrap(data).remaining();
            return data;
        }
        return null;
    }

    @Override
    public final boolean hasAvailableData() {
        return this.availableDataSize() > 0;
    }

    @Override
    public int availableDataSize() {
        return this.queueSize + this.currentAvailable();
    }

    @Override
    public boolean readBoolean() throws IOException {
        if (!this.checkRemaining(1)) {
            this.ensureRead();
        }
        return this.unwrap(this.current).get() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        if (!this.checkRemaining(1)) {
            this.ensureRead();
        }
        return this.unwrap(this.current).get();
    }

    @Override
    public char readChar() throws IOException {
        if (this.checkRemaining(2)) {
            return this.unwrap(this.current).getChar();
        }
        return (char)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    @Override
    public short readShort() throws IOException {
        if (this.checkRemaining(2)) {
            return this.unwrap(this.current).getShort();
        }
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    @Override
    public int readInt() throws IOException {
        if (this.checkRemaining(4)) {
            return this.unwrap(this.current).getInt();
        }
        return (this.readShort() & 0xFFFF) << 16 | this.readShort() & 0xFFFF;
    }

    @Override
    public long readLong() throws IOException {
        if (this.checkRemaining(8)) {
            return this.unwrap(this.current).getLong();
        }
        return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public final float readFloat() throws IOException {
        if (this.checkRemaining(4)) {
            return this.unwrap(this.current).getFloat();
        }
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        if (this.checkRemaining(8)) {
            return this.unwrap(this.current).getDouble();
        }
        return Double.longBitsToDouble(this.readLong());
    }

    private void arraySizeCheck(int sizeInBytes) {
        if (!this.isBlocking && this.timeoutMillis == 0L && sizeInBytes > this.availableDataSize()) {
            throw new BufferUnderflowException();
        }
    }

    @Override
    public void readBooleanArray(boolean[] data) throws IOException {
        this.arraySizeCheck(data.length);
        for (int ctr = 0; ctr < data.length; ++ctr) {
            data[ctr] = this.readBoolean();
        }
    }

    @Override
    public void readByteArray(byte[] data) throws IOException {
        this.readByteArray(data, 0, data.length);
    }

    @Override
    public void readByteArray(byte[] data, int offset, int length) throws IOException {
        int dataSizeToRead;
        this.arraySizeCheck(length);
        do {
            this.checkRemaining(1);
            Buffer typedBuffer = this.unwrap(this.current);
            dataSizeToRead = length;
            if (dataSizeToRead > typedBuffer.remaining()) {
                dataSizeToRead = typedBuffer.remaining();
            }
            typedBuffer.get(data, offset, dataSizeToRead);
            offset += dataSizeToRead;
        } while ((length -= dataSizeToRead) != 0);
    }

    @Override
    public void readBytes(Buffer buffer) throws IOException {
        Buffer typedBuffer;
        buffer.reset();
        this.arraySizeCheck(buffer.remaining());
        while (true) {
            this.checkRemaining(1);
            typedBuffer = this.unwrap(this.current);
            if (buffer.remaining() <= typedBuffer.remaining()) break;
            buffer.put(typedBuffer);
        }
        int save = typedBuffer.limit();
        typedBuffer.limit(buffer.remaining());
        Buffer tail = typedBuffer.slice();
        typedBuffer.limit(save);
        buffer.put(tail);
    }

    @Override
    public void readCharArray(char[] data) throws IOException {
        this.arraySizeCheck(2 * data.length);
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.readChar();
        }
    }

    @Override
    public void readShortArray(short[] data) throws IOException {
        this.arraySizeCheck(2 * data.length);
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.readShort();
        }
    }

    @Override
    public void readIntArray(int[] data) throws IOException {
        this.arraySizeCheck(4 * data.length);
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.readInt();
        }
    }

    @Override
    public void readLongArray(long[] data) throws IOException {
        this.arraySizeCheck(8 * data.length);
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.readLong();
        }
    }

    @Override
    public void readFloatArray(float[] data) throws IOException {
        this.arraySizeCheck(4 * data.length);
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.readFloat();
        }
    }

    @Override
    public void readDoubleArray(double[] data) throws IOException {
        this.arraySizeCheck(8 * data.length);
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.readDouble();
        }
    }

    @Override
    public Future<Integer> notifyAvailable(int size) {
        return this.notifyAvailable(size, null);
    }

    @Override
    public Future<Integer> notifyAvailable(final int size, CompletionHandler<Integer> completionHandler) {
        return this.notifyCondition(new Condition<StreamReader>(){

            @Override
            public boolean check(StreamReader reader) {
                return reader.availableDataSize() >= size;
            }
        }, completionHandler);
    }

    @Override
    public Future<Integer> notifyCondition(Condition<StreamReader> condition) {
        return this.notifyCondition(condition, null);
    }

    private void notifySuccess(FutureImpl<Integer> future, CompletionHandler<Integer> completionHandler, int size) {
        if (completionHandler != null) {
            completionHandler.completed(this.getConnection(), size);
        }
        future.setResult(size);
    }

    private void notifyFailure(FutureImpl<Integer> future, CompletionHandler<Integer> completionHandler, Throwable e) {
        if (completionHandler != null) {
            completionHandler.failed(this.getConnection(), e);
        }
        future.failure(e);
    }

    @Override
    public Buffer readBuffer() throws IOException {
        this.checkRemaining(1);
        Buffer retBuffer = this.unwrap(this.current);
        this.current = null;
        return retBuffer;
    }

    @Override
    public Buffer getBuffer() {
        return this.unwrap(this.current());
    }

    protected Object current() {
        if (this.current == null) {
            try {
                this.ensureRead(false);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected exception");
            }
        }
        return this.current;
    }

    @Override
    public void finishBuffer() {
        Object next = this.poll();
        if (next != null) {
            this.queueSize -= this.unwrap(next).remaining();
        }
        this.current = next;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        if (connection != null) {
            this.bufferSize = connection.getReadBufferSize();
            this.isBlocking = connection.isBlocking();
        }
        this.connection = connection;
    }

    protected Buffer newBuffer(int size) {
        return this.getConnection().getTransport().getMemoryManager().allocate(size);
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    @Override
    public long getTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setTimeout(long timeout, TimeUnit timeunit) {
        this.timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
    }

    protected abstract Object read0() throws IOException;

    protected abstract Object wrap(Buffer var1);

    protected abstract Buffer unwrap(Object var1);

    protected static class NotifyObject {
        private FutureImpl<Integer> future;
        private CompletionHandler<Integer> completionHandler;
        private Condition<StreamReader> condition;

        public NotifyObject(FutureImpl<Integer> future, CompletionHandler<Integer> completionHandler, Condition<StreamReader> condition) {
            this.future = future;
            this.completionHandler = completionHandler;
            this.condition = condition;
        }
    }
}

